rng = Random.default_rng()
Random.seed!(99)

#No Noise forecasting from eta = 0 to the 90th element of the domain etaspan = (0.05, 5.325)


#Constants
C = 0.01


#Initial Conditions
I = [1.0, 0.0]   #Psi(0)=1, Psi'(0)=1
etaspan = (0.05, 5.325)

#radius range
datasize= 100
etasteps = range(etaspan[1], etaspan[2]; length = datasize)


function whitedwarf(du, u, p, r)
    psi = u[1]
    dpsi = u[2]
    du[1] = dpsi
    du[2] = (-((psi^2-C))^(3/2) - 2/r * dpsi)
end


#Defining the Ordinary differential equation as an ODEProblem with the DifferentialEquations.jl
prob = ODEProblem(whitedwarf, I, etaspan)
#Solving the ODEProblem with the Tsit5() algorithm
sol = solve(prob,saveat=etasteps)



dudt2 = Lux.Chain(Lux.Dense(2, 80, tanh),Lux.Dense(80, 80, tanh), Lux.Dense(80, 2))
#Setting up the NN parameters randomly using the rng instance
p, st = Lux.setup(rng, dudt2)

etasteps =  etasteps[1:end-90]
etaspan = (etasteps[1], etasteps[end])
I=[1.0,0.0]
prob_neuralode = NeuralODE(dudt2, etaspan, Tsit5(); saveat = etasteps)

function predict_neuralode(p)
    Array(prob_neuralode(I, p, st)[1])
end
#Training data
true_data= Array(sol[:,1:end-90])
### Define loss function as the difference between actual ground truth data and Neural ODE prediction
function loss_neuralode(p)
    pred = predict_neuralode(p)
    loss = sum(abs2, true_data .- pred)
    return loss, pred
end

p_trained_nonoise =  (layer_1 = (weight = Float32[-0.41735792 0.33838898; 0.792316 -0.2425517; 0.5461062 -0.14006342; 0.4885758 -0.028416054; -0.75631356 0.32290488; 0.7858258 -0.36927292; 0.019408194 -0.2845491; 0.14935374 -0.121802606; 0.2414266 -0.25611836; -0.34797147 -0.1542979; -0.37219387 0.08101263; 1.0946814 -0.063731015; -0.46316004 0.15967475; 0.5784225 -0.113777265; 0.5137349 0.008869955; -0.3641871 0.26442575; 0.024525216 -0.12250701; 0.5934265 -0.32004538; 0.51655734 -0.40504768; 0.3078492 -0.26488242; -0.015811494 0.17171192; 0.3277201 -0.0729466; -0.10402794 0.12955599; -0.15356438 -0.07883495; -0.14930545 0.4096673; 0.20376314 -0.25848743; 0.20786901 0.0980701; -0.08273927 -0.11521808; 0.03922842 0.11348739; -0.30310255 0.31767854; 0.18635142 -0.019485908; 0.36055997 -0.09775598; 0.6954298 -0.09781887; -0.33658263 0.12336551; 0.2879597 -0.2564736; 0.65275174 -0.2375817; 0.13507883 0.14907378; 0.16498381 -0.012664626; 0.4516874 -0.07868359; 0.31657362 -0.026007453; -0.7472932 0.08667191; 0.036665067 -0.07089436; 0.8232278 -0.32264665; 0.34816784 -0.06289612; -0.24222267 0.08691096; 0.10502539 -0.24456017; -0.2234595 0.052549526; -0.21121453 0.054377735; 0.56760776 -0.3626027; 0.16579224 0.12915875; -0.0181732 -0.18243282; -0.364999 -0.22475822; -0.49705374 0.338533; -0.6979955 0.16046116; 0.29520848 -0.17562449; -0.10302231 0.11198631; 0.06623092 0.17116803; 0.06733953 0.15749575; 0.06657399 -0.075537294; -0.27039617 0.47427848; -0.33425865 0.16133203; 0.09567813 0.25146472; 0.33854902 -0.053658348; 0.52154565 -0.18674567; 0.3113429 -0.4476961; 0.07176743 0.20529701; 0.08554566 0.08078745; -0.20510714 0.09492346; -0.259198 -0.17981201; -0.3957309 0.2271177; -0.43163133 0.29818374; 0.34893483 0.08115189; 0.5313276 -0.17161275; 0.69977134 -0.34740004; 0.2193548 0.03907451; -0.14483982 -0.08714266; 0.13273054 -0.06814013; 0.07415469 -0.25644967; 0.12994511 0.13465706; 0.27848122 0.13123849], bias = Float32[0.04911966; 0.18511026; 0.10535892; -0.15422629; -0.086971276; -0.03791024; 0.15381368; 0.14461492; 0.23765287; 0.11179311; 0.08361814; -0.23767143; -0.21522152; -0.17276968; -0.097345315; 0.018817654; 0.024317205; -0.17707756; 0.13709378; 0.082582094; 0.25612485; -0.30868852; 0.12890157; 0.19592698; 0.20346558; 0.15898342; -0.03150625; 0.19894204; -0.10744203; -0.15979144; -0.16111054; -0.115708485; 0.06903213; 0.2134051; -0.34002078; 0.14000358; -0.051271006; 0.23985097; -0.062108893; -0.16804102; 0.09598769; 0.022476425; -0.0026051009; -0.24585795; 0.14069386; -0.05015365; 0.31056252; 0.049973954; 0.045959592; -0.069727; 0.076922596; -0.15084562; -0.10457642; 0.2029441; 0.18222483; 0.059481803; -0.066498704; -0.060263846; -0.2959916; 0.10975327; 0.21098; -0.091009915; -0.08312141; 0.18898427; -0.15469484; -0.031909112; -0.096153855; -0.22060943; 0.011067934; 0.017524354; -0.0546445; -0.16961995; 0.22656243; 0.10158544; 0.0022096415; 0.03125251; -0.30885422; 0.07116149; -0.088271394; -0.11096183]), layer_2 = (weight = Float32[0.012314578 0.09561715 -0.061462827 -0.09470611 -0.16344611 0.32100624 -0.07344345 -0.17835198 0.13539332 0.047966897 -0.09265216 0.08661006 -0.045567725 0.11356733 0.13983798 0.17169009 -0.1579815 0.1822199 0.07861605 0.0854347 0.101196446 -0.041209213 -0.16119835 0.10472711 -0.33947444 -0.020641942 -0.088346265 -0.11592282 0.03393032 -0.094841965 0.23000444 0.17723659 -0.014993384 -0.034252856 -0.010913181 0.11675207 -0.034258883 -0.15601829 0.0040537957 -0.09708424 -0.12471764 0.055895973 -0.07655783 0.2329907 -0.19630134 -0.029016983 -0.10793526 -0.17654707 0.16145544 -0.07775361 -0.16230007 0.12753618 -0.057342928 -0.09433114 0.066782236 0.0629282 0.17834444 -0.045222845 0.06764311 -0.25771353 -0.17777137 -0.06502861 -0.108548045 0.010336516 0.041986845 -0.07283651 0.0735441 -0.036170404 0.09417814 0.066970766 -0.19572836 -0.12778008 0.1916207 -0.14239551 0.07730786 -0.12992191 -0.02495761 0.0016511527 -0.0051125907 0.081474796; 0.097071305 -0.046760697 -0.07763331 -0.021234274 -0.31687555 0.28770944 0.008681893 -0.1297592 -0.09701686 0.0484224 -0.12792285 0.09338672 0.07831376 0.14640829 0.17744276 0.14515445 0.15326715 0.08183067 0.10007309 -0.056620624 0.059076197 0.14905472 -0.061653428 -0.058413826 -0.29079014 -0.0049635237 0.033965606 -0.08623285 0.17729782 -0.10102464 0.1070648 0.17832775 0.0047504352 -0.04765343 0.053340957 -0.008944495 0.15495351 -0.08084396 -0.02525769 -0.053814936 0.028173856 0.22941674 -0.073139675 0.1954007 -0.07929561 -0.08260855 0.009387422 -0.0022977907 0.09441134 -0.053728353 -0.14590915 -0.063760445 0.07818056 -0.017603284 -0.07284625 0.088661745 -0.12448582 -0.09039524 -0.06370246 -0.003311443 -0.15280066 -0.08356144 -0.079743095 0.1942534 -0.065904416 -0.0390199 0.17042564 0.12149518 0.16045804 -0.2852032 -0.24256866 0.07608791 0.07544292 -0.04981563 0.07280402 -0.12190707 0.19458283 0.1128417 -0.12640841 -0.120173745; 0.060913593 0.027042586 -0.000666748 0.016764209 0.04211335 0.14850846 0.15133482 -0.04097183 -0.10909897 0.12008914 0.011276664 -0.0006136856 -0.007881535 -0.09706184 -0.14303808 -0.11736678 -0.14927495 -0.11214039 0.13633525 -0.04504299 -0.24198271 0.01657143 0.00056354405 0.015830893 -0.26130733 0.06771891 -0.10373356 0.032809433 -0.11132182 0.09384411 -0.11622622 -0.10135771 0.06364242 -0.18536742 -0.11781491 -0.2069779 -0.044536818 -0.19840768 0.079075836 0.03981056 0.11180212 0.054310203 0.07139653 -0.03514197 -0.023773972 0.0021679117 -0.16702282 -0.004641038 -0.12812284 -0.100115374 -0.069271676 0.19793132 -0.010574571 -0.20545462 -0.22960049 0.013570019 0.103788994 0.07335321 0.13390586 -0.1289356 0.06815836 0.16680045 0.14914307 -0.1161498 0.006695096 0.013808161 -0.0128996605 0.088981576 -0.059725236 -0.24438494 -0.060571373 -0.1924748 0.1358468 -0.024203716 -0.09884387 0.18440929 0.18189655 -0.050160665 0.037141968 0.17405929; -0.018574467 -0.087704316 0.20496035 0.06481993 0.07496302 -0.11901431 -0.2946537 -0.026718458 -0.22936578 0.037045825 -0.09694221 -0.098069444 0.061959635 -0.10137114 -0.22225419 -0.057107937 0.10841385 -0.07879007 -0.12691502 0.012423881 -0.007520679 0.02237428 -0.08382508 -0.05655896 -0.0017419296 -0.14226906 0.08270895 0.20746827 -0.015435817 0.14613701 -0.024707751 -0.19191594 0.18200675 -0.11396831 -0.22835426 -0.19606993 0.123635665 0.059088774 -0.110066906 -0.1682091 -0.0062990193 0.017905705 -0.20370251 0.09325526 0.032808386 0.0508253 0.22784537 0.25813812 -0.016440462 -0.14322293 0.11868549 -0.07599325 0.08840724 -0.076111495 0.10208235 0.074619316 0.028202837 -0.091105275 -0.21799034 0.0755096 -0.06495649 0.15095206 0.041250058 0.04278453 -0.03050803 -0.032721564 -0.09227657 -0.14885484 0.14093508 -0.0901529 0.1821282 -0.009409362 -0.0829979 -0.062341917 -0.022551974 -0.0051823305 0.049889013 -0.1258499 -0.0051288903 -0.11609287; 0.11128308 0.20737232 0.027903033 -0.21997267 -0.1642281 -0.038094256 0.00905141 0.06612787 0.061123013 0.098248 0.16811949 -0.21188574 0.1123853 -0.06404106 -0.11073944 -0.08643705 0.09340742 0.026575416 -0.11514008 -0.06357831 0.25604683 0.026869502 0.16377056 0.2459143 0.12056154 0.2150348 0.017716266 -0.0023040597 0.10355139 -0.06990582 -0.12553088 -0.11508904 0.14860904 0.14002165 -0.2391344 0.16856019 -0.101783216 0.15798207 -0.29452634 -0.0344566 0.08648025 -0.009620211 -0.100069344 -0.13766684 0.1701192 -0.09384722 0.24593414 0.05975253 0.13701078 -0.111982055 0.23885655 -0.10833451 0.03130267 0.15241629 0.054354616 0.09179202 0.014046524 0.12768662 -0.0069767125 0.08790345 -0.027419832 0.05466536 -0.099166885 0.1587816 -0.17737263 -0.041481998 0.074311994 -0.25045687 0.13746913 -0.17958675 -0.021019282 -0.043548804 0.12850478 0.23009953 -0.073744185 0.07608883 -0.11468133 0.056368556 -0.06408746 0.10769763; 0.16247272 -0.122773826 -0.08344188 0.06875995 -0.0065015033 0.022170214 0.10777858 0.12216255 0.13492684 0.086688034 0.15899508 0.05825874 -0.10068039 -0.11809004 0.01449809 0.010347817 0.124271244 -0.051156584 0.06740344 -0.26242828 0.2493747 -0.10084679 -0.037217226 0.10116501 0.1312456 -0.17510213 -0.18100454 -0.15613785 0.129567 0.19826233 -0.17334 -0.020331826 0.122541614 0.18186682 -0.23893598 0.084063664 -0.22464193 -0.12608968 -0.13191251 0.104422115 0.060667634 0.03517688 -0.15963696 -0.13983665 0.13445802 -0.27440128 0.12866537 0.051417463 0.007323523 0.100853324 -0.1408302 -0.17739555 0.015036884 0.08320612 0.07782733 0.10330266 -0.22314994 -0.0017149934 -0.24334802 0.20045006 -0.09863177 -0.12260547 -0.09763626 -0.027576668 -0.11665569 0.0086344965 0.10473008 0.11762657 -0.033702634 -0.02086466 -0.0027347286 -0.19872808 0.108030625 -0.084710166 -0.087209985 0.10526161 0.072151065 -0.12124351 -0.08172328 0.035599403; -0.032062635 -0.11369815 0.10704867 -0.19471252 -0.12635317 -0.29118302 0.009378363 0.097288504 0.08803415 0.14055091 0.1821399 -0.13274221 -0.19530144 0.0020451418 -0.06897448 -0.10244082 -0.09402458 -0.09267445 -0.073879994 -0.08589572 0.1576777 0.11862455 0.108472146 0.10766841 0.2400689 0.20327345 -0.17391655 0.13866894 0.025930474 -0.09500355 -0.17749472 -0.06440814 -0.08991307 -0.012751501 -0.21641839 -0.03955028 0.12721644 0.072597496 -0.14560157 0.14970222 0.24956945 0.014599601 0.06406792 0.071202435 0.0533908 -0.22370988 -0.005589671 -0.028454654 0.054567255 -0.08900199 -0.034435503 -0.0024452007 0.21160588 -0.089499585 -0.0038825877 -0.20336366 -0.03759974 0.15443592 -0.11846827 0.122708894 -0.041216355 0.130311 -0.14701135 -0.1072216 -0.25110596 -0.09035609 -0.15524338 0.07187071 0.08956131 -0.048921574 -0.019368501 0.10028558 0.044511985 -0.1397372 0.01367606 0.1033217 -0.22826992 -0.01813454 0.06906179 -0.13385038; 0.005710349 -0.2042796 -0.08964077 0.038801007 -0.039904512 0.10398672 -0.122838564 -0.032495547 -0.14532766 -0.13445613 -0.21270983 -0.12929197 -0.011905389 0.114428304 -0.013661475 0.09033376 -0.20333843 0.2161182 0.022697939 0.283902 0.0837732 0.012039968 0.0432027 0.12547928 -0.30345634 -0.032379165 0.08873832 -0.06800806 -0.113669254 -0.030936312 -0.08745248 0.17308976 0.11245282 -0.2102846 0.06672223 0.12898584 0.20943367 -0.2218966 0.074185446 -0.002965482 0.13497216 -0.16006316 0.04249465 0.2397362 -0.10888045 0.32573387 -0.17873377 -0.11683427 0.19372268 -0.10426414 -0.11971091 -0.03615369 0.080664985 0.14793943 0.05962575 0.010778507 0.21076389 -0.05911086 0.019199869 -0.064536504 -0.2449342 -0.04066854 -0.06192569 -0.053176064 0.1432809 -0.11667928 -0.11583393 0.021614546 0.067828014 -0.037957177 -0.2167824 0.1981214 -0.1752625 0.037507843 0.149755 -0.06567461 0.124181874 -0.07387873 0.101019405 0.008434941; -0.12941457 0.09003488 -0.0013279305 0.12347849 -0.2835652 0.28550172 0.11815546 -0.12659384 0.0300146 -0.0009401814 0.032465637 0.11709246 -0.05251268 -0.08601878 -0.0476257 0.15186091 0.046994768 0.050050005 0.2582722 -0.041144963 -0.19174474 0.053420622 0.027024454 0.01013626 -0.21736036 0.116487086 0.1911583 0.19305265 0.1629527 0.017442089 -0.048904553 -0.073060215 -0.17681201 -0.17543836 0.22648294 0.029209904 0.14235699 0.12157475 0.20940067 0.14512494 -0.11282416 0.23729838 0.13832785 0.08635389 -0.14000753 -0.012825301 0.15086909 -0.07065253 0.20941472 -0.0022767473 0.15246913 0.0883408 -0.02235674 -0.18261567 -0.036612533 -0.139783 -0.13614918 0.038983792 0.14611754 -0.15191697 -0.15942477 -0.02358056 -0.0023252836 0.2242147 0.03701084 0.13619524 0.14958946 0.19578342 0.050077785 -0.19454935 -0.14688155 0.22706987 -0.027008146 -0.023817685 -0.13101324 0.006587811 0.13665017 -0.09363426 -0.052839026 0.009990194; 0.020222604 0.13068384 0.20552695 0.026331177 -0.15350817 0.27018052 0.07638702 -0.2893005 0.27892938 0.011922959 0.054092087 0.11691854 0.05784656 0.06682187 -0.050493717 0.018758493 -0.13423648 0.06312626 0.28213543 0.028435873 -0.24950998 -0.04530807 -0.032750122 -0.12368296 -0.05109708 -0.059361916 0.23238832 0.0132830795 -0.032252174 -0.28849036 0.3119723 -0.05375215 -0.12987135 -0.18555476 0.2766896 0.13453528 0.081319794 0.0010058966 0.08680656 -0.008920175 0.06602749 0.06031854 0.22350463 0.015254116 -0.062479306 0.18380253 -0.13650522 -0.12714343 0.17907657 -0.06805202 -0.102887735 0.17956373 -0.19175817 -0.12588769 0.18992946 -0.08529892 -0.0025515633 0.031436063 0.29752418 -0.23099665 0.06651595 -0.14289126 -0.08849015 0.16125922 0.10087751 0.09236616 0.0027162074 0.04198516 0.014695319 0.0427042 -0.28811222 -0.08361039 0.11691143 0.0069703236 -0.011370471 -0.14903036 0.30043772 -0.09262252 -0.06947094 -0.073401295; -0.09518274 -0.028658947 0.004439981 0.07818533 -0.13917714 0.066239096 -0.10439127 -0.090350434 0.09163206 -0.16032456 -0.11804384 0.092429556 0.17056699 -0.04889876 -0.055013936 0.068567626 0.058243487 0.12080099 -0.05489087 0.10000864 -0.047050156 0.16481568 -0.12848273 0.08465235 -0.114968345 -0.18303889 -0.14839144 -0.1620239 0.0054110033 -0.068084 0.12039116 0.06200925 0.09997566 0.061291594 -0.052549183 0.041908808 -0.03149469 -0.018997876 -0.02899182 0.100625075 -0.0747824 -0.15325157 0.1287221 0.040564608 -0.16591282 0.22031297 -0.21218458 -0.14811957 -0.0044356924 0.10798742 -0.094942085 0.06872003 0.011219842 -0.13291728 0.10043841 0.16258296 -0.012433584 -0.022018552 0.06709271 -0.1361128 -0.15735437 0.15262176 0.12629852 0.149732 0.14741175 -0.20899527 0.05291189 0.081887946 0.022738539 -0.21459876 -0.0888406 0.14272098 0.08583018 -0.18010823 -0.07691875 0.06227954 -0.04580291 0.012475539 -0.0004979255 0.15703388; 0.053156644 -0.087009266 -0.036940016 -0.11796742 -0.12265636 -0.1812616 -0.0012823353 0.018579109 0.037813492 -0.07794049 0.04234035 -0.020429697 -0.12501772 0.025121223 -0.24595064 -0.0075574364 0.22038376 0.0197407 0.032147776 0.031109866 0.09611306 -0.15175258 0.17751978 0.06137154 0.06969758 -0.09598677 0.007839512 -0.086355254 -0.09135954 0.0064435666 0.06744451 -0.047420684 0.04467073 -0.054963127 -0.08110663 0.19636299 -0.09296524 0.1382739 -0.26137465 -0.16905522 0.18006155 -0.18739322 -0.004318479 0.006075071 0.06680481 0.19720903 0.08293863 0.14873478 0.16040942 -0.10281186 -0.10441351 -0.054889467 0.033516552 0.0021430724 0.25192678 -0.11958609 -0.17698108 -0.058526676 -0.03723651 -0.033337492 0.08498356 -0.08672916 -0.27523854 -0.0011653391 0.017367149 -0.21920314 -0.1947023 0.041950963 0.22857654 0.0069251265 0.14009602 -0.13008524 -0.028255615 -0.11049943 -0.013946092 -0.052760676 -0.22916172 0.12284376 -0.006525523 -0.042354252; 0.109295875 0.22733362 -0.07404396 0.04205467 -0.010092879 0.07834072 0.001826634 -0.14182147 0.23242731 -0.18148023 -0.20434572 0.0053688516 -0.13286315 0.068286 -0.010626477 0.0031368656 -0.1697319 -0.02805929 0.106855206 0.032988414 0.009986415 0.071906716 0.028951671 0.1096787 -0.087522864 0.1498081 0.05690971 0.120304786 0.09309235 -0.18653937 0.21146609 0.0029766425 0.10564803 0.018965106 -0.049713906 0.015869867 -0.018446174 0.008586479 0.043401416 -0.04521965 -0.21804489 0.2317762 0.2218556 0.09278156 0.08630885 0.17725186 0.015964935 -0.24458705 -0.10724951 0.0026788604 0.055885736 -0.1618083 -0.18450235 -0.18163583 0.060348004 -0.08708255 0.1691198 0.15238369 0.05222016 -0.06687736 0.062691316 0.0011159371 -0.002532325 0.17015533 0.040606722 0.14073756 0.13412829 -0.1302561 -0.10805095 0.14554705 -0.107671246 0.086099565 0.18979119 0.12565693 0.0005786357 -0.22051823 0.18848823 -0.006228872 0.19274157 -0.046060916; -0.14302185 -0.06753976 -0.21868765 0.23841524 -0.24711199 0.31777108 -0.08909157 -0.0068219732 0.019973751 0.092330284 -0.0646756 0.16363117 -0.12772657 0.061098367 0.15969206 -0.10832328 -0.18126737 0.22196107 -0.0037932154 -0.014549327 0.016545827 0.16874862 -0.29138815 0.01934863 -0.03207545 -0.1551385 0.1383852 0.061690237 -0.051269714 -0.05994271 0.119929895 0.20395733 0.044694245 0.08557042 0.07331924 0.22061065 0.0883542 -0.14507537 -0.08601842 0.06403338 0.033078115 0.12085115 0.02160294 -0.029369127 -0.029689735 -0.06410931 0.057692107 -0.08310663 0.1663899 -0.06117285 0.16867317 -0.056184657 -0.25553212 0.0028567528 0.07310959 0.034639318 0.072540015 0.113371745 -0.07605326 -0.25763386 -0.050300386 0.08708779 0.19140665 -0.05688555 0.11051283 0.050454684 0.03936391 -0.10017119 0.08679792 0.0003315112 -0.025721492 -0.07478665 0.054308612 0.006817638 -0.08355617 -0.0036854867 0.19161229 0.05239799 0.022047818 -0.17346041; -0.06771538 -0.17755637 -0.103925414 -0.056720745 0.056163944 -0.07054415 -0.05795985 0.16359599 -0.10343233 -0.14697184 -0.022671964 -0.02627044 -0.063734405 -0.05143363 0.052581374 -0.02485304 -0.13452229 0.028635763 -0.040308274 -0.02486256 0.094959356 0.11334666 0.15848583 0.16664565 0.1952299 0.104979165 -0.0863265 -0.013728166 -0.11473155 0.21084975 0.0063050324 -0.10651281 0.025632562 0.077830166 -0.072290465 -0.09307288 0.02303179 0.058482137 -0.104830034 -0.26206422 0.10483265 -0.2599546 -0.05273719 -0.20576519 -0.060242984 -0.019076128 -0.03150435 -0.047446318 -0.037574008 0.014079092 -0.14189804 -0.11203111 -0.060529534 0.044071745 0.10055392 -0.017295767 0.08538488 0.02349922 -0.1802579 -0.07271389 0.028788686 0.09849454 0.06049988 -0.117884845 -0.04374392 0.09774747 -0.12993674 0.08074915 0.11888645 0.16365682 0.24985488 0.11356512 -0.12629895 -0.0804028 0.08774324 0.090547 -0.25085562 -0.24170294 0.072086945 -0.0076911324; -0.046577215 0.13925922 -0.05271312 0.10096509 0.013376044 -0.090757266 0.08431972 0.18158954 -0.04874352 -0.16756144 -0.045086406 0.05859063 -0.18598394 -0.2105051 0.08878221 -0.09686513 -0.12871183 -0.24889769 0.034009323 -0.09421864 0.071937434 -0.23144104 0.20405559 -0.17481075 0.02805037 0.11851621 -0.0013486065 -0.15978697 -0.07326927 0.11212253 0.053413954 -0.1298228 0.045564834 0.18600318 -0.17056178 0.043303214 -0.11380958 0.014907284 0.12798 -0.041241284 -0.07034098 0.007354094 -0.06547655 0.052543756 -0.004078345 -0.025841348 0.14149313 0.25802547 0.049398944 -0.07002362 0.12399033 -0.10794862 0.27353707 0.24487454 -0.1002322 -0.11039451 0.15949088 -0.04339333 0.035154607 0.044410717 -0.022136137 0.007396847 -0.22222812 0.00584125 -0.2085627 -0.032227475 0.016848091 0.05957032 -0.024759052 0.058809977 0.3273832 0.0034396965 -0.107184365 -0.14536956 0.07556338 -0.08499151 -0.25337294 -0.12357376 -0.14009587 -0.15723376; 0.13613318 -0.12204992 -0.06010586 -0.0075754244 0.28299373 -0.20264013 -0.10528049 -0.07263315 0.10711759 0.20548308 0.028254174 0.014960473 -0.25225386 -0.07543444 -0.116573304 -0.14879222 0.16713102 -0.20540808 0.057655413 -0.06594809 -0.098733254 0.07013353 -0.004810581 -0.098165534 0.25191194 0.060665675 0.05865631 -0.053311408 0.09352024 -0.06147375 -0.20312335 0.014563808 -0.07863896 -0.13608542 0.07787182 -0.22557221 0.10502889 0.13379848 -0.0351439 -0.0076892753 0.09829162 0.118328795 -0.16626823 0.121362 0.18909806 -0.12637751 0.14572962 0.21054523 -0.28238785 -0.10848501 0.009901746 -0.11287173 -0.048246033 0.011477063 -0.0010192068 0.027134864 0.11566661 -0.20028432 -0.14854746 0.22517994 0.20192046 -0.16834776 0.11855004 -0.20738412 -0.19044386 -0.03927331 0.1152942 -0.12957954 -0.06638935 0.17594671 0.1019079 -0.06622892 -0.05100547 0.10215397 -0.13662453 0.23251785 -0.11422358 -0.08373112 0.09637962 -0.15891325; -0.12223044 -0.048585013 0.047552835 -0.17973438 0.25415748 -0.18218364 -0.14735688 -0.08648714 0.14464658 0.05260625 0.12271155 -0.13600852 -0.08266836 -0.12886447 -0.20539965 -0.022851337 0.18196964 -0.18548536 -0.12488699 -0.11316085 -0.07566325 0.018139118 0.14377624 0.1689833 0.14934985 -0.030039275 0.047533408 -0.09297242 0.11470674 0.01469665 -0.25646734 0.0569017 -0.11583334 0.07182687 -0.21278913 -0.005271916 0.06790418 0.0038656094 -0.035391323 -0.09644547 -0.019461546 -0.024965592 -0.1812756 0.09351354 0.1993894 -0.13431898 0.06360428 0.026801893 -0.15337653 -0.25702488 0.016818646 -0.04773814 -0.028659372 0.045132045 0.09588276 0.10555991 -0.18810835 -0.2381202 -0.08907219 -0.0579855 0.05850102 -0.08364687 -0.2024952 0.019844832 -0.11311052 -0.050382484 -0.21331896 0.06209527 -0.095585965 0.27183715 0.16991878 -0.15814815 0.13974473 0.042713962 0.11852071 0.063515 -0.10374256 0.07381698 -0.094170876 -0.12666787; -0.13784526 -0.16565625 0.1005308 -0.16061737 0.09541887 0.006249563 -0.04286804 -0.016780565 -0.22333491 0.20399573 0.12893376 -0.17291237 -0.16573046 0.08514455 -0.21705416 -0.121640496 0.048604436 -0.13257736 0.050013278 0.061250262 0.12222622 0.11721178 0.13951486 0.018138207 0.22191226 0.021834847 -0.16241282 0.20914908 -0.15733923 -0.031743165 -0.16339636 -0.22005428 -0.1002101 0.2535294 0.092293516 -0.06769878 0.11567281 0.015056102 0.047109544 0.06067031 0.103694856 -0.15434368 -0.1132761 -0.19189459 0.013765151 0.10083093 0.25562686 0.24108216 -0.14801869 -0.123086065 -0.10630604 0.22074524 -0.011759698 0.06826184 0.20463544 -0.016122805 -0.12858102 -0.22916229 -0.17390157 -0.0979306 -0.029191881 -0.17593352 -0.08019541 0.033626426 -0.19355983 -0.23430419 0.0645868 -0.0034644543 0.19998212 0.17537619 0.13509852 0.109035365 -0.059857138 0.058773387 -0.2302321 0.15465057 0.057496093 0.066587426 -0.16594523 -0.02101159; -0.2097711 0.08670294 0.17544678 0.00034532163 -0.14159977 0.12016975 0.24436383 -0.015057916 0.2397241 -0.07507804 0.14481714 -0.0081496425 -0.020018421 -0.043495722 -0.018452004 0.10192686 -0.11971293 -0.075641215 -0.0465512 0.1299768 -0.20690922 0.10700105 -0.20623605 0.102229185 -0.22187023 -0.07907294 -0.006085857 -0.19310917 0.057700187 0.084611885 0.043886185 0.24641977 0.06161834 -0.22612187 0.1526023 0.06737391 0.031679954 -0.050063193 -0.10848858 -0.082996644 0.037270214 0.17649323 0.17186214 0.13686864 -0.123998575 0.1722244 0.0019929816 -0.03851833 0.18134245 0.23263516 0.050053164 -0.012242648 -0.2559279 -0.15573747 0.13565168 0.071393415 -0.100996226 -0.105806224 0.016487101 -0.032944374 -0.20757665 0.19250454 -0.03523927 -0.020728173 0.1415164 -0.09583549 0.20659722 0.19047917 0.03800038 -0.28935167 -0.13745229 -0.0660592 0.21371704 0.021061437 -0.13699946 -0.22322063 0.099887416 -0.09508449 -0.016156992 0.079963244; 0.14199272 0.07288689 -0.05325178 -0.010467382 0.29374188 -0.088922344 -0.0030826447 0.00802354 -0.12960987 0.23175004 -0.06298782 -0.039242383 -0.066113845 -0.11821442 -0.26149222 0.10832317 0.052558597 -0.15980606 -0.08379164 -0.105544746 0.070479296 0.122046046 0.0017456475 -0.0032926165 0.05939922 0.08675813 -0.23676156 -0.13278309 -0.044457853 -0.12768371 -0.004878172 -0.14766672 0.23549613 -0.019848986 -0.22442892 -0.038857315 -0.24029794 -0.09832974 -0.058630377 0.05181035 0.17669429 -0.15497424 0.050523326 -0.13502648 0.15125073 -0.15197968 0.019224947 0.08707571 0.038854945 0.036770202 0.022461066 -0.11619261 -0.07936256 0.17366785 0.13725077 -0.13544898 0.01815785 -0.08298594 0.10747648 0.08461829 0.19826803 0.05518199 -0.24615987 -0.044884212 0.021231703 -0.006486928 0.11561007 -0.20710613 0.021289384 -0.0693226 0.3096455 -0.10115854 -0.07780238 0.22138907 -0.18030082 -0.035540916 -0.056606874 -0.20305867 0.05342792 0.025817446; 0.10670798 -0.049891293 0.011734647 0.06633927 0.046429846 -0.012588597 0.1597346 0.04248025 -0.1421354 0.13947855 -0.123617455 0.033051983 0.00022105192 -0.092685744 0.17783274 -0.04339852 -0.04737485 0.14906612 0.3207793 -0.058434006 -0.056801353 0.11942785 -0.04486917 -0.23499651 -0.3023495 -0.15860209 -0.0960024 -0.0664931 -0.070151545 -0.07080382 0.15529007 -0.059250046 0.057214182 0.0010607685 0.25818956 0.08399311 -0.028385842 -0.11532512 0.22791333 0.20955339 -0.22735487 -0.1937117 -0.097996555 -0.005339982 -0.051685743 0.28800547 -0.07457621 0.07810199 0.20147051 0.13093328 0.016685713 0.24645926 -0.050077815 -0.0806513 -0.073436394 0.017947337 -0.0596684 -0.048553016 0.12097549 0.050291885 -0.0753256 0.04233952 -0.111689225 -0.13659216 0.059014186 0.0057663578 -0.0068222913 0.27122006 -0.016531838 -0.066695616 -0.014445847 0.17180228 -0.22983065 -0.11669461 0.079075746 0.00025169944 0.10715054 -0.018261708 0.06438779 -0.057513822; 0.0564341 -0.08701156 -0.052685935 0.15351133 0.06498999 0.107490234 -0.07181164 -0.03094019 -0.09397395 0.100892514 -0.28895092 -0.095876046 0.0053496645 0.05808548 0.08361685 0.122628726 -0.15697017 0.11696271 0.1498944 -0.011896656 0.057848275 0.16614383 0.04458989 -0.21471614 0.11483731 -0.07719502 0.007260692 0.03560173 0.15386564 0.13403486 -0.043398064 -0.10171819 -0.26188374 -0.26234695 0.041208975 -0.0038248322 0.20240098 -0.09609746 -0.07486392 0.044670645 -0.018259926 0.0030453259 -0.0066098683 0.24226019 0.06085306 -0.119115576 -0.06170631 -0.15150529 0.08742015 -0.019310359 0.07386903 -0.0768976 0.23838863 -0.02143693 -0.18237634 0.11743278 0.028428402 -0.0302791 0.015897546 -0.24199845 -0.0048634824 0.0070725624 0.11319047 0.08088627 -0.021281099 -0.03159314 -0.006688173 -0.11890453 -0.17250453 0.0046470887 0.23256852 0.09014452 -0.17890616 0.032465674 0.21229222 -0.084490545 0.06857825 -0.23721772 0.08746956 -0.10908143; -0.007768099 0.053686474 0.017323617 -0.11691103 0.050803754 0.13449381 -0.06685364 -0.0061897654 -0.013802463 0.14459078 -0.19387077 0.14942044 0.12665091 -0.11382276 0.21982309 0.34809127 -0.14097963 0.19529505 0.0808469 0.25939637 -0.19923916 -0.06337676 -0.16151477 -0.2059488 -0.24302694 0.07244461 0.19563477 -0.112105645 0.12058514 -0.08080688 -0.012411196 0.21397081 0.012573025 0.10687579 -0.089832686 -0.08000413 0.114012025 -0.21058676 0.038100056 0.06857652 0.07744617 0.033840597 -0.013482108 -0.007893481 -0.012306742 0.24177127 0.038609106 -0.30345958 -0.106032655 0.07165917 0.021471536 -0.15628551 0.015029725 0.11531953 -0.08483977 0.14253268 0.013372383 -0.04439985 0.2030748 -0.20078446 0.12906887 0.25240964 0.19803813 0.066724844 0.078310914 0.09007106 -0.14417563 0.012924842 -0.09692473 -0.23912244 -0.26156753 -0.04387769 -0.043210126 -0.11799864 -0.10140798 -0.08832038 -0.012184679 -0.10016502 0.18850861 0.13525309; 0.0023346439 -0.053385757 0.14712502 0.0123757245 -0.04514219 -0.19697955 0.2453485 -0.1867518 -0.09059854 0.1305096 -0.07053338 0.09242047 -0.04943276 -0.05728432 0.047121495 0.10680017 -0.14722165 0.028673433 -0.09652937 -0.25494942 0.17650205 0.12361219 0.042077247 0.19114803 -0.04832563 0.17939088 0.16355635 -0.026099706 -0.15261412 0.0678195 0.15010433 -0.027129514 0.022006474 0.115778066 -0.05826006 0.0774296 0.10169496 0.024033317 -0.09834304 0.06642971 -0.05455841 -0.08970466 0.19881928 -0.08599492 0.105359286 -0.26555845 0.11096243 -0.03572571 0.23218478 0.15154782 0.13282141 -0.028787842 0.17495418 -0.07987529 0.1419164 0.14854619 0.1119821 -0.09780516 -0.12229153 0.19233674 0.045156427 0.119051576 0.041537587 0.16098674 0.044820692 -0.04047298 -0.15869586 -0.21977527 -0.18219952 0.2057356 0.23778737 0.052459937 -0.12822239 0.16436058 -0.12085754 0.019716043 0.19255234 0.06541967 -0.014435029 0.14866321; 0.20313403 -0.058679126 0.07588817 0.011497212 0.29457676 -0.05288228 -0.08953536 0.13148932 -0.19832508 0.11214286 -0.08093026 -0.039886612 -0.041867115 -0.13718607 -0.24198711 -0.14381482 0.028141128 0.04124868 -0.12331775 -0.09727521 -0.13056335 0.019368356 -0.18890062 -0.12087702 0.14771923 -0.2695315 0.1502042 -0.23832081 -0.06078487 0.10551152 -0.074062474 -0.18881868 -0.05408281 0.041650303 -0.08348912 -0.011126461 0.101066254 -0.016962044 -0.1975183 -0.17080972 -0.101414196 -0.15471622 -0.25097662 0.096132345 0.032089833 -0.12636608 0.043127257 0.06750364 -0.26668546 -0.08967206 0.026453555 -0.09487076 -0.053422425 0.20820966 -0.060446486 0.16630529 0.19567241 -0.16456793 -0.17452107 0.16319409 0.16007684 -0.04163503 0.035815943 -0.23911093 0.018050585 0.023308896 -0.13321277 0.067445934 0.06211444 -0.06625983 0.33528763 0.018938407 -0.11561883 -0.021828765 0.05916287 0.15467018 -0.21281162 0.052458826 -0.1436633 -0.07013189; 0.11631364 0.10256051 0.07931715 -0.15092462 -0.31465584 0.16903241 0.18572469 0.013376159 0.13721012 -0.1099552 -0.099381566 0.017175443 0.07404311 0.061766952 -0.04190902 -0.036080595 -0.04315166 0.2481024 0.19847414 -0.039853703 -0.08070957 0.12861061 -0.04466456 0.024610132 -0.011140289 -0.13864331 0.036478225 0.1216025 0.0037766008 -0.077640206 0.15537784 0.1988145 -0.0772649 -0.09355907 0.090443574 0.1284257 0.10618742 -0.17417447 0.22575833 -0.00085209624 -0.21319324 0.06836154 0.20883021 -0.14194901 0.09330655 0.13079762 -0.006228515 -0.06744411 0.008171593 0.10346339 0.136932 0.009064919 -0.20336945 -0.2113627 -0.10618396 0.11623679 0.15568961 -0.035290938 -0.025536295 0.11037984 -0.18603212 -0.082706094 -0.021756303 0.0073564355 0.21715239 -0.010433451 0.14117976 0.20649964 -0.018393107 -0.10478742 -0.10285328 -0.047203224 0.037007418 0.10758337 0.14713663 -0.03043826 0.0921785 0.13933682 -0.12692867 0.15988114; -0.04758399 -0.26487675 0.003146688 0.0033507948 0.18909265 -0.29449192 -0.072784916 0.0107812295 -0.047085322 0.0047323573 0.047584753 -0.18462363 0.08702351 -0.22733326 -0.021593504 0.13467428 -0.06912421 0.03622086 -0.26266408 -0.22992909 -0.03738026 -0.002130308 -0.064714044 0.031164607 0.22237477 0.15429792 0.05471374 0.19149148 0.031818017 0.052014634 0.020993838 -0.120307654 0.15585148 0.15191898 0.073165596 -0.13510622 0.08068731 0.12750064 -0.1633361 0.046208072 0.20404312 -0.13197011 -0.2800109 0.104108945 0.1845646 -0.18773703 0.035002127 0.28749087 -0.16528164 0.09488479 0.13905466 0.121615596 0.13012867 -0.12431608 0.04863833 -0.14060837 0.14504981 0.019280177 0.030831134 0.07725985 0.13246113 0.023806436 0.06823932 -0.25266713 0.00687918 -0.17870705 0.12286681 -0.15806136 -0.1486407 0.11936331 0.12907457 -0.062407956 -0.09362915 -0.07511632 0.07038175 0.18003692 0.021460086 0.064217806 -0.19814701 -0.11820084; -0.079161346 -0.09731358 -0.08126698 -0.08875471 -0.016207566 -0.24858096 -0.21934357 0.26995206 -0.16311298 0.14977606 0.12688905 -0.3043084 -0.11814004 -0.117368214 0.056340504 -0.039463058 0.035427522 -0.11946615 0.006658067 0.07756276 0.12144218 -0.17884581 0.09999879 0.05352078 0.21539262 -0.1129151 0.16567072 0.14408596 -0.024543473 0.10845017 -0.3126413 -0.13414676 -0.13126743 -0.16958454 0.023986112 -0.007857931 -0.18095861 -0.2097061 0.1606965 -0.18411534 0.13261163 0.08376792 -0.27113786 0.086510256 0.051186755 0.035822563 0.076529354 0.0381578 -0.2456882 0.1790726 0.05318453 0.13207127 -0.07022546 0.11808171 -0.17135723 -0.075479664 0.01257558 0.015298276 -0.12190158 0.121278174 0.20700595 0.066663474 -0.19717383 -0.23300226 -0.13501866 -0.085147195 -0.15955542 0.13353817 0.012202153 0.2076777 -0.02141391 0.011579545 -0.26462874 -0.12338289 -0.0066636503 -0.070806034 -0.13221115 0.10721272 0.1574381 -0.0022833876; -0.12557076 -0.15769072 0.09908004 -0.06122802 0.15480827 -0.26315197 0.0063454267 0.28870255 -0.22846125 0.1097138 -0.09578128 -0.12666328 -0.017925978 -0.086337805 0.0729335 -0.07227372 -0.12760866 -0.14762367 -0.11549848 -0.20638016 0.005006696 -0.07712633 0.047517687 -0.1887642 0.10756471 0.07765547 0.097783595 0.014831802 -0.025201716 -0.066845894 -0.24399857 0.08912073 0.06726843 -0.16865392 -0.116578236 -0.2614177 -0.034426853 0.13307606 -0.08041911 -0.17251709 -0.037883736 0.010384279 -0.2517327 0.08575491 -0.13431041 -0.0030345628 0.18567485 0.16209103 -0.037887804 0.020461246 -0.06453643 0.016483696 0.10598539 0.22149454 0.04066637 -0.008143943 0.15745065 -0.21636586 0.08085902 0.2059089 0.029601349 0.031459406 0.04351625 -0.25789076 0.11036399 0.10739228 -0.094435975 -0.10865245 0.057632472 0.079191245 0.19328469 -0.057770085 -0.079737306 -0.15200435 -0.028118785 0.13306807 -0.21727696 -0.18346608 -0.11683732 -0.08444739; 0.16552107 -0.09476596 0.054661755 0.19021662 -0.16024637 0.101993956 0.12247872 0.11012262 0.1752376 0.0065413537 0.013444083 0.1338317 0.20553905 0.026026748 -0.11804565 -0.18851446 -0.14773567 0.042613335 0.24630135 0.1373432 0.11603746 -0.06529903 -0.19533423 0.06866572 -0.051540013 0.10521854 -0.0034954667 -0.1376713 0.21818279 -0.024829349 -0.0091168545 0.15637459 -0.10748314 0.1389374 0.19779402 0.09174633 -0.098308064 -0.08077677 0.15255207 0.20449829 -0.21105261 -0.05952956 0.22163628 0.19139943 -0.15628685 0.07549287 0.13310722 -0.087525174 0.17685865 0.06930153 0.14543484 0.03781317 -0.036829025 0.11794956 -0.18204316 -0.103332825 -0.13306992 -0.12828381 0.23246585 0.13150851 -0.2329727 0.18237664 0.1447111 -0.07336028 0.10290351 0.06696815 -0.05779387 -0.053938862 0.11927655 -0.10236859 0.031031044 0.15680246 -0.20975533 0.15003781 0.14881341 0.21630366 0.024948793 0.0022524446 -0.106973514 -0.17543541; -0.062744915 -0.12968478 -0.08647865 0.1354862 0.09243548 0.19562754 0.16152473 -0.012864637 0.21177065 0.0791983 0.083786815 0.1790069 -0.046561103 0.067633286 0.19588907 0.12848927 -0.058763836 -0.08031151 0.2855232 -0.079299815 -0.09737923 0.018567054 0.047467057 -0.01783912 -0.23705913 -0.05087176 0.013111774 0.021562666 0.03727744 0.12926838 0.07580663 0.1544031 -0.06803979 -0.0061467793 -0.16344026 0.07313003 -0.0030587097 0.0022366317 -0.1582843 -0.17650203 0.10986815 0.03278842 0.1268441 -0.032291222 -0.030238796 0.21200855 0.0998881 -0.3293371 -0.034585055 -0.15146948 0.26084575 -0.09942163 -0.25381896 0.11282441 0.076450564 -0.14733158 0.010625925 -0.09873542 -0.03975435 -0.005454172 -0.067816295 -0.013576885 -0.06339628 0.14323984 0.012926783 0.10410003 -0.22578289 0.021964788 0.03934696 -0.12781167 -0.30343398 -0.082665466 -0.18321505 0.011804345 0.06491015 0.09074774 0.2439565 -0.038415805 0.14118564 -0.0829091; 0.067224376 -0.008701582 -0.042703014 -0.18006186 0.10468769 0.024368746 -0.07477282 -0.04641015 -0.027620174 -0.015220332 0.105928786 -0.12972733 0.035524283 -0.0058409567 -0.012741716 0.25295356 -0.061470427 0.006209749 -0.05028326 0.022915786 0.21118699 -0.13178268 0.047006004 -0.09917323 0.27291566 -0.13102838 0.010780057 0.07380391 -0.18042009 -0.022945445 -0.20030192 -0.18014173 -0.0527626 -0.059349336 -0.08401419 0.108862035 -0.026056474 -0.0125764 -0.15964447 -0.050984684 -0.11498065 -0.055343464 -0.1911427 0.0004628434 0.28846633 0.051467888 0.21971323 0.30400532 0.07724858 0.08822126 0.13058262 0.021924708 0.0037621192 -0.07415623 0.18875764 -0.019881777 -0.19175957 -0.006595541 0.05411376 0.1739146 0.0012604762 -0.016504781 -0.24715237 -0.08704986 -0.25152496 -0.17876518 -0.10762578 -0.118648306 -0.117553845 0.25457636 0.236214 -0.17456228 0.10988263 -0.019441623 0.023678433 0.08384387 0.053369574 -0.16221881 0.12368245 0.13753346; 0.12929842 -0.14609127 -0.002356047 -0.12661226 0.061856773 -0.25782973 -0.16051996 -0.08782405 -0.18342389 0.15540968 -0.051592004 -0.16328573 0.042492624 0.064949475 -0.032100126 -0.06864074 0.24752334 -0.14607929 -0.18922076 -0.24656774 0.033922356 0.010391826 0.29580086 -0.15246984 -0.061718028 0.225366 0.0041788546 0.20414956 -0.10174751 -0.01013997 0.12740228 0.115560375 -0.02372315 -0.01938582 0.08915045 -0.12670839 0.13662814 0.021848166 -0.16825385 -0.15110321 -0.009109232 -0.013308584 -0.11481032 -0.07044276 0.27713004 -0.18808831 0.029704778 0.015861912 -0.22406696 -0.19985045 0.21324079 0.21237738 0.15435976 -0.074694715 -0.079227254 -0.06214379 0.13193376 -0.032613676 0.16217433 0.09906522 0.14738424 -0.24674554 0.100076795 -0.22970624 -0.168828 0.12411098 -0.18216449 0.0038192545 0.07628579 0.13558751 0.03995595 0.07978882 -0.00059182476 -0.08564327 -0.14332537 -0.003928786 -0.1526872 0.18108246 -0.09061764 -0.10076639; 0.16574657 -0.08580196 0.09837073 -0.1574574 -0.0068539493 -0.27544808 -0.23755884 -0.078663945 -0.21896155 0.08756915 0.0009859584 -0.058980513 -0.17068656 0.1342559 -0.23780808 -0.06256853 0.17951798 0.05260963 0.05893787 -0.16009894 -0.07466975 -0.07452835 -0.07119526 0.15800986 0.1599503 0.069876134 -0.08003847 0.116282165 0.10275219 0.13340564 -0.054731697 -0.1235758 0.108955875 -0.112799026 0.054610755 -0.24171565 -0.15865578 0.04191382 -0.14131185 -0.11736925 0.064260885 -0.19703814 -0.060099017 -0.0386013 -0.15827213 -0.0759068 -0.009832507 0.0076246797 0.04997616 -0.14722303 0.005411027 0.1362689 -0.052914202 -0.13431577 -0.043611653 -0.09491994 -0.03227535 0.004510339 0.052221056 0.05706257 -0.06316427 -0.12465944 -0.17176656 0.055186547 -0.06615906 -0.045554582 -0.0730316 -0.045672152 0.10541614 0.007267799 0.21813864 0.0117697865 0.08736818 0.015409076 -0.172748 0.12311595 0.030082101 -0.09380853 -0.14918508 -0.01950247; -0.09314797 0.10112795 -0.2932505 -0.13106701 -0.18922721 -0.0021900279 -0.05062225 0.09005704 -0.006493547 0.1046483 -0.09888946 0.08550422 0.2620136 -0.12170586 -0.09944927 0.17640275 0.005634898 0.007977586 0.20178635 -0.019310014 -0.2727597 0.09170305 -0.21419334 0.061265588 -0.27918613 0.05843227 0.15464687 -0.16922772 -0.10362459 -0.07276908 -0.08772546 0.120809965 -0.23449256 -0.1779715 0.12232149 0.16937302 0.12763515 0.08162992 -0.09810703 0.024514373 -0.22956061 -0.11604442 0.11524619 0.042225968 -0.077960655 0.260311 0.091487214 -0.09613685 0.03818266 -0.09772506 -0.07577866 -0.022204943 -0.1684302 -0.14767227 0.09292275 0.22228536 -0.07417962 0.15450722 0.20999436 -0.03359949 -0.16487242 -0.026430674 0.25742504 -0.041269947 0.17001778 0.023015575 -0.07764471 -0.0039788997 -0.10107751 -0.14058816 -0.1252441 -0.017449241 0.08586889 0.1344581 0.18873692 -0.03766363 -0.1142034 -0.03619036 0.11903751 -0.048618548; 0.041082215 0.05969085 0.24799742 0.07086368 -0.0025578793 -0.10124286 -0.19113737 -0.03368374 -0.16970304 -0.03709064 0.09082379 -0.035672046 -0.15854283 -0.16426934 -0.16212687 0.146261 -0.057908837 -0.21386983 -0.14235245 0.006654499 0.053102445 -0.09951672 0.042447027 -0.049907252 0.17993629 0.010833129 0.116095476 0.20403463 -0.15277715 -0.17100334 -0.19942775 -0.17451161 -0.0040587503 -0.027009234 -0.16414565 -0.005269615 0.03682427 0.21956152 0.121858865 -0.095268406 -0.018527387 -0.021389617 -0.042211212 -0.050583158 -0.12972009 -0.05167724 0.10355671 -0.02930531 0.13680038 0.03602893 -0.056124873 -0.2100009 -0.01585369 -0.15291388 0.017329607 -0.10030759 -0.091279216 -0.1321013 -0.01836223 0.18422474 0.09461249 -0.20380956 -0.19166727 -0.16938043 -0.08907798 -0.034731653 -0.13286929 -0.020908639 0.13565154 0.039267607 0.31623968 -0.12789781 0.16096032 0.04505844 0.016693223 0.08597625 -0.131114 -0.12012336 -0.09276119 0.14871518; 0.12557712 -0.060361642 0.180561 0.02562159 0.00825578 0.058960102 -0.008701862 -0.068549834 -0.055567928 -0.07426009 0.20186284 0.06660334 -0.012544077 -0.03942605 0.07943937 -0.27065334 0.04223146 0.11094809 -0.033099055 -0.014555435 -0.12684502 -0.043061484 0.00090006 0.0677394 -0.02163241 -0.14689851 0.09909111 -0.14118825 0.024241434 0.10092528 -0.17431012 0.016652413 0.052355975 -0.05813284 0.09230056 -0.14872429 -0.16705596 0.05638496 -0.18252538 -0.14546858 -0.120849796 0.06255764 -0.12357442 -0.12520881 0.05561918 -0.1579353 -0.12238465 0.103093095 -0.014496267 0.088231325 -0.014173388 -0.112352036 0.0047170427 -0.034940217 -0.0923832 -0.18728726 -0.16661738 -0.13517639 0.045463353 0.050538998 0.068340234 0.13058487 -0.16649388 -0.015490757 -0.054295152 -0.12551491 -0.19605112 -0.10703223 0.18075468 0.004106984 0.013937164 -0.012497515 -0.13584241 0.08710534 0.004706675 0.15494037 -0.012567886 0.044141665 0.15571336 -0.09697264; -0.12776536 -0.20029068 0.21327393 0.06376555 0.23755069 -0.031949583 0.052655283 -0.024877941 -0.20652904 0.12553021 -0.026810754 0.006120272 0.08650197 -0.048709724 0.01704902 -0.19574931 0.14662135 -0.24158417 -0.109790355 -0.0031595847 0.18325719 0.031583738 0.20970403 0.1643626 0.012533299 0.108952135 -0.03452386 -0.015407196 -0.10252821 -0.15403724 -0.124741666 0.016420327 0.13358584 -0.040674638 0.07237926 -0.1808532 0.0942087 0.11791116 0.034396503 0.044833537 0.05127427 -0.08317164 0.12922138 -0.043365918 0.18727554 -0.30873695 0.07251831 0.00056254095 0.018536832 0.096660204 0.014157179 -0.11990229 0.008973833 -0.097321115 0.08333846 0.05437721 -0.03448062 0.08233136 -0.2304319 -0.028132165 0.19596678 -0.18392012 -0.045088038 0.06440274 -0.14314973 -0.04324102 -0.0750784 0.026796458 -0.16078204 -0.055463955 0.16868986 -0.0770673 -0.07362773 0.1421895 -0.025893444 -0.04149386 0.08725252 -0.120742045 0.07505396 -0.015776388; 0.15748507 -0.018284546 -0.031813677 -0.12224941 0.051396146 -0.0019799953 0.023857675 0.2026512 0.050961405 -0.073006354 0.03975712 0.011446472 0.120221116 -0.1351834 0.027356533 0.12358769 0.13735856 0.089695305 0.069037296 -0.008722742 0.0029932687 -0.03334107 -0.06160879 0.21288699 0.21972416 -0.056036185 0.056451764 0.118258685 -0.059117712 -0.029576998 -0.0727649 0.08305257 0.15078923 -0.026315186 -0.22669144 0.09929613 0.14040166 0.1963337 -0.031608272 -0.15574928 0.19044961 0.103993125 0.046612937 -0.23392284 -0.016700068 -0.12958457 0.055677798 -0.04876338 -0.008710839 0.11119035 -0.016241264 0.012371825 0.25476658 0.12461958 0.2205524 0.035329673 0.09583297 -0.22087061 0.09244424 0.094693966 -0.009988597 0.08243814 -0.06616358 -0.08794922 -0.18770744 0.008091698 0.118838154 -0.1081824 0.083746776 -0.018752104 0.10817853 -0.08055406 -0.18410967 -0.14953583 -0.009603271 0.040260125 0.057941895 -0.1111946 0.11685908 -0.051250655; -0.021527173 0.1295114 0.01879305 -0.21283455 0.296088 -0.17524609 -0.111203276 -0.10143335 0.11051324 0.08177656 0.24056125 -0.0034914257 -0.11624721 -0.14737032 -0.15087293 0.025285285 0.11550932 0.04361111 -0.30661723 0.060542367 -0.06848267 0.024141943 0.17736714 0.057792142 0.075040564 -0.030416282 0.07945793 0.036576837 0.13796976 -0.165064 0.03164198 -0.13980362 -0.008059185 0.16954039 0.062997274 -0.20946506 -0.019617632 -0.05396796 -0.22897536 -0.120929755 0.1255336 -0.14627537 -0.045199614 0.1299738 0.19577433 0.05314339 0.23440602 0.06849619 -0.11556748 0.029974122 -0.018385984 -0.12457662 0.029715126 0.18759179 -0.061727673 -0.03200708 -0.0066387076 -0.023664538 -0.13237849 0.13796379 0.05434987 0.12638836 -0.2225158 0.036513668 0.09637418 -0.08892481 0.11930009 0.049870387 0.124240704 0.20055166 0.2357618 0.12011119 -0.17386445 -0.1471357 -0.24796171 0.21647547 -0.006246145 0.03245089 -0.1208093 0.10576209; 0.14572236 0.0014308275 -0.13285829 0.08373577 0.088391155 -0.08570984 -0.1782396 -0.037191927 -0.30956027 0.066638164 0.093947865 -0.26242554 -0.16882567 0.034721978 -0.25595757 0.1314161 -0.00792669 -0.17950566 -0.0841747 0.06007427 0.19864094 -0.13782987 -0.027106766 -0.04545227 0.2053799 -0.035161655 0.07428159 -0.061139677 -0.14744125 0.018498817 -0.104872555 -0.30750674 0.13240132 0.08509206 0.040772956 -0.17705373 0.02617985 0.17586583 0.06399527 -0.071424045 -0.07758473 -0.24348043 -0.30978835 -0.06909275 0.034418378 -0.26911327 -0.018706579 0.2536843 -0.065918036 0.01855751 -0.21609978 0.13897598 0.26554033 0.2670992 -0.14031592 -0.083309025 -0.19583015 -0.1600018 -0.2719461 0.2063406 0.00928445 -0.01238011 -0.17712264 -0.117432825 -0.07268215 0.026908454 0.043695863 -0.0065204385 0.1288659 0.26205647 0.025451435 0.025024824 -0.087914914 -0.20662305 0.0047742645 -0.016527934 -0.10098971 -0.19237338 -0.09915211 0.1189634; -0.02719145 0.13683486 -0.10723784 0.113886364 -0.23939517 0.16146305 0.20397675 0.03747266 0.30803597 -0.05582853 -0.036804352 0.0061478037 -0.07571354 -0.09086435 0.17770547 0.21356353 0.21260127 0.029988676 -0.023872234 -0.06808339 -0.010005017 0.09760666 0.0064970255 -0.11547559 -0.20795734 0.3031601 0.0914499 -0.09853508 -0.06848477 -0.29190075 0.09893113 0.031160016 -0.030762594 0.16465147 0.17126442 -0.0022072997 -0.11179812 -0.10140382 -0.12864782 0.21292935 0.114648744 -0.017220808 0.041568596 0.17945516 0.01891898 -0.0043790033 -0.029556882 -0.05845 0.18330653 -0.12526251 0.26570717 -0.0010200741 -0.08247902 -0.2514482 -0.12947255 0.0076291137 0.090532504 0.19957083 0.249325 0.035991296 -0.18436489 -0.16245787 0.026911646 0.18738274 -0.04787017 0.027695438 -0.18402882 -0.126665 -0.13546468 0.00313891 -0.34796646 -0.036863003 -0.048079416 0.073882625 0.030688299 -0.2265331 -0.072205454 0.28987503 0.13167976 0.07445096; 0.07890884 0.16371296 -0.18220198 0.18535085 -0.21848065 0.03933403 0.009604313 -0.28649208 0.14506438 -0.12353952 -0.26215807 0.17928395 -0.09258409 0.14042859 -0.09911763 0.02747302 0.12954392 0.09745623 0.16786173 0.21187335 -0.16873509 0.24053575 0.09084904 0.108250074 -0.0055462173 0.008980443 -0.14248963 -0.2300886 0.2247056 0.01027172 0.04736835 -0.03873493 -0.12352322 -0.04670628 0.027724696 -0.022901826 -0.060098767 0.1356499 0.26335996 0.13994214 0.118006155 0.09522675 0.022802113 0.15549432 0.048162837 -0.028634936 -0.2663284 -0.11956698 0.058182303 0.045638993 -0.18305469 -0.13449104 0.00044347864 -0.14503908 -0.059349626 0.24318442 -0.14293656 -0.13853075 0.06634046 -0.18458857 0.09836394 -0.11980819 -0.0786809 0.120048404 0.17388736 -0.10638862 -0.09220258 0.049857467 0.035926033 -0.0614848 -0.25314957 -0.008128637 0.11749633 0.07075474 0.099539265 -0.14347823 0.14977668 -0.025338992 -0.025728859 -0.06646751; 0.12973498 -0.04631208 0.22878928 -0.21597432 0.07776957 -0.1961538 -0.040725112 0.042959973 0.16384761 -0.13294266 -0.09337783 0.12852934 0.024903964 -0.12243277 0.03956708 0.12078238 0.09042789 -0.008677798 -0.091141276 -0.124555275 0.1428869 -0.20812276 0.23880973 -0.06866711 0.13128734 -0.06962686 0.0035863188 0.19278474 -0.08944487 0.023539204 -0.07648439 -0.14203201 0.038166057 0.17598964 -0.1508569 -0.055310447 0.12239177 0.18738802 0.067550525 0.03949667 -0.00885071 -0.01686608 0.039906017 0.06569738 -0.11883865 -0.18465275 0.1502178 0.07771788 0.042401616 0.03546459 -0.06435684 -0.22118196 0.09200718 -0.018241778 0.011132167 -0.055173244 0.0989728 -0.11022917 -0.093898185 0.009674733 -0.040451504 0.041171554 0.02003916 -0.08087471 0.060020145 -0.15286331 -0.095003925 -0.039792832 0.15581687 0.19388582 0.25140223 0.16206655 0.055157226 -0.041814853 -0.03506186 0.037887547 0.028589878 0.036910336 0.08270662 -0.13723062; -0.14478883 -0.10572055 0.035241045 -0.031660378 0.12062923 -0.026577478 -0.1424766 0.2003315 -0.11295091 0.05489649 0.01922874 -0.120382346 -0.036260597 -0.1146355 0.015203158 -0.15181805 0.06298858 -0.064438604 0.11990799 -0.058017116 0.102766685 0.08279219 0.05603698 -0.19840649 0.017811265 -0.17670935 -0.10637478 -0.026886083 -0.05578663 0.05660584 -0.03282094 -0.06805082 0.11957016 -0.109657206 -0.12579374 -0.22880106 0.15890314 -0.09921371 -0.052363288 -0.22532742 0.057848874 -0.25392735 -0.24401161 0.056739572 -0.041586976 0.018382825 -0.1326817 0.01185694 0.033190437 -0.07764885 0.0689883 0.33094302 0.025339192 0.3490768 -0.1434708 -0.050644502 0.12204181 0.034047615 -0.0026367558 0.15319431 0.10802097 0.043256514 0.046999186 -0.20898163 -0.0074711246 -0.16631152 0.16801357 0.050639093 0.060762644 -0.07083041 -0.0046533654 -0.15907443 -0.1342237 0.11213806 0.038019374 0.025913192 -0.29743356 -0.10005192 -0.28177175 0.017128501; 0.06789223 0.039647702 -0.142201 0.058842324 0.08217332 0.06016086 -0.05393274 -0.28421146 -0.0772869 0.022072405 0.094171494 -0.017314317 -0.06630881 0.27761328 -0.00788815 0.12734139 -0.18218026 -0.019138725 0.21678466 0.20017922 0.07236829 0.07449468 0.05293892 -0.15569563 -0.12781118 -0.089750946 -0.028796712 -0.24495633 -0.014379114 -0.09884223 0.24957345 0.12455522 0.011234257 -0.10817664 0.08393338 -0.0680546 0.14331068 -0.031779993 0.23977923 -0.02456437 0.0011405926 0.05731412 -0.038354345 0.08987405 -0.1408896 0.08125935 0.03778781 -0.23421448 -0.16681524 0.08677225 -0.20487055 0.118228346 -0.061874274 -0.0069504743 -0.13893881 0.0016544198 0.052171502 0.2880282 -0.02980468 0.13095945 -0.21732691 0.20632814 0.12615523 0.065050185 -0.05566267 0.008431578 0.25952598 0.2542847 -0.08144728 -0.12303788 -0.14266008 -0.037122793 -0.0640236 -0.0011880003 0.19769078 0.059742782 -0.011620907 -0.018218352 0.04017766 -0.034321856; 0.08913447 -0.025292452 0.19596985 0.030727535 -0.022674331 -0.24905752 0.07120105 0.17781185 -0.20861152 0.19099106 0.0046498617 -0.21107623 0.10937643 -0.12833348 0.017557207 -0.04728122 -0.032704633 0.016355122 0.0055935527 -0.21275479 -0.09157374 -0.10209652 -0.12096542 -0.124322385 0.049981833 0.13857205 -0.23329702 -0.022996252 0.051170748 0.22416 -0.23249719 -0.18013181 0.033302158 -0.092105605 -0.13497888 -0.13655247 0.123604245 -0.09101662 0.07661921 -0.020188512 0.10347943 0.06446624 -0.2916725 0.077543646 -0.044228338 -0.27006254 -0.12483798 0.16091514 -0.1569754 -0.20915002 -0.14768186 0.016112799 -0.058765493 0.071726665 -0.013233667 -0.15019862 -0.09493948 -0.12729299 -0.27827632 -0.12163986 0.20402083 -0.20423482 -0.057315156 -0.10209966 0.044513997 -0.18221572 -0.22093923 0.15204066 -0.10743542 -0.02062402 0.19193846 -0.12813722 -0.041897718 0.08126892 0.12651826 -0.06406984 -0.10506455 -0.025818232 -0.059312098 0.07438717; -0.030540701 -0.08377016 -0.19084853 -0.12166539 -0.06575561 0.12947918 0.019200156 0.015824176 0.026638294 -0.0599098 0.033965006 -0.23223065 0.06231442 0.054789264 -0.112302355 0.028768152 0.002134349 0.051026277 0.15614997 0.13204655 -0.15579396 0.03563467 0.10768146 0.052836303 -0.1884019 -0.21725604 0.16319785 0.05114897 0.08173964 -0.15198262 -0.051516905 -0.2111124 -0.11441681 -0.12007693 -0.15695296 -0.22440843 -0.0968578 -0.14644265 0.051198475 0.014319515 0.01739241 -0.2064268 -0.015508915 0.1167798 0.08859649 0.026168745 -0.029880468 -0.18470544 -0.14588425 0.079155125 0.022630185 0.12354075 0.14972956 0.20758395 -0.20480989 0.010396521 -0.10415952 -0.19417728 -0.17400149 0.13896194 -0.18090115 -0.014440831 -0.0059074615 -0.18291475 0.09260836 -0.07610128 0.18783468 -0.005561485 0.12496898 0.13568503 0.027194776 -0.09869461 0.05957037 -0.16090167 0.107843235 -0.029239349 0.10687866 -0.033449773 0.018930707 0.17864232; 0.17525543 -0.08356521 0.08690333 0.08925529 0.046747606 -0.004685729 -0.04728551 0.16640323 -0.13150841 0.025675738 0.111071534 -0.13296732 -0.114555635 -0.102445334 0.15194869 -0.16366102 -0.07035962 -0.06342079 0.13830157 0.28137726 0.06400424 -0.13907091 0.014770022 0.09726177 -0.1539261 0.09756955 0.02056738 0.11264725 0.14751044 0.080777064 -0.13099606 -0.14691477 -0.16253687 0.14380117 -0.23119332 -0.08725008 -0.1822444 0.11286319 0.009974016 -0.268861 -0.1579968 -0.2710459 -0.105695605 -0.26350468 -0.13346706 0.13272381 -0.033928007 -0.32981226 -0.07743433 -0.059264407 0.048427626 0.08129284 -0.14171217 0.09817115 0.062210552 0.00499968 -0.032786656 -0.05100698 -0.14504646 -0.015870247 -0.01873427 0.13210993 0.051547915 -0.1096956 -0.015515998 -0.11389043 -0.04128127 0.028670043 0.19677107 -0.12727168 -0.22015122 -0.16372275 0.05898739 -0.10414109 0.11649231 0.35608342 -0.19825312 0.083396874 -0.25396022 0.011668433; 0.12285069 0.003581291 0.10203174 -0.11840528 -0.19979465 0.05837932 0.0051838383 0.045590736 -0.05499035 0.12592013 -0.20782849 -0.018865982 -0.0909675 0.09192639 -0.07573871 0.04605092 0.1306631 0.14784326 0.048911154 0.0025235228 -0.093078695 0.039130222 0.10722912 0.13957992 -0.06505894 0.12843575 0.15801159 0.14900659 0.22734974 -0.11288784 0.31741232 0.26328352 0.120016575 -0.068488844 0.02734834 0.21641526 0.0002464943 0.14753976 0.13767439 0.16458401 -0.031251825 0.20652904 -0.043588612 0.17740957 -0.10937987 0.2247077 -0.17942859 0.023363564 0.28615746 0.007131748 0.11922989 0.07471423 0.016746469 -0.26117343 -0.115945116 0.023615478 0.11851114 0.22698861 0.16054782 -0.13676958 -0.021035383 -0.14231913 0.061285403 0.013253631 0.020092191 0.010806124 0.24062128 -0.090169296 0.06685484 -0.26734164 0.004916974 0.06639302 -0.057855703 0.18753423 0.15945803 -0.27053854 0.17048691 0.02835182 0.19230567 -0.15529402; 0.053674463 0.050102625 -0.11909946 -0.101360336 0.044287536 -0.04347301 -0.09056675 0.23315841 0.011800599 -0.16858311 -0.103507936 -0.21549614 -0.12502618 -0.16840933 -0.0783485 -0.16722754 0.13435847 -0.008268298 -0.13082291 0.06703427 0.2196396 0.1003711 0.13350774 0.07222796 0.250129 -0.022222167 0.10669783 -0.17401347 0.06421943 -0.04649833 -0.12344639 -0.20281766 0.0945291 0.052744843 -0.04772741 -0.026145346 -0.12226448 0.060877983 -0.115398 0.014231424 0.17616007 -0.10873944 0.028450463 0.11871541 0.09943684 -0.27822027 0.20855345 0.12369446 -0.022985455 -0.038919963 -0.101323195 0.08095832 0.030848922 0.17489812 0.01963547 -0.061756704 0.059138186 -0.1598854 -0.213034 0.22832875 0.1579863 -0.012345616 0.103534035 -0.08701686 0.020488502 -0.14468195 -0.009436693 0.13480954 -0.016704725 -0.06805988 0.19956659 -0.15648434 -0.067243904 -0.1970262 0.14225554 0.058410272 -0.18047935 -0.07165186 -0.056948073 -0.02109795; -0.024147708 0.20601586 0.092972435 0.07304629 -0.19236894 0.10973424 0.10874942 -0.20332427 -0.053310994 -0.06479062 -0.09751085 0.24272665 -0.033328522 -0.09714172 0.049516615 -0.06365695 -0.19007906 0.12010591 0.23671997 0.07670367 -0.21489036 0.22070058 -0.08190387 -0.06029409 -0.0687569 0.1771156 0.133565 0.06866008 -0.019951172 -0.16778214 -0.040805843 -0.01213403 -0.15448624 0.08436916 0.16968903 0.21854272 0.13345273 -0.09439057 -0.03202508 0.2345697 0.010586699 0.00018652581 0.050546948 0.10261262 0.096552946 0.23224749 0.010602863 -0.28730598 0.19918787 -0.0151618365 -0.014403358 -0.04328183 -0.07567276 0.1241141 0.08329602 0.034152288 0.093764186 0.09104137 0.2004544 -0.14466417 -0.12848371 0.20087482 0.10778143 -0.09246685 0.046462025 -0.11877259 0.11382485 -0.06583914 -0.2106867 -0.22550327 -0.0041077016 0.21718517 0.10439369 -0.16238594 0.23089021 -0.022862274 -0.01567011 0.10767576 0.015605695 0.113567695; 0.024249027 0.058917813 0.0807912 0.06478804 -0.15369733 0.05857296 -0.00067124865 -0.2547886 0.19481345 0.09513587 0.1661725 0.2279142 0.029242683 0.04792744 0.27754945 0.14908727 0.07603054 -0.04561002 0.31684124 0.03955171 -0.1467175 0.08739234 0.1626725 -0.16292156 -0.15347032 0.15120687 0.059429664 0.018694222 0.060254242 -0.118326426 0.20525476 0.038250655 -0.09275753 -0.20990953 0.08292184 0.00805774 0.0013481722 0.14830875 -0.048649713 0.27249473 0.055712994 0.24426977 0.29674932 0.07255944 -0.08231371 0.0897491 0.11495125 -0.25636426 0.39112705 -0.11068802 0.2613685 0.02251979 -0.012134914 -0.27217662 0.046277836 0.105226934 -0.07113302 0.19690157 0.27619863 -0.12905385 -0.23781107 0.0022753126 0.124338284 0.12842685 0.23098113 -0.12630792 -0.09936903 -0.14842296 -0.0038390574 -0.28174752 -0.017874295 0.039745484 -0.11437704 0.22726671 0.09495526 -0.06405131 0.18620285 0.20627788 -0.04900855 -0.15990086; -0.073434845 0.07800039 0.15796374 0.112879455 -0.09249391 -0.27176738 -0.014087636 0.18001473 -0.051840264 0.047610186 0.077564545 0.04791548 -0.075184114 -0.02945018 -0.12520248 -0.0660297 0.061548878 -0.1739697 0.041611057 0.037953652 0.05578953 -0.03915429 -0.1020397 -0.067685716 -0.024185717 -0.13562371 0.05660035 -0.03770522 0.019718356 -0.1980614 0.14081803 0.06244636 0.21791004 0.17447455 0.042281285 0.1465784 -0.18509032 0.15998378 0.0071067866 -0.10427254 -0.15478353 -0.012479615 -0.00066476956 0.038249683 0.17261444 -0.046291042 0.14256273 0.22705002 0.08239272 0.05765495 -0.1132656 0.047175024 -0.089125305 -0.08475922 -0.010054356 -0.033008613 -0.14669375 -0.0836492 -0.031173427 0.11723115 -0.08587234 -0.21690257 -0.13865553 0.008436393 -0.1930118 -0.051253792 0.059124663 0.07895565 -0.23132937 0.17429814 0.087234065 -0.1383582 0.032384653 0.05458259 0.12531929 -0.17700954 0.046151664 -0.1486087 -0.08051816 0.11311953; -0.109006435 0.022188725 0.22226056 0.11436624 -0.22696015 0.0032068344 0.32435215 -0.26791808 0.24778993 -0.15502681 -0.15681982 0.006212574 -0.1052618 0.111441895 0.02723662 0.004397399 0.172489 0.1036123 0.2108393 0.21956363 0.049647562 0.15162875 0.0462103 -0.14465953 -0.24309556 0.04842668 0.15473104 -0.14108472 0.065701835 0.007684885 0.24869315 0.045944314 -0.15870571 0.07141091 0.16214778 -0.025034407 0.18578385 0.08432269 -0.15099506 0.15818122 -0.23207417 0.057556614 -0.03486293 0.16557927 -0.1833903 0.2672128 0.02830575 -0.29750887 0.17777264 0.19616981 -0.03949323 -0.057820793 0.07701829 0.073771365 -0.14338881 -0.06354873 -0.04024058 -0.13058591 -0.018265497 -0.14717695 0.09616782 -0.17961569 0.0066872938 -0.043402385 0.05587356 -0.08910961 0.030067489 0.0026162623 0.08238964 -0.2964009 0.04231786 -0.0036737449 0.016671654 0.17671089 0.063178025 0.1284716 -0.08352642 -0.08213699 -0.02930663 -0.19499189; 0.19279489 -0.07432128 0.1431514 -0.07734161 -0.060711574 0.13703498 0.07415183 -0.011033041 -0.11146633 -0.05954904 -0.11570371 -0.08980216 0.23614927 -0.0384551 0.008328174 -0.15505646 -0.11556985 -0.029168468 0.2932907 -0.061894298 0.09516535 -0.14709838 -0.014949657 -0.1476463 0.04321575 0.03483265 0.13762209 -0.060990784 0.19177447 -0.07350807 0.13398328 -0.17997417 0.08289089 -0.08590997 0.107421026 0.037523154 -0.113478914 -0.09092592 0.08465926 0.00021468871 -0.044695128 0.002404927 -0.17391716 -0.09976257 -0.19923934 0.24876891 -0.06276607 0.012293976 0.03267332 0.074235104 0.18034264 0.2586478 -0.1449751 -0.061314147 -0.09412257 -0.13775802 0.17173924 0.08770295 0.02530437 -0.22326696 -0.010244038 0.028148018 0.09506033 -0.14688586 -0.06881789 0.09876902 0.17543621 0.1035278 0.07415127 -0.2117383 -0.20309575 0.04872904 -0.1932462 -0.10015924 0.090026595 0.16007398 -0.07649932 0.06579023 -0.21478765 -0.07135011; 0.13263014 -0.018888636 0.2040288 -0.030072728 0.17027152 -0.18175481 -0.12630299 0.0020618404 0.17554568 -0.035277262 -0.14204904 0.23269074 -0.08343998 0.023171334 -0.06540844 -0.014635869 -0.1429144 0.115699925 -0.09736106 -0.24482138 -0.028459767 -0.14245005 0.08299799 0.2063882 0.036710978 -0.19129957 -0.06365936 0.15600532 -0.0017879654 -0.046217944 0.021900231 -0.18608615 -0.03885673 -0.020776058 0.09878696 0.12258923 0.0729166 0.020148976 -0.08031108 -0.026587509 0.09998596 0.14716886 0.09687351 0.06363552 -0.08002152 -0.020720951 0.016484935 -0.071218565 -0.021323282 0.114866875 0.033982184 -0.16995415 0.12021081 0.05022631 0.20943387 -0.10018021 -0.047650438 0.070239775 0.053613964 0.13688937 -0.016696246 0.035890307 -0.203871 0.13770328 0.06249241 0.02319892 -0.0010039171 0.09138943 -0.036654327 -0.02820447 0.3124495 -0.15165788 0.054975063 0.2334083 -0.17322883 0.029163348 -0.13197029 -0.15408291 0.030093465 0.100203365; -0.15279083 0.18305759 0.0763125 0.029945789 -0.0095924325 -0.1721498 0.102570154 -0.061301745 -0.23627475 0.07264467 -0.089622244 -0.0358014 -0.011343069 -0.0044092922 0.09524502 -0.09428242 0.1841749 0.15806928 0.012371099 -0.107560955 0.14062038 0.0038081717 0.08043516 -0.16073465 0.14462347 0.10572061 -0.03271007 0.044449087 0.08583975 -0.013799271 -0.19586475 0.053894874 0.23276667 0.099985674 0.09234891 0.015861737 -0.20252466 0.019361017 0.10193317 0.049720045 -0.07824923 -0.14242323 0.009298777 0.027146267 0.021411285 -0.23673609 0.07290003 0.08669078 -0.21611477 -0.024396181 -0.0799195 -0.24786682 0.054218125 -0.11724123 0.112827845 -0.071504496 -0.016033709 -0.20469919 -0.10315576 0.21273701 -0.080684125 0.071860306 -0.17314735 -0.15991972 -0.060250375 0.14176244 -0.08014909 -0.0411548 -0.01272044 0.1354935 -0.01502718 0.14873953 0.169288 0.032577362 -0.15804075 0.16490318 -0.016906397 0.007474955 0.21064343 -0.026768584; 0.10653043 0.044840354 0.11028572 -0.0431945 -0.047267105 0.21957193 0.24687146 -0.23112126 0.1119787 0.037548706 -0.053116035 0.2689171 0.12629583 -0.15313216 0.17714441 -0.11514154 -0.102730386 -0.15835553 -0.1197547 -0.05534513 -0.018083043 -0.1121743 0.11403357 0.17990555 -0.11838849 0.21973754 0.013261548 -0.036701508 -0.14543326 -0.013036133 -0.0772842 0.1724912 -0.010998786 0.13831623 0.09094605 -0.0225839 -0.16107388 0.19713604 -0.09156009 -0.1303322 0.18506591 0.14057262 -0.08312971 0.060839806 0.21095376 0.13676605 0.064739324 0.05931514 -0.070147224 0.100197 0.08353161 0.18928662 0.10197773 -0.13936952 -0.08502414 0.0737536 0.08833391 -0.06307118 -0.031090504 0.025555758 0.20832987 -0.10297556 0.124368414 0.27602074 0.05537754 -0.037231945 -0.20887274 -0.20832579 -0.089114845 -0.07890242 -0.15295446 0.020723341 0.0028488988 0.14694388 -0.03856497 0.07509369 0.042754747 0.116981275 -0.004776482 -0.11431776; -0.1720114 0.32430983 -0.0016350686 -0.19599319 -0.12255578 0.0722786 0.18560162 0.08094876 0.18284467 -0.05472727 0.13771917 0.008162013 -0.26937073 -0.13156183 0.046363495 0.013958537 0.15338247 0.0025045183 -0.30145082 -0.045974214 -0.050629802 -0.16986018 -0.09522099 -0.1087278 0.07243057 0.24626671 -0.032703605 -0.022885164 0.06887012 0.00069573073 0.0004863409 -0.18088344 0.1720165 -0.04801389 -0.008934388 -0.06663295 -0.20860003 0.03880628 -0.077705055 -0.16463354 0.1906735 -0.02297843 0.055379838 -0.102200195 -0.055066768 0.0115549965 0.18041207 0.17603339 -0.10908106 -0.29956916 0.18759131 -0.17835663 -0.021351978 -0.08007736 0.16718292 -0.1870456 -0.06296815 0.05183805 -0.15948194 0.14846376 0.03125876 -0.14484726 -0.2131389 -0.038711727 0.069162525 -0.042974196 -0.028494705 -0.04225797 0.1671808 0.27157602 0.20752633 0.06616443 0.02253775 0.17750064 -0.20706154 -0.09278117 0.078084916 0.17943814 0.09768702 0.10536451; 0.07123331 -0.14781708 -0.17403325 0.12622936 0.21019794 -0.09245419 0.024846101 0.13512588 -0.17365062 -0.111201465 0.13524175 0.03807099 0.044709712 0.11971012 0.015588204 -0.025389424 -0.0215852 0.001127525 -0.024458542 -0.007869456 0.16977163 0.120620504 -0.18396497 -0.15714554 -0.11378669 0.0057591978 0.106289186 -0.11190984 -0.071003176 0.019595366 -0.011710636 -0.06597662 0.08290966 -0.0403429 -0.09315243 -0.14937402 0.08341126 0.088505894 0.14274864 -0.016869795 -0.13115795 0.083239615 -0.019936586 -0.061916504 -0.18062495 0.10340973 -0.16725604 0.09669503 0.13128754 0.13456418 -0.080849834 -0.016760385 -0.18088683 -0.034637425 -0.15694204 -0.122079216 -0.15447019 -0.069578506 0.100188725 0.14887634 -0.14129338 -0.040327188 -0.16376716 -0.17699367 -0.022500325 -0.10888127 0.048174422 0.10663596 0.14409642 -0.033909768 -0.11058534 -0.06308105 0.104387805 -0.1468128 0.05888238 0.0022306903 0.09835159 0.14625898 0.10061624 0.111169465; 0.17014395 -0.19196162 0.011666538 -0.073619984 0.17775875 -0.08066547 -0.2073138 0.0030564575 -0.06151923 0.11176921 0.061633013 0.008340117 -0.044889245 -0.090997465 -0.16345924 0.018462667 -0.1102056 -0.09368034 -0.20045456 0.05051007 0.14466652 0.13508382 -0.062711015 0.14872423 0.0998011 -0.19537458 -0.16420545 0.15371461 -0.13992247 0.027545083 -0.009496581 -0.29141766 -0.13325281 -0.044530045 -0.062556826 -0.24276838 0.10001883 0.032994654 -0.047388528 0.09591329 -0.05334847 -0.015092843 0.03848885 -0.0032742515 -0.067997426 -0.2064592 -0.07066588 0.18297829 -0.16807866 0.019067826 -0.21372254 -0.1398291 -0.04160794 0.07007008 -0.079315916 0.02270034 -0.071150646 -0.05532892 -0.25630888 0.001137352 -0.0325383 0.058071855 0.011870452 -0.14212535 0.113551185 -0.1421415 -0.21145192 0.04316852 0.1380686 -0.018381922 0.15784839 -0.1495315 -0.12808917 -0.057998307 0.03216561 0.21876064 0.043028943 -0.098787524 0.103827976 -0.023234101; -0.20453459 -0.14456601 0.22325194 -0.16840704 0.092365995 -0.09550694 0.037168704 -0.00555043 -0.1511807 -0.14426583 0.059873804 -0.13264771 0.0018674587 -0.038717095 -0.22741236 0.066081084 0.17455633 -0.18362072 -0.27420506 0.046715654 0.045141254 -0.106515124 -0.045277037 -0.114459895 0.16188802 -0.00055227056 -0.15347508 -0.057450134 -0.13021582 -0.054180227 -0.20801622 -0.037739225 0.18801378 0.060650527 -0.031898018 -0.039456412 0.08324618 0.1853146 0.020982223 -0.17713714 0.051187184 0.13321517 -0.18225253 0.0056565073 -0.019946016 0.042862497 0.19294254 0.06761442 -0.030596994 0.11609625 -0.04409928 0.009779772 -0.11400734 0.23196852 -0.12045389 0.030946616 -0.23680285 -0.13190676 -0.03738227 0.057629682 -0.097651444 -0.07905892 -0.17223921 -0.014779276 -0.23224682 0.09512125 -0.071295656 -0.057788394 -0.037577312 0.22629635 0.021347659 -0.14577918 -0.0038873157 0.12739603 0.019382883 -0.0760767 0.030167658 -0.111888714 -0.14473204 0.14718276; 0.0017600933 -0.089472264 -0.17344014 -0.15768112 -0.20402417 0.04864564 0.115698196 -0.15344359 -0.0049265036 -0.14105192 -0.106532544 0.009694401 -0.09124367 0.054549657 0.039276112 0.17224407 -0.07463648 -0.16259257 0.04267229 0.17870395 0.057357173 -0.016125811 -0.18415242 -0.19226992 -0.29096612 0.108573966 0.0441436 -0.12058182 -0.14604439 0.10194548 0.18433385 0.026878495 0.07153509 -0.13987905 0.13650964 -0.1689694 0.17242065 -0.07710683 -0.06470135 0.085508145 -0.012897175 -0.14516573 -0.012396025 -0.13627331 0.070743196 0.14443018 -0.053039137 -0.02772101 0.20325842 0.053865496 -0.16943769 -0.068654634 -0.18201838 0.015533066 -0.11479458 -0.11689409 -0.14564864 0.18390912 0.051250853 -0.109280616 -0.0860072 0.01250656 -0.013825562 0.006814693 0.056638613 0.08387956 -0.09594071 0.10681052 0.17541236 -0.19137011 -0.24317338 -0.014881018 0.050429314 -0.08388083 0.12795696 0.19308944 0.074543074 0.16271146 -0.1788585 -0.086371996; -0.20711432 0.0948396 -0.13354021 -0.0014438162 -0.1606772 0.11826788 0.3169612 -0.14186864 0.06607759 0.0799879 -0.208761 0.03641048 -0.027433788 0.10993698 -0.020115217 0.10118285 -0.113335304 0.13219367 0.12319986 -0.0129024405 0.04082322 0.21388207 0.16676588 -0.091848 -0.18188159 0.12034823 -0.10182215 0.040929593 0.052008227 -0.23597693 0.097152345 0.24628027 -0.13639684 -0.15160334 0.20904812 -0.0070851836 0.23348854 -0.10661744 0.095089145 0.0035675971 -0.19581898 0.20439562 0.03148257 0.0178888 0.15420389 -0.057207424 -0.09362584 -0.0046007214 0.26746607 -0.04659549 0.1572125 -0.02421789 -0.12744066 -0.0060321335 0.032621685 -0.1759428 -0.15062828 0.16053678 0.08914237 0.012882744 -0.1115166 0.11629341 0.114536695 0.066907845 0.07834035 -0.06623837 -0.11723183 -0.02443367 0.1484176 -0.051796664 -0.35799468 0.21803963 0.130605 -0.10794651 -0.13021804 -0.28133538 0.15328732 0.27329767 0.14077641 0.048318703; -0.0344884 0.04145565 -0.05575374 -0.03892721 -0.05520927 -0.0671275 0.22378336 -0.2799717 0.14446296 0.13485496 0.06582109 -0.09743826 0.17075443 0.08264019 -0.03704302 0.060981054 -0.0862632 -0.124352865 0.24941422 -0.06123604 -0.09453406 -0.11142881 -0.12141721 0.08201535 -0.12983836 -0.061641354 -0.052255984 0.18818627 -0.093316704 -0.06575918 0.269171 0.11523265 -0.06771514 -0.05042982 -0.056142226 -0.023098767 0.13527183 0.14761963 0.21788964 0.13957521 -0.14388925 -0.19032948 -0.07569241 0.112556525 0.09898521 0.1728739 0.19438146 0.029313497 0.16373856 0.054296184 -0.08738485 -0.11402969 0.020959785 -0.22525959 0.18974152 0.112692684 0.1396517 -0.015279957 0.004881245 0.18125106 0.116875246 -0.22083415 0.021842813 -0.08389109 0.052678883 0.20525973 0.13490368 -0.08942286 0.14673842 -0.049311243 -0.08417136 0.16878712 0.0021860998 0.12360089 -0.13585472 0.029932901 -0.0632784 0.16935353 -0.15878265 -0.02215273; -0.033675916 -0.019016724 -0.017020434 -0.07940528 -0.10011889 -0.056802653 0.09896754 0.060162548 0.07854852 0.11660573 0.14242491 -0.0025619157 -0.14966634 -0.069673024 0.23350014 -0.12748083 0.050775435 -0.0021101176 0.22655272 -0.10774875 0.06136189 -0.042286247 0.21159554 0.17960557 0.0057497406 0.16549993 -0.011557216 0.19688004 -0.08108907 -0.1315569 0.19709018 0.22890948 -0.0105265025 -0.18757486 0.0062641334 0.06519081 0.11578142 -0.012622989 -0.0966781 -0.1273617 0.16104999 -0.09241936 0.21491073 -0.17404287 -0.064800866 -0.06518089 0.043997172 -0.25056267 0.15060109 -0.1743076 0.16231263 -0.09022964 -0.2701659 -0.1460988 0.14786501 -0.031083908 0.090414315 0.21444704 0.07251513 0.10616498 -0.0040200027 -0.016332423 0.005535799 0.18734968 0.028306752 0.13037728 -0.17293698 -0.21244563 0.025867421 -0.14233588 -0.013695502 0.2373423 0.10417692 0.10749171 -0.20616622 -0.0363117 0.12169515 0.106012456 0.14225625 0.05832007; -0.1032907 0.09976111 -0.055089682 0.06687238 -0.23730122 0.19139107 0.028139738 0.054728378 -0.06444865 -0.060241103 0.05685816 0.25317264 0.20637701 0.062392175 0.04289857 0.13883607 -0.036692396 -0.03921013 -0.09067472 0.058179192 0.10246237 0.18880735 0.027946366 -0.256739 -0.112530835 -0.060507026 0.063619986 -0.26680017 0.0483936 0.060014375 -0.06575982 0.0143504 0.11397352 0.04324149 0.07616946 0.22925085 0.24263024 -0.020360272 0.22898622 0.2573375 0.0013079626 0.052863393 0.2389084 0.19835424 -0.10319287 -0.09706902 -0.13722773 -0.15291119 0.13916394 0.21431527 -0.009469232 -0.17462151 0.14018598 0.0077918693 -0.065232806 -0.094077945 -0.10736732 -0.089261025 0.15003385 0.039021637 -0.14082305 0.045089416 0.09551733 -0.09068284 0.093532294 0.14989299 -0.06299888 0.21660623 0.09378261 -0.077987544 0.067377195 0.12821142 -0.09719355 0.06985765 0.071390815 -0.0042343424 0.19305827 -0.095217116 -0.05761926 0.19866319; 0.22149019 -0.09682658 -0.22772303 0.036876492 0.08962418 0.3113184 0.056923058 -0.010418194 0.009180105 0.14531983 0.06839588 0.053045217 0.19625697 0.21984617 0.020561555 -0.20830305 -0.07423269 0.1298263 0.25440806 0.15810488 -0.18011092 0.12396889 -0.11858241 0.07936206 -0.007380092 0.18545444 -0.14542621 0.09683661 0.11121907 -0.032223787 0.08498071 -0.109626696 0.03658317 -0.14108694 -0.09268664 0.053934366 0.1812349 0.026386678 0.06734092 -0.02321666 -0.06695377 0.006737457 0.045766726 0.07175694 -0.12105396 0.2825434 -0.013747449 -0.015436717 0.0984899 0.01127223 0.06844257 0.010787766 -0.30137697 -0.18580055 -0.031022849 -0.033496883 0.14921722 -0.103503175 -0.03759631 -0.038456686 0.07604813 -0.04783015 -0.05809545 -0.06909684 0.0070030815 -0.052133694 0.11064056 0.16792218 0.15908538 0.009692927 -0.16520645 0.09097976 -0.15664579 0.024801765 -0.082182385 0.06148423 0.2431013 -0.023022963 0.08151031 -0.0119745; -0.17172872 0.11691311 0.03898666 -0.1757932 -0.03323955 -0.25724033 -0.124679 0.0053109042 0.12283661 0.18414916 -0.01560295 -0.16752316 -0.008834464 -0.23375927 -0.17002843 -0.21871814 -0.047509734 -0.23929453 0.057922855 0.02885268 0.19254854 0.095100075 -0.04129772 0.19115913 0.037119735 -0.028313184 0.018388296 0.20604762 0.13097088 0.052868236 0.05071755 -0.037534356 0.0081779845 -0.08306867 -0.11890926 -0.2551277 -0.19620404 0.1766648 0.12360547 -0.14946842 -0.0136751 -0.10267343 0.05602471 -0.23042676 0.004805769 -0.09304794 0.1355876 0.111007445 0.037393373 -0.13322526 -0.065549105 0.07685617 0.23241612 0.21683866 0.09324643 0.036898315 0.070946656 -0.04357576 -0.098710984 0.15651487 0.06307632 0.13955052 -0.17655455 -0.21488588 -0.18064673 -0.041142486 0.047497872 -0.15714172 0.020355457 0.14795512 0.23573205 0.012099959 -0.07428293 0.09355716 -0.19028199 0.055530343 0.034346953 0.14608526 -0.036668085 -0.13667122; -0.15418205 -0.02117381 0.06102203 -0.06533573 -0.1309014 0.1443779 0.06393009 -0.19007125 -0.026905527 -0.030773252 -0.0353249 0.3219146 0.057631224 0.06780306 0.06448586 0.008905477 0.07372309 0.046161927 0.094404325 -0.07982979 -0.093636386 0.086168185 -0.016227907 -0.063502856 -0.029628122 0.14892319 0.047043405 -0.0429477 -0.061706387 -0.086995065 0.14218272 0.11899794 0.12659517 0.010004879 -0.09656079 0.021913072 -0.01931619 -0.1814537 0.24559818 0.25078478 -0.0956559 -0.0333496 0.2240594 0.22552043 0.056037366 0.0035717722 0.056431502 0.04446339 0.15884615 -0.03947086 -0.01744914 0.007351216 -0.052227966 -0.11616762 -0.0073473137 0.16836643 0.004567513 0.17450525 0.19685319 -0.03090302 -0.067293994 0.15049168 0.054946233 0.29328242 -0.11829277 0.04085727 0.15412481 -0.0936302 0.060749132 -0.09262704 0.011184449 0.04509746 -0.058775272 0.20423143 -0.0020314932 -0.16569571 0.05575114 -0.0513382 0.023745807 0.09619001; -0.057050355 0.02704647 -0.06198206 -0.043842807 -0.14740081 0.28868482 0.24644637 0.08880413 -0.09288593 0.04682443 0.105730385 0.1662958 -0.11953657 0.13645014 0.21057153 0.078060836 -0.040008593 0.091821976 -0.02833991 0.13380174 0.08748256 0.17206545 0.0710655 -0.22133574 -0.21552227 -0.16079137 0.047371004 -0.12939474 -0.01817856 0.045030408 -0.044635784 0.22810727 0.12293537 -0.23522288 -0.026572583 0.0011449981 0.07174685 -0.097279444 -0.023696335 0.016541848 -0.07363193 -0.09522061 -0.038867142 0.012057275 0.0028878355 -0.08339103 -0.06258345 -0.14733501 0.2193013 0.05664505 0.14264227 -0.22582115 0.026515767 -0.18737617 0.12395783 0.14647722 0.00050504575 -0.08432781 0.120220974 -0.19402179 0.045394868 0.15967953 -0.06827056 0.08621145 -0.0016996589 -0.13627163 -0.12007614 0.07068416 -0.08872025 -0.16066435 -0.24359213 0.15054165 -0.1281102 -0.029873004 0.20990005 0.09105413 0.017334133 -0.14570446 0.055760063 0.14101902; -0.2366863 0.15801698 0.045673173 0.10190825 -0.1659206 0.11364754 0.00074561225 -0.25473127 -0.05286202 0.077933945 -0.07367717 0.0752963 -0.04293655 0.18745527 0.17578353 0.22550811 -0.12681234 0.11132424 0.21938574 -0.072600074 -0.10623522 -0.10579102 -0.07836675 0.24788412 -0.010386303 -0.036537405 -0.1612584 0.04899487 0.07927776 -0.24650632 0.1701577 -0.10162622 0.26722237 0.057089366 -0.11944148 0.08340031 0.1280875 0.088301264 -0.13288352 -0.15138404 0.07228501 -0.061018668 0.23920056 0.1466683 -0.07758183 0.15051751 0.07186484 -0.16594593 0.018573247 -0.1547109 0.18089741 -0.117644615 -0.20273271 -0.025471939 -0.09413425 -0.009561131 0.004468668 0.025042959 -0.04834995 -0.1433931 0.112785585 -0.00812522 0.019878166 0.24826947 0.0026015635 0.045042727 -0.10626005 0.11171136 -0.069815315 0.09763406 -0.05339227 -0.034323975 -0.045838367 0.00490764 0.084347755 -0.0030258773 0.04491423 0.0024449509 0.0023166693 -0.08634886; -0.08307229 0.033656433 -0.1616002 -0.07098856 0.08787161 -0.08801877 0.012488014 0.18106171 -0.1268326 0.09100836 -0.15535465 -0.11971254 0.06334687 -0.22599807 -0.1997136 -0.0048408057 -0.042470858 0.008313716 -0.031148816 -0.0546725 -0.044675965 0.0514391 0.048366744 0.048864048 -0.2214505 -0.13514563 0.04140522 0.13440476 0.10776857 -0.047592208 -0.29563713 -0.10194099 -0.18128222 0.19874635 -0.14591977 0.016130606 0.11073636 0.16141324 -0.07747751 -0.03060878 -0.031308908 0.099435456 -0.09913991 -0.17113027 0.05653745 -0.0033384208 -0.07314303 -0.20898224 -0.13832742 -0.096743174 0.17161226 -0.046988364 -0.037406743 0.25196388 0.078719005 0.045002524 0.05692761 -0.030853348 -0.1290919 -0.029590182 -0.042578805 0.022023952 -0.11308249 0.15998323 -0.0125109255 0.13698941 0.073315665 0.11105901 -0.04468058 0.05192547 0.1064528 -0.2237439 -0.14677127 -0.12521188 0.0075323754 0.18750119 0.12346106 -0.12637435 -0.16253056 -0.16879022; -0.06358025 -0.09618097 -0.030907199 0.04969255 -0.24537975 -0.08838086 0.20521064 0.007335588 0.11655299 -0.02904389 -0.19163835 -0.10096754 -0.07619587 -0.16427146 0.19364944 -0.07326664 -0.07874644 0.010410914 0.14356725 -0.01004327 -0.08096256 -0.053864643 -0.18796523 -0.11991501 0.06648018 0.04149536 0.08265845 -0.093923174 0.06271577 0.13570909 0.16031083 -0.08566537 -0.04037076 -0.06663003 0.027938284 0.12877208 -0.025054123 -0.07036293 -0.1436377 0.038451605 0.10353438 -0.08449047 -0.047222972 -0.08199619 -0.17548725 0.27410084 -0.13719305 0.05705418 0.06950857 -0.011010891 0.2004092 -0.06317185 -0.26454216 -0.17389727 -0.022498565 0.17053266 0.1943338 0.052133296 -0.047339708 0.039852317 0.12802222 -0.008733775 0.20256492 0.19084254 -0.14013761 0.17371728 -0.047444757 0.19437864 0.07029791 -0.1968347 0.040936075 0.19158883 -0.023963355 -0.20221475 0.07766238 -0.043450736 -0.040937755 0.08535995 0.151546 -0.12974377; -0.10652314 -0.015828358 0.22164245 -0.013664146 0.23824954 0.0011534818 0.10191235 0.148859 -0.17958114 -0.062104367 -0.016089719 -0.17780696 -0.11439384 -0.22407345 0.0735624 -0.012282607 0.02116735 0.034087982 -0.08823119 0.052437 0.17236221 0.0012571109 0.14150332 0.11516831 0.27932674 -0.02921002 -0.04585182 0.0916334 0.13513982 0.16830851 0.03771815 -0.11036389 0.10260548 0.06465359 -0.23147713 -0.15852223 0.14221042 0.08890287 -0.07100599 -0.14030965 -0.042355835 -0.06496612 -0.042624462 0.022255626 0.20343071 -0.1635058 0.16436154 8.804703f-5 0.025118373 -0.15954214 0.12641029 -0.01594038 -0.0673609 -0.013546726 0.05646972 0.105254285 0.019984152 -0.04934577 0.08239965 0.23856461 0.18869373 0.055872016 0.03652979 -0.18819676 -0.083810546 0.12057851 -0.1526845 0.009115804 -0.04174011 0.17529182 0.12091408 0.0136273205 0.03241556 -0.09296563 -0.17717698 -0.11354939 0.070840836 -0.100651756 0.12943883 0.049571387; -0.0110436585 -0.15838815 0.088399224 -0.11039252 0.07676849 -0.070364505 -0.1668052 -0.027049001 -0.028211707 -0.038180508 -0.0016152891 -0.09612758 -0.025109136 -0.14316128 -0.17068297 0.045485873 0.093233444 -0.24926426 -0.17392123 -0.09711194 0.011184792 -0.043191403 -0.07480054 -0.0046094884 -0.025248408 -0.0673885 -0.12883672 0.07181494 -0.04836141 0.11930584 -0.28230995 -0.0037944254 0.038076807 0.0102159185 -0.17782521 -0.17752728 -0.14822692 -0.096312635 0.07231536 -0.07205291 0.016212229 -0.14698265 -0.21650414 -0.051474687 0.14841156 0.039649047 0.08076007 -0.027552275 -0.23098733 -0.14068836 0.08746362 0.027579347 0.16387439 0.04232141 0.068692565 -0.03918639 -0.05379183 -0.23000501 -0.20417054 -0.09938768 0.018158952 0.039943293 -0.15843973 -0.2579495 0.13272108 -0.105274335 -0.15609759 -0.13407739 0.049789395 0.14329767 0.13154717 -0.070972465 -0.17046627 -0.12695444 -0.17010108 0.22453642 -0.12408513 0.028786598 -0.13681658 0.17020155; 0.11400576 0.099145845 -0.03097281 0.10249171 0.05553091 -0.24667504 -0.15075178 0.20133282 0.11232594 0.22964223 0.2869364 -0.09479467 0.08087342 -0.113917574 -0.12124283 0.0038209218 0.07915989 -0.21286266 -0.119621284 -0.02839058 0.02414808 -0.108549185 0.21239685 0.0015689682 0.008091163 -0.12953928 0.015312324 0.11774485 0.11118607 -0.09534208 -0.25734484 0.016747138 0.27046806 0.123045996 0.03304417 -0.096247986 -0.049526855 -0.081824295 0.07524233 0.10544803 -0.07090548 0.009697795 -0.08606672 0.0053953878 0.250731 -0.2027064 0.19044286 0.1330847 0.0246027 -0.008672063 0.097356014 -0.13516669 0.15252063 0.06722495 -0.03948585 0.08442916 -0.1872936 0.0054450403 0.0533971 0.26784766 0.10480749 -0.11139185 -0.13223463 -0.14270444 -0.064866215 0.046688396 -0.15135066 -0.20090097 0.035994414 0.09295151 -0.032272447 -0.05151829 0.16693975 -0.07129989 0.014422966 -0.15103927 -0.15413247 -0.17625052 0.04137403 0.07327019; -0.21058808 -0.17918272 -0.053840782 -0.053278107 -0.06780743 -0.22450303 -0.03247339 0.01994113 -0.12350665 0.022516536 0.21069811 0.08669736 0.1294683 -0.1431231 -0.12779492 -0.15429126 -0.017887201 -0.12977445 -0.15908052 -0.04954789 0.022063386 0.103819236 0.097530566 0.15931785 -0.018773459 -0.14275719 -0.09758708 -0.06096443 -0.11412542 0.14563519 -0.10550024 0.10646724 -0.10207298 0.22533081 -0.056676153 0.122772425 -0.22423327 0.0013114433 -0.103707835 -0.013288638 0.17318578 -0.07895932 -0.03287808 0.115222216 0.20359717 0.004404478 0.050553147 -0.05518516 0.14364181 0.07246328 -0.12992848 0.06303505 0.1661447 0.07600531 0.07753415 -0.08702286 0.11645503 0.08442498 0.02748648 0.11850853 0.026779545 -0.06990736 -0.04420635 -0.23493497 -0.047472253 -0.014001185 -0.074016124 0.114981264 0.24445981 -0.13787606 0.25203088 -0.14722523 -0.17926201 0.009514223 -0.08181489 0.057730902 0.027676055 -0.10879946 0.107357204 -0.053037405], bias = Float32[-0.0020642965; 0.010433546; -0.052034687; -0.102617; 0.09050658; 0.027559718; 0.06352824; -0.052314315; 0.004838579; -0.055930767; -0.13285841; 0.20950276; 0.13849363; 0.06529531; -0.010796459; 0.027360812; -0.008738697; -0.021163363; -0.0033850193; -0.023223368; 0.014715258; -0.14591852; -0.076331384; 0.19917583; -0.011118224; 0.05032566; 0.10767107; -0.105682604; 0.0426655; -0.045310628; 0.040792547; 0.06841404; 0.025788259; -0.24446703; -0.12874866; -0.024781791; 0.017397692; -0.22667505; 0.0013075873; 0.063841164; -0.14282678; 0.094765514; -0.0070236023; -0.0027020327; 0.10976913; -0.003702964; 0.24443173; 0.03888829; -0.005759049; 0.17971738; 0.023046479; -0.03501704; 0.07822693; -0.017826864; -0.07173352; 0.03672769; -0.0041673756; -0.10874977; -0.09611282; 0.13010362; -0.27653366; -0.07475395; 0.01789739; 0.016935958; 0.034699637; -0.029077007; 0.16345258; 0.040614452; -0.0857593; -0.061940882; -0.01669583; -0.015929174; 0.00091601035; -0.086630434; 0.07834824; 0.2247674; 0.01218485; -0.07010554; 0.105319895; -0.2774749]), layer_3 = (weight = Float32[-0.101103604 0.04239374 -0.30039996 -0.06487043 0.0453768 0.18171062 0.09667839 -0.14013915 0.0012850531 -0.007570808 -0.074609056 -0.026727673 -0.007873378 -0.10172904 0.054945827 0.152429 -0.024529291 0.096030116 -0.22412717 -0.07595622 0.11794065 -0.28787932 -0.033188738 0.14006357 0.10987238 -0.07124174 -0.12305233 -0.111580655 -0.021295633 -0.07923318 -0.008155207 -0.014786992 0.16403356 0.06524731 -0.16416293 -0.17391951 0.0753084 -0.089639306 0.10008591 0.08288738 0.016074952 0.074389644 0.0067483014 -0.06845881 0.21551885 -0.06425524 0.23491648 0.03381485 -0.12963432 -0.057237715 -0.008991099 -0.017162861 0.030713908 -0.08046313 0.07269304 0.01691459 -0.08193457 0.085706174 0.18003602 0.04413601 -0.13003643 -0.026780332 0.05693548 0.15122499 -0.06977816 -0.019751769 -0.0019012564 0.04077887 0.008315094 -0.18922259 -0.00818227 0.0037783755 -0.035542376 0.012280265 -0.09666073 0.12520924 0.14388326 -0.1199598 0.1795135 -0.019158205; 0.5712618 0.58205694 0.35110223 -0.53729355 -1.1829119 -0.11338047 -0.89723843 1.1310543 0.24810566 0.18943371 0.33682454 -0.5490288 -1.104171 0.12467214 -0.14682035 -0.42019352 -0.8489627 -0.20659478 -0.5646919 0.3017348 -0.08491902 0.66518545 0.7317058 1.273927 -0.613364 0.43623617 -0.21049245 0.12341904 0.37717143 -0.34605715 0.5661727 0.020094542 -0.3380909 -0.17759605 -0.9501097 0.4486456 -0.7514291 -0.6286226 -1.000665 -0.061543804 -0.18552515 0.47298348 -0.19057323 0.42443186 -0.41575694 -0.08806881 1.5410447 0.32079569 0.6169159 -0.3026592 -0.20345919 -0.34596622 -0.5788262 -0.5648634 -0.66758865 0.45682526 0.49237832 -0.56507224 -0.7661816 -0.29900625 -1.4355661 0.43418258 0.61629003 -0.094791755 0.48240244 0.0504753 0.08961177 -0.705635 -0.016704256 0.4380006 -0.58997726 -0.41003332 -0.07921697 -0.1611075 0.21626472 0.7970692 -0.506908 -0.36157382 -0.49925905 0.8595291], bias = Float32[0.05495226; -2.017828]))
loss_neuralode(p_trained_nonoise)

#moderate noise 

rng = Random.default_rng()
Random.seed!(99)
#Adding moderate noise to data:

x1=Array(sol)

x1_mean = mean(x1, dims = 2)
noise_magnitude = 7e-2
x1_noise = x1 .+ (noise_magnitude*x1) .* randn(eltype(x1), size(x1))


#-------------------------------------Defining the Neural ODE------------------------------------


dudt2 = Lux.Chain(Lux.Dense(2, 80, tanh),Lux.Dense(80, 80, tanh), Lux.Dense(80, 2))
#Setting up the NN parameters randomly using the rng instance
p, st = Lux.setup(rng, dudt2)




prob_neuralode = NeuralODE(dudt2, etaspan, Tsit5(); saveat = etasteps)

function predict_neuralode(p)
    Array(prob_neuralode(I, p, st)[1])
end


#training data
true_data= x1_noise[:,1:end-90]
### Define loss function as the difference between actual ground truth data and Neural ODE prediction
function loss_neuralode(p)
    pred = predict_neuralode(p)
    loss = sum(abs2, true_data .- pred)
    return loss, pred
end


p_trained_moderate = (layer_1 = (weight = Float32[0.06274652 0.076913275; -0.0050149695 -0.34796864; 0.5380974 0.5731256; -0.36632177 -0.36150137; -0.5139954 -0.37051824; 0.54200494 0.33440745; -0.27889723 0.09431302; 0.047110878 -0.0147285145; -0.32146877 -0.2828051; -0.48565075 -0.5318055; 0.5337195 0.3937191; 0.10075031 0.646225; 0.044507284 -0.5112309; 0.47753352 0.09506145; 0.43808585 0.31681344; -0.40016323 -0.16607817; -0.1942303 -0.41801277; 0.3263555 0.5592415; -0.010036998 -0.69888556; 0.3408766 0.10343322; 0.5073118 0.52813184; -0.05875861 0.0025794178; -0.43777576 -0.08983953; -0.44983238 -0.16652732; -0.06845735 -0.4549299; -0.40508336 -0.6173108; -0.037528057 -0.5397104; -0.15054673 0.13305834; -0.5451701 -0.66607904; 0.03515163 -0.5013855; -0.16165319 -0.17274478; -0.3586587 -0.13243777; -0.023520736 -0.5288118; 0.5325628 0.59499663; -0.3537058 -0.2989059; -0.37244606 -0.14527193; -0.4770352 -0.3496906; -0.48183587 -0.044099003; -0.30820277 -0.03542916; 0.20763119 0.5930445; 0.58203816 0.4981521; 0.45279548 0.34266075; -0.29801896 -0.6760179; 0.13196273 0.20517683; -0.5091524 -0.0829656; 0.09290318 0.45168164; 0.24171405 0.11385354; -0.08134808 0.020842625; -0.42576924 0.02799222; -0.24537683 -0.031148694; -0.20231943 0.20867704; -0.29146785 0.18246527; 0.14250661 0.33165652; 0.32993782 0.13618858; 0.041947156 -0.4775792; -0.6003978 -0.69980514; -0.050801177 0.26886824; -0.009882305 0.09311899; 0.40168446 0.119454205; -0.3574917 -0.19521415; 0.49218127 0.20003952; 0.23592144 0.58707005; -0.007092034 0.63650244; -0.4052655 -0.27537718; 0.08044687 0.10882868; 0.50239897 0.14654368; -0.44275647 -0.43235785; -0.26205096 -0.33574; 0.039746225 -0.15983273; 0.18258888 0.67788947; 0.6559577 0.44045472; 0.42050877 0.57605994; 0.13763209 -0.057964735; -0.16680169 -0.06715647; -0.5160421 -0.22913484; 0.0333703 0.2733464; 0.6082317 0.6007874; -0.5121425 -0.47383234; -0.32253397 -0.26255095; 0.40408725 0.6743529], bias = Float32[-0.18896908; -0.021328848; -0.42081234; 0.4071981; 0.4401224; -0.37695396; 0.3841784; -0.13508983; 0.2799465; 0.43759906; -0.36800706; -0.0070309616; -0.036061347; -0.40921965; -0.33852652; 0.29178637; 0.20209967; -0.33103037; -0.052907255; -0.32391453; -0.4439809; -0.08811653; 0.41599497; 0.34231782; 0.05972127; 0.3667593; -0.12032869; 0.17754942; 0.45963556; 0.020396464; 0.10682061; 0.33300084; 0.1240374; -0.49473372; 0.3890302; 0.34986645; 0.32285836; 0.35426328; 0.3824914; -0.17186299; -0.54788995; -0.4395945; 0.35514244; -0.06781478; 0.40623415; 0.052641477; -0.2799321; 0.17152162; 0.34490082; 0.2973188; 0.2483377; 0.2813499; -0.19341029; -0.3444874; -0.06290809; 0.5331441; 0.06278343; 0.107246205; -0.34198707; 0.3243073; -0.45527965; -0.22274229; -0.1840518; 0.2895781; 0.10386951; -0.39917764; 0.31320363; 0.26213297; 0.058479432; -0.19473979; -0.624076; -0.37245372; -0.24050546; 0.21090943; 0.3678023; 0.0019375797; -0.5364148; 0.5150759; 0.30186066; -0.3726476]), layer_2 = (weight = Float32[0.21879031 0.36036554 -0.40665832 0.03175893 0.059849434 0.33543208 -0.32621807 0.0938942 -0.10594505 0.29568082 0.10295929 -0.35296187 0.28845525 0.16905949 0.21132362 -0.039344963 0.26946723 -0.28608584 0.27404875 0.11080584 0.23025489 0.08860226 -0.21002 -0.052782778 -0.1218544 0.26724267 0.2016663 -0.2723504 0.049996506 0.26021573 -0.071666695 -0.07544984 0.4843865 -0.007995846 -0.002704101 -0.1361011 -0.22272225 -0.30874088 -0.17538732 -0.51019025 -0.4407353 -0.039993938 0.24090934 -0.030016983 -0.20651177 -0.4814932 0.14382233 -0.15843382 -0.11444794 -0.3324877 -0.3584658 0.02877567 -0.30327514 0.07395757 0.28931233 0.2180322 -0.11574531 -0.29070926 0.16778247 -0.2593635 0.038202498 -0.4993241 -0.53778356 -0.24680632 -0.22387029 0.0596565 -0.07343649 -0.25145626 -0.1251302 -0.20078099 -0.26580697 -0.4012042 0.38572547 -0.29214668 -0.12048552 -0.3789783 -0.09645377 0.2189234 -0.17590368 -0.33153194; -0.028965827 -0.22029886 -0.42020476 0.14794539 0.13391115 -0.22302708 0.08510083 -0.05446791 0.1805503 0.33942837 -0.4638563 -0.22065191 -0.016155604 -0.22347072 -0.27721 0.46632382 0.25668532 -0.20310628 -0.14735217 -0.2991958 -0.2483371 0.13140772 0.22219308 0.34431362 -0.17568344 0.17932425 -0.13263054 -0.020321725 0.4981267 -0.16390046 0.16733891 0.48016888 -0.035474855 -0.3699312 0.19231324 0.26654458 0.4768857 0.29572564 0.10116739 -0.4387767 -0.27320465 -0.08497388 0.16805078 0.10412083 0.25437528 -0.13862465 -0.2944104 0.1715971 0.3178859 0.21615759 -0.09067332 0.06375066 0.07629073 -0.1339962 -0.062456608 0.42997947 -0.048487466 -0.11650097 -0.54657096 0.21402621 -0.48719642 -0.21337214 -0.48926082 0.43962687 -0.07793879 -0.47207463 0.5023807 0.39803138 0.10943084 -0.3964563 -0.4800543 -0.26632777 -0.056668185 -0.0055840826 0.442752 0.000905137 -0.28400278 0.35765672 0.24912046 -0.4477408; -0.17089307 -0.2198617 0.5094325 -0.19706763 -0.043816607 -0.14130676 0.3493974 -0.1560086 0.053361423 -0.15901382 -0.052106492 0.42740235 -0.5727154 -0.28792712 -0.30889213 0.13779402 -0.4447647 0.28967035 -0.34779295 -0.3187575 -0.21250635 -0.15907528 0.22772957 0.26414394 -0.4590934 -0.32609215 -0.469363 0.2454244 -0.24899806 -0.26946545 0.019336239 0.05190259 -0.585452 -0.0921227 -0.2437649 0.011384504 0.047759566 0.034365434 0.15478449 0.43783528 0.6545912 0.14527823 -0.35814196 0.075157434 0.1470642 0.1735706 -0.30165064 0.1772203 0.024366854 0.040193982 0.12246426 0.2119883 0.38949212 -0.31336772 -0.3126149 -0.31283244 0.30450702 0.22134084 -0.13815784 0.06621259 -0.024923166 0.52456826 0.5003977 0.00544255 0.08308031 -0.17547564 0.030476447 0.12621672 -0.0027965452 0.32740077 0.39942646 0.34353706 -0.028664302 0.18109663 0.033287168 0.33107826 0.10279522 -0.4569065 0.21221651 0.6403855; 0.18923014 0.033646308 0.1931276 0.086872205 -0.05831295 0.09889447 -0.17453903 -0.095207535 -0.40921244 -0.08229802 0.021477379 0.01984038 -0.32450473 0.016062936 0.19316311 -0.23886335 0.11210485 0.027472718 0.055560607 0.09857472 0.027522884 0.16911872 -0.13323128 -0.19543797 -0.5737852 -0.18208857 0.18258475 0.14399648 -0.037626825 0.19494253 -0.18252201 -0.24028297 -0.38404933 -0.04428509 -0.17558199 -0.28348428 -0.03507032 -0.04015551 -0.05842131 -0.15399455 0.07297675 0.14900427 -0.25007933 0.15233849 -0.017946614 0.10279688 0.39071178 0.07439885 -0.05569395 -0.29864246 0.1134888 -0.05016645 -0.09981218 -0.1602812 0.09232602 -0.010640719 0.027681844 -0.052000154 0.060478 0.0026687596 0.008094796 0.084268145 -0.0013066892 -0.16743615 -0.002596572 0.18546821 -0.30792528 -0.42547885 -0.22735862 -0.02140096 0.0679739 0.5164545 0.11485945 -0.07897873 -0.12610209 -0.18715559 0.23921926 -0.13745166 -0.13865861 0.121457614; -0.037021413 -0.09444187 0.2529805 0.02076152 0.1043672 -0.18823312 0.114807 -0.19008088 0.19882731 0.1196024 -0.14451721 0.16445573 -0.21361272 -0.20255129 -0.25568378 0.06508346 -0.24241702 0.42223638 -0.43074724 -0.25026026 -0.0012042676 -0.112672135 0.24203984 0.34452114 0.07463568 0.022476213 -0.18807139 0.11764232 0.27028516 -0.31569126 0.118333615 0.17859289 -0.2377227 -0.08751795 0.06098952 0.25347897 0.13477565 0.26179302 0.018388044 0.37210256 0.38084292 -0.11736526 -0.4926468 -0.003137593 0.25178307 0.12854353 -0.06562857 0.28275657 0.22783603 0.17425242 0.37847635 0.0147368135 0.270101 -0.14465545 -0.22757937 0.19088766 0.26068497 0.3939498 -0.1456356 0.13954853 -0.3385102 0.458421 0.2965741 0.2844425 0.09570829 -0.21532558 0.34533766 0.00888354 0.28004053 0.2773582 -0.116154164 0.035632793 -0.097873956 0.37907252 0.24867147 0.20357375 -0.21826337 0.042216856 0.22003458 0.5734168; -0.045186944 -0.19044296 0.07156421 0.048589233 -0.19904837 0.0787008 0.22655602 -0.07503601 0.37176907 -0.032130435 0.0017088673 0.28230682 0.298588 -0.07087306 -0.10073443 0.25425303 -0.025748352 0.15294385 0.07270241 -0.19866998 0.17319459 -0.1762141 -0.10335885 0.18180999 0.36922505 -0.2749191 -0.24956954 -0.08590108 0.13562123 0.065133765 0.17401356 0.16868137 0.42477727 0.13790183 -0.22798657 0.29922077 -0.024451405 -0.060562503 -0.04696459 0.3128327 0.166719 0.101189 -0.21535939 -0.06854745 0.03171418 -0.08206548 -0.14148788 -0.008184888 0.23578936 0.36024523 -0.06348513 -0.17077328 0.07448303 0.027677506 -0.07318586 0.12342674 -0.12003309 0.1567664 -0.31397042 0.13826056 -0.24529165 0.1136721 0.16604017 0.24376489 -0.047451895 -0.06386585 0.29394457 0.45204142 0.29693526 -0.0321691 -0.02032093 -0.33617094 -0.11815948 -0.038698684 0.050257683 0.17619494 0.19068982 -0.20086867 0.076539196 0.09217244; 0.16906151 0.049553618 -0.46160263 0.11008692 0.08578242 -0.099448055 -0.11977125 0.2564455 0.036707293 0.4646497 0.09081907 -0.6080803 0.17517677 0.11375941 0.0043772478 -0.28232932 0.14494966 -0.47084373 0.35333923 0.12571433 -0.14728777 0.45656893 -0.09308104 -0.07175648 0.47720405 0.576124 0.14724672 -0.13064896 0.45939335 0.22808602 -0.2735629 -0.15397316 0.47468203 -0.4411541 0.042219136 -0.17804734 0.12943916 -0.13864154 -0.1582786 -0.37080202 -0.30280998 -0.20470095 0.6924367 0.082580596 -0.01712161 -0.28549746 0.057274833 -0.2917176 -0.048139434 -0.20591052 -0.22770627 -0.00019009996 -0.22604167 -0.049320143 0.24268487 0.40299028 -0.09489395 -0.07167336 0.102962926 0.0057346225 -0.059343055 -0.22141324 -0.594893 -0.12714987 0.003779678 0.038875937 -0.040386457 0.15173556 0.012025576 -0.67826605 -0.60784537 -0.50441355 0.21975493 -0.3512467 -0.04658513 0.047505073 -0.39804497 0.4298691 0.016701417 -0.7555086; 0.16774024 0.13474727 -0.43716273 0.2098722 0.08630244 0.13807252 -0.29970455 0.13065459 -0.32959157 0.121355414 -0.02973781 -0.52712685 0.3655484 0.1847659 0.07253809 -0.02670263 0.21312991 -0.25583166 0.25347924 0.25964186 0.23809665 0.0012033401 -0.009080923 -0.025005827 0.06716788 0.30527255 0.41797414 -0.17397802 -0.14570689 0.29828468 -0.33427295 -0.053894754 0.6858988 -0.15690835 0.10536291 -0.052221976 0.032501858 -0.37084728 -0.058566894 -0.42275798 -0.20548062 -0.22592507 0.39208513 -0.037151862 -0.12681806 -0.14709316 0.051414948 -0.012754151 -0.02709152 -0.34508112 -0.27355286 -0.1745695 -0.14363971 0.27641815 0.19038728 0.08816022 -0.08501142 -0.21444115 0.116852686 -0.032839708 -0.029629705 -0.5057051 -0.48485956 -0.24942692 -0.15849972 0.034613315 -0.24973488 -0.17168687 -0.10482288 -0.31153575 -0.26917955 -0.0502607 0.03328522 -0.020332158 -0.036217347 -0.38247466 0.099312246 0.15721579 -0.046526667 -0.36142537; 0.090097435 0.07066691 0.2524627 -0.099816926 -0.40553823 0.52006125 -0.35389075 0.12943463 -0.38736817 -0.24808781 0.38832107 -0.15720344 0.078780875 0.2363138 0.16493027 -0.24930976 -0.009170101 0.110644266 0.27816334 0.17598356 0.19114777 0.094144635 -0.31509084 -0.38902396 0.025267724 -0.15742634 0.3359382 0.009678346 -0.16849037 0.26298213 -0.35794774 -0.5666815 -0.03618643 0.16418676 -0.051778246 -0.4723601 -0.16400202 -0.3007456 -0.13013804 0.123392634 0.24701966 0.43906572 -0.10271405 0.075786635 -0.5054772 -0.19799772 0.47576615 -0.057663742 -0.31170458 -0.34999815 -0.14764884 -0.123682395 0.18328789 0.19840048 0.07080777 -0.40369546 -0.22892883 -0.15197149 0.44830945 -0.3347399 0.2695028 0.05828752 -0.08547428 -0.24231282 -0.019584214 0.47108433 -0.13242799 0.019072765 0.06991876 -0.16988312 0.39339143 0.29028004 0.11619311 -0.29593077 -0.49042585 0.057383657 0.3567621 -0.45963043 -0.36839408 0.16575867; -0.044959366 0.03765924 0.6196556 -0.20694199 -0.31399003 0.3974623 -0.21232049 -0.16252758 -0.08263148 -0.22543603 0.3285564 0.15332314 0.19220445 0.22650306 0.038965013 -0.23464301 -0.21219464 0.13392588 0.12578386 0.10706437 0.115084894 -0.1700771 -0.21194065 -0.36007482 0.17671123 -0.3569304 0.17092738 0.018564237 -0.36671603 -0.2186344 0.27820498 -0.4318675 -0.038811687 0.17702821 -0.0047548013 -0.22305074 -0.16718125 -0.21411505 -0.109527655 0.18765005 0.62427837 0.22330534 -0.17515478 -0.054512862 -0.351642 0.09219063 0.045992207 0.0013908176 -0.15256831 -0.12819915 -0.21061946 0.0863183 0.039564367 0.17566918 0.098339684 -0.3602835 -0.0955204 -0.005243818 0.40786323 -0.30976334 0.41816497 0.012710802 0.12500766 -0.21369368 -0.009065063 0.25919685 -0.24311498 -0.09823951 0.19381838 0.34817705 0.41961914 0.033968274 -0.12597066 -0.14705734 -0.23852807 -0.06838939 0.46283275 -0.5437903 -0.36154583 0.1496744; 0.0064713727 0.28920084 -0.303012 0.33593032 0.043176282 0.055178586 -0.13903049 -0.028866587 0.02729639 0.13466872 -0.008002098 -0.30193937 0.5767479 -0.022810016 0.007498034 0.05516264 0.49903467 -0.2783486 0.21760753 0.022574855 -0.06474782 0.19498754 -0.0744009 -0.0066867587 0.3380884 0.20708323 0.17568287 -0.22705536 0.14152591 0.23899408 -0.004915681 -0.064565144 0.7069147 -0.055684358 0.1426288 -0.03137905 -0.10756814 -0.12246343 -0.0752093 -0.3936261 -0.42633593 -0.31557897 0.608812 -0.22104172 -0.051276512 -0.16390225 -0.041463166 -0.06269653 -0.088854015 -0.09112205 -0.18064705 0.057057817 -0.3027027 -0.16271466 0.24516627 0.3420874 -0.2456793 -0.12905163 0.19256695 3.3627774f-5 -0.04116311 -0.33427352 -0.36696798 0.08547586 -0.1527333 -0.07198836 0.016939422 0.0054814415 -0.11262422 -0.638339 -0.28830558 -0.16214903 0.24144797 -0.16149327 -0.2516152 -0.26145166 -0.11847527 0.31803972 -0.060625266 -0.26431558; 0.32692027 -0.011934418 -0.5376313 0.19062729 0.16145997 -0.1324732 -0.20331514 0.14852507 -0.10715685 0.12801059 -0.11497837 -0.3341013 -0.1084259 0.108173855 -0.16077352 -0.14401457 0.33108437 -0.24357586 0.23438299 0.049995 -0.21926026 0.17071177 0.020684225 -0.14671823 -0.03606544 0.1253422 0.3096408 -0.38114646 0.27445742 0.2596492 -0.06276522 -0.058188137 0.070877634 -0.43934909 0.21781482 -0.0428861 -0.06837564 -0.07995523 -0.17807692 -0.48441848 -0.28296584 -0.29454482 0.39302906 0.07681264 0.022821061 0.02525265 0.13363308 0.03754403 -0.058776356 -0.2152389 -0.3190592 -0.1585414 -0.09487457 -0.08285657 0.4188266 0.330606 -0.201063 -0.24031903 0.1775925 -0.15338466 -0.023897553 -0.34911925 -0.583331 -0.12677617 0.2180436 -0.11736065 -0.03907516 0.020389233 -0.099342845 -0.26879397 -0.17518987 -0.3705575 0.16793367 -0.29354876 0.044310503 -0.2169819 -0.40132028 0.37776908 0.013864923 -0.39954197; 0.3376911 0.3126534 0.14203757 -0.199223 -0.20522176 0.35141835 -0.43213832 0.12908714 -0.1304007 -0.3750806 0.23054619 -0.3604973 0.011658503 0.40775463 0.2434552 -0.39208543 -0.07779003 -0.081122294 0.25910908 0.3256963 0.4084128 0.1361015 -0.2187692 -0.2550742 0.123736 0.024273425 0.23414657 -0.021034852 -0.25607625 0.046305444 -0.14324723 -0.44656152 0.34329188 0.3911433 -0.31176633 -0.4254662 -0.3622695 -0.3306483 -0.35164696 -0.24461345 0.0832714 0.4367181 0.16994914 0.06986451 -0.22307675 -0.026639562 0.41843545 -0.26920292 -0.5260547 -0.3822034 -0.1980686 -0.3258894 -0.11435216 0.16921657 0.22488539 -0.40339643 0.0029602863 -0.06350958 0.38283473 -0.29460317 0.4908936 -0.14005193 -0.27345696 -0.24746016 -0.06346575 0.4485684 -0.22738291 -0.40169638 -0.11003767 -0.03084558 0.42639595 0.0972143 0.44012487 -0.07562792 -0.42761257 -0.18960194 0.43418428 -0.28031912 -0.20146301 -0.0072483844; -0.35641393 -0.14592536 0.39250788 -0.032526057 -0.3984857 0.18233158 0.03658576 -0.19449922 0.006296568 -0.22117637 0.14119473 0.5766699 -0.21322045 -0.07020825 0.123435095 -0.057037815 -0.24259135 0.5268769 -0.30755246 -0.23203804 0.41409558 -0.15433428 -0.023627339 0.15316933 -0.064269215 -0.49312255 -0.08860876 0.39346495 -0.5392102 -0.24897142 0.2201959 0.2520989 -0.13037947 0.5877394 -0.135823 0.29624924 0.015519048 0.056567635 -0.05661075 0.5735506 0.6357903 0.27041408 -0.6143875 -0.10012556 0.07437582 -0.109295286 0.02474879 0.22346163 0.24057882 0.050939634 0.4180397 0.110312164 0.055088513 -0.07459641 -0.18334424 -0.57566583 0.042761296 0.36727038 -0.25051382 -0.08949903 0.032801874 0.3420258 0.62162256 -0.106227145 -0.115008034 -0.048464842 -0.17798021 -0.21946593 0.270866 0.57810354 0.64910257 0.49856347 -0.17413281 0.25309476 -0.10668387 0.060135566 0.45398137 -0.4077284 -0.011324217 0.3909022; 0.06882727 -0.0576966 -0.49072117 0.23565951 0.22171794 -0.24526642 0.1853177 0.0927556 0.26603442 0.13569747 -0.38384777 -0.2516301 -0.14431724 -0.21507265 -0.12654008 0.23974724 -0.039143648 -0.1606816 0.14338256 -0.12762931 -0.34563008 0.2795147 0.30892766 0.39263722 0.078282066 0.451418 0.0015736561 -0.08344153 0.30921087 0.1948467 -0.017441968 0.22009772 0.03399036 -0.3617143 0.2443081 0.2164675 0.33253908 0.23798764 0.12319694 -0.62382865 -0.3604956 -0.46890226 0.45690197 -0.16625139 0.1859653 0.038766984 -0.2074296 -0.17714085 0.26312837 0.02718753 -0.090423495 -0.013296671 -0.31705654 -0.23541656 0.21986824 0.38474524 0.111109555 -0.019121747 -0.29155776 0.036659177 -0.34915522 -0.12135012 -0.29141432 0.27873883 0.041089702 -0.10294869 0.20807286 0.34092152 -0.1544257 -0.29929402 -0.33326218 -0.15909374 0.1283905 0.01250174 0.36743414 -0.027343621 -0.5126034 0.17687924 0.39472514 -0.37631992; -0.2675531 -0.11481311 0.28346467 0.03182811 -0.13500658 -0.122697376 0.343758 -0.07319118 0.22477795 -0.33779836 -0.24727462 0.48931682 -0.46900973 -0.28432325 -0.0010384944 0.15400799 -0.50169307 0.18269886 -0.14712615 -0.11908261 -0.11391132 -0.31753418 0.28917 -0.0007277101 -0.096352965 -0.09801629 -0.28939566 -0.004371474 0.00085802877 -0.24172758 0.36205685 0.13032645 -0.26309025 0.079286344 -0.12068656 0.31170782 0.09587001 0.18535167 0.30317396 0.30534104 0.20040688 0.031458236 -0.3083801 0.27498868 0.0526265 0.4211913 -0.09758329 0.21652916 0.3429472 0.17800006 0.32521302 0.017090471 0.45090997 0.06037672 -0.26194206 -0.13810003 0.43528384 0.17596026 -0.063137785 0.06932049 -0.2523162 0.4074213 0.14750369 0.28823513 0.04144565 -0.17873101 0.1849301 0.29646704 0.21885927 0.29024908 0.28978765 0.108295314 -0.29407185 0.013764226 0.2673846 0.16007121 -0.24878944 -0.2512803 0.03667572 0.17677483; -0.07105977 -0.35597193 0.31048888 -0.063399844 0.11655384 -0.23468046 0.18366593 -0.40487045 0.34125683 -0.008564269 -0.12280321 0.5279152 -0.59298635 -0.14198086 -0.15382567 0.1462941 -0.17735617 0.23081556 -0.13130869 -0.122883014 -0.22153814 -0.097102016 0.12614392 0.053369638 0.094648294 -0.16982749 -0.20219971 0.14069097 0.10223197 -0.370261 0.11985445 0.28506505 -0.46176788 -0.1634392 0.13491048 0.041171912 0.30389032 0.3047143 0.15910745 0.45273042 0.39053807 0.19952823 -0.54853714 0.31630135 0.26311636 0.28180307 -0.093573585 0.23703422 0.019150412 0.16125645 0.22845599 0.021063093 0.09823038 -0.22313924 -0.27020344 -0.13736987 0.36836645 0.11774118 -0.2277589 0.29722667 -0.013160478 0.2419692 0.5583672 0.049414303 -0.00028911795 -0.13303794 0.2454134 0.08832789 0.13044456 0.48216546 0.13195415 0.20300858 -0.29784432 0.28774953 0.030360483 0.34358576 -0.014020705 -0.24744613 0.28570768 0.35910684; 0.18469256 0.08187948 0.1439742 -0.38830316 -0.25058755 0.28395554 -0.4671517 0.036911663 -0.1314617 -0.29619536 0.3510438 -0.37171194 0.13848688 0.3501076 0.15628445 -0.29878104 0.07009154 -0.050915573 0.18110259 0.30496636 0.16635126 0.21895301 -0.36285695 -0.24049851 0.0907026 -0.26638776 0.3021871 -0.3918726 -0.108436435 0.19828805 -0.43400314 -0.24573618 -0.057816602 0.30167726 -0.45088023 -0.29847488 -0.15600528 -0.39993668 -0.3056291 -0.19902113 0.21203035 0.353835 -0.09601757 0.20231427 -0.31295967 -0.16911937 0.28739718 -0.26874703 -0.40432397 -0.5035813 -0.31032073 -0.37290332 -0.0022034151 0.36685526 0.18794253 -0.041673575 -0.2294933 -0.39783576 0.3308895 -0.4397813 0.35380417 -0.07498403 -0.2957677 -0.21095736 -0.114081345 0.33978343 -0.42332417 -0.08271323 -0.21823098 -0.07714141 0.47986794 0.014109536 0.4072738 -0.26809874 -0.15991038 -0.04273566 0.2852323 -0.24576819 -0.39112368 -0.071884215; -0.32267037 -0.3823999 0.47543168 -0.26399383 -0.086314715 -0.04050629 0.24142 -0.32940757 -0.016262181 -0.10295423 -0.06408222 0.3226168 -0.6388125 -0.009220345 -0.26941252 0.117051415 -0.36612165 0.36599365 -0.19874129 -0.079597555 0.01818745 -0.0067764814 0.2196491 0.18134616 -0.20192496 -0.36652988 -0.4418892 0.3780874 -0.21772069 -0.37647936 0.13493472 0.040241353 -0.8926006 0.26092917 0.11405982 0.19023558 0.28606215 0.1725395 0.2784721 0.5421415 0.52121544 -0.058560837 -0.49601582 0.008865512 0.06629967 0.46054927 -0.0070983036 0.25818878 0.10714898 0.13409775 0.10463409 0.31021586 0.21641026 -0.14638273 -0.042466138 -0.2805091 0.13135986 0.047962077 -0.2949126 -0.0050776927 -0.2392014 0.25992575 0.40480903 0.26835394 -0.000963561 -0.3482032 0.19969217 0.16447118 0.3046581 0.55352664 0.30119765 0.70471394 -0.25507286 0.23780213 -0.021936558 0.25341564 0.15599085 -0.25385642 0.03032918 0.48340353; 0.01930901 0.30726308 -0.18552513 0.06658052 -0.028295353 0.18314606 -0.049402073 0.19191827 -0.06859184 0.12898827 0.3793369 -0.5019255 0.40449235 0.0499612 0.06446448 -0.13285148 0.23174772 -0.5538747 0.17406078 0.1935609 0.023115594 0.092701435 -0.31456846 -0.10434657 0.1297757 0.19528386 0.3057742 -0.30428612 -0.060225006 0.4899504 -0.26956803 -0.058171403 0.59367335 -0.066289075 0.08784748 -0.24388419 -0.1887637 -0.24623996 -0.3009597 -0.44376045 -0.26648197 0.14464043 0.3255438 -0.10792961 -0.22186959 -0.25564346 0.25054225 0.077562146 -0.13593459 -0.018277226 -0.14491016 -0.0803867 -0.39360735 0.06394174 0.19520164 0.07549946 -0.37967572 -0.27186215 0.13467245 -0.06459621 0.06280775 -0.20312594 -0.41889203 -0.33290946 -0.13592167 0.062041733 0.022282375 -0.01879673 -0.08881884 -0.53976464 -0.0020577952 -0.2777715 0.36628446 -0.1385448 -0.35820565 -0.40274554 0.13157298 0.056895733 -0.23614411 -0.19683139; 0.4318154 0.24187605 -0.33037063 -0.093201086 -0.084010184 0.3796504 -0.282101 0.08810645 -0.38137132 0.043886106 0.15287204 -0.30697748 0.3076743 0.3138635 0.09093199 -0.16692936 0.060004327 -0.24552369 0.2509411 0.2482132 0.2862538 0.29706636 -0.4605561 -0.42027575 0.09092579 -0.011161438 0.15386304 -0.4033979 -0.2338497 0.18004501 -0.16945608 -0.4426701 0.40191475 0.16823496 -0.34790295 -0.33093008 -0.45615435 -0.51704246 -0.26526582 -0.12137706 -0.014758104 0.10567155 0.26017302 -0.10710081 -0.2969639 -0.22976564 0.22971822 -0.16031119 -0.21500516 -0.20828111 -0.26920384 -0.38486367 -0.17033264 0.42510852 0.20660126 -0.22845626 -0.14937139 -0.20904869 0.53121936 -0.22615837 0.48326552 -0.066052966 -0.39008906 -0.25781232 -0.00704749 0.39212522 -0.07143279 -0.31649297 -0.08000089 -0.45017526 0.5190286 -0.054309472 0.1940804 -0.03217282 -0.4578819 -0.18600556 0.3159194 -0.3506274 -0.21598093 -0.09173341; -0.14255513 -0.05447362 0.5203522 -0.20970768 -0.23515919 0.05908208 0.21853967 -0.075754225 -0.27497983 -0.14059684 0.21833271 0.45876712 -0.05239356 -0.033791367 0.33939323 -0.0355804 -0.11289549 0.39476794 0.096833065 -0.13692896 0.41093418 -0.15710828 0.025199436 -0.24242117 -0.20607023 -0.42057493 -0.2270346 0.19438656 -0.51940775 -0.20939004 0.28184402 -0.14465997 0.079446696 0.4598106 -0.044688575 0.09766936 -0.2702065 -0.027970705 0.11534099 0.6883958 0.2277369 0.061798416 -0.5930138 -0.043249723 -0.14448564 0.22267656 -0.027609274 0.26224002 0.19569746 0.22066946 0.18334097 0.14348084 0.23021561 0.01048812 -0.23334932 -0.47457138 -0.081368566 0.15738955 0.04811683 0.08493394 0.2106179 0.25433168 0.3526219 -0.3049824 -0.104166396 0.10336563 -0.35189533 -0.016021203 0.20225318 0.4859794 0.5404232 0.54785055 -0.45150203 0.047055762 -0.10732993 -0.005325109 0.3917523 -0.39523908 -0.120104805 0.3925751; -0.22628643 -0.32259277 0.39669263 0.08570999 0.11933574 -0.12223427 0.24115123 -0.13859344 0.19450708 0.10046437 -0.38615403 0.24414656 -0.48297158 -0.19927652 -0.13502283 0.36819687 -0.3649781 0.43697834 -0.16358338 -0.19657324 -0.043567296 0.023425655 0.3449389 0.10477435 0.10946024 -0.21909747 -0.39954868 0.27378374 0.21794905 -0.23786044 0.13459776 0.05539246 -0.46985054 -0.33540812 0.033541683 0.33259845 0.35338697 0.19623014 0.013583442 0.2878588 0.36914125 -0.16019273 -0.23115112 0.32126248 0.3465054 0.23340409 -0.19648004 -0.10773447 0.3931368 0.1355665 0.32496116 0.11961614 0.32755733 -0.13526559 -0.19249095 0.070347115 0.2437088 0.085806616 -0.26966044 0.037748937 -0.13208912 0.30022752 0.35326248 0.3574859 0.05876859 -0.2599323 0.08928891 0.015947886 0.03195879 0.27526516 0.07518428 0.06515078 -0.35677207 0.2667454 0.3257441 0.18709533 -0.12972498 -0.25951672 0.2514494 0.13577995; 0.16643375 0.1410768 -0.28559446 0.043985214 0.3485531 -0.254311 -0.17581391 0.23900908 0.24753317 0.4585265 -0.45607784 -0.252706 0.073294714 -0.28869504 -0.12638682 0.36611483 0.06699668 -0.16167662 0.077689506 0.11509549 -0.47788897 0.05535714 -0.02683581 0.03332147 -0.08469076 0.38465533 0.240616 -0.2622109 0.40636605 -0.09421828 -0.30517912 0.31447738 0.14212273 -0.2071797 0.04119403 0.050999656 0.37287554 -0.031839453 0.029437153 -0.38463056 -0.2147936 -0.26084337 0.44528192 -0.11295365 0.19565454 0.03885551 0.041479614 -0.24990381 -0.009456818 -0.105097026 -0.087537535 -0.15797147 -0.034063954 0.11091152 0.23018007 0.48669192 -0.011463644 -0.342978 -0.021587696 -0.10588809 -0.10941409 -0.0633329 -0.28324017 0.2671166 0.044389267 -0.23922835 0.12903422 0.15458024 -0.31093395 -0.53525895 -0.49450436 -0.41508552 0.39697355 -0.11950916 0.16259058 0.013158001 -0.4761703 0.21686795 0.3751638 -0.33278832; -0.16131596 -0.22091897 -0.20948003 0.19305605 0.36362827 -0.47954044 0.48449978 -0.25954667 0.1517378 0.3811203 -0.41355634 0.25943658 -0.1298382 -0.49756244 -0.27876988 0.33920634 -0.19271208 -0.048085447 -0.19927502 -0.41807857 -0.1648099 0.084230065 0.32842252 0.5155931 -0.25723672 0.30124143 -0.033321477 0.10273411 0.1631439 -0.04089665 0.29226217 0.25689712 -0.19230196 -0.16923906 0.14325413 0.3394634 0.38579288 0.3566821 0.18616757 0.11452218 -0.5141513 -0.42464238 0.20624942 -0.088789314 0.47070518 -0.05109428 -0.19880755 0.021026203 0.48622614 0.48557335 0.32368964 0.27052334 0.074760616 -0.27929196 -0.0073408964 0.42414242 0.22291224 0.01943869 -0.4703814 0.387208 -0.3118537 0.22978504 0.1605522 0.42480344 0.1640298 -0.38952643 0.123653464 0.02182105 -0.05337052 0.286502 -0.33243284 -0.15874055 -0.3877587 0.27678388 0.22852956 0.18599111 -0.13299993 0.39508268 0.23586127 0.017468246; 0.33205998 0.17910592 -0.25329092 -0.06417481 0.08645521 0.23181252 -0.1795165 0.34549013 -0.24360295 0.22553802 0.069352366 -0.2711153 -0.12291239 0.13712284 0.0058427323 -0.29699653 0.19547704 -0.21760277 0.24232215 0.18616182 -0.1129093 0.34541175 -0.3731354 -0.24293049 -0.13275783 0.058934145 0.3697058 -0.46444142 0.026512265 0.2657898 -0.14668828 -0.3054272 0.07929991 -0.057015583 -0.20919797 -0.04256666 -0.0621862 -0.1579014 -0.41759714 -0.59419984 -0.585869 -0.035894178 0.35135406 0.20937918 -0.13742094 -0.17633462 0.25633547 -0.36896297 -0.31856135 -0.32007894 -0.15031753 -0.32873672 -0.35154724 0.3614107 0.34624514 0.5148736 0.10568815 -0.46334547 0.068156846 -0.052233454 0.3057309 -0.38110065 -0.33638996 -0.293211 0.14626507 0.1979483 -0.28704327 -0.1289811 -0.151811 -0.53983414 -0.1570092 -0.36713567 0.18312879 -0.18252556 -0.16108288 0.10585544 -0.15200183 0.43230298 -0.33538505 -0.6015617; 0.33395308 0.25109977 0.09398816 -0.34392738 -0.45225275 0.39346248 -0.19709815 0.24928497 -0.19297938 -0.2515684 0.31625047 -0.3776093 0.23447326 0.35098955 0.19688863 -0.4144774 0.118075304 0.072864994 0.3424532 0.16713142 0.3027645 0.17075065 -0.2543112 -0.29662076 0.25928476 -0.20891504 0.25225008 -0.032767195 -0.32205066 0.17957461 -0.18248668 -0.20259759 0.24280666 0.24256088 -0.14285074 -0.25478706 -0.23182623 -0.48085654 -0.13773419 -0.30254662 -0.09990696 0.25627148 0.26811224 -0.19230299 -0.15858105 -0.15410751 0.36672604 -0.06889697 -0.3904312 -0.26983497 -0.11477974 -0.17440307 -0.16933864 0.106269315 0.073516086 -0.17329666 -0.037790418 -0.23940185 0.2588377 -0.059013434 0.2181585 -0.32013127 -0.3729848 -0.38116854 0.062383607 0.29159567 -0.19727375 -0.063015185 -0.08508154 -0.30433542 0.39225712 -0.072155945 0.3094533 -0.07152619 -0.25831196 -0.09240281 0.32366487 -0.073163465 -0.45982584 0.100855395; 0.1917748 -0.073322 0.09746995 -0.2526893 -0.27874076 0.1931476 -0.29947242 0.2004116 -0.24190602 -0.33778358 0.3247354 -0.32165623 -0.04856898 0.20549738 0.41150248 -0.14096497 -0.29663697 0.2721138 -0.014872564 0.16477893 0.22014792 0.26499754 -0.5285384 -0.31283155 -0.15910089 -0.09389358 0.28913188 -0.17703545 -0.26065233 0.19303565 -0.14238031 -0.35210758 -0.21345821 0.40411782 -0.18052079 -0.3557545 -0.23293945 -0.24452116 -0.44097868 -0.22779612 0.37385824 0.2956868 -0.047527388 0.34159464 -0.24209453 -0.19328484 0.2534371 -0.11737646 -0.39320984 -0.1624111 -0.180871 -0.2921901 0.0743458 0.16622627 0.30980405 -0.38537496 0.03826643 -0.21124004 0.42353764 -0.3297184 0.4107825 0.08702238 -0.1750022 -0.46023533 0.251007 0.22043358 -0.19182834 -0.3678645 -0.3516279 -0.042309783 0.21967922 0.31610245 0.25064301 -0.3807734 -0.2356431 0.026732747 0.4335014 -0.15226014 -0.42841554 -0.013560704; 0.064644136 0.24350394 -0.41143712 -0.19920498 -0.35091347 0.04031375 -0.3045237 0.3924652 -0.23544195 0.14303057 0.28632957 -0.5179042 0.31051314 0.1933359 0.32759055 -0.18020387 0.2945575 -0.4051361 0.38700947 0.31597823 0.21912496 0.112829454 -0.1196768 -0.10391756 0.11677637 0.15696956 0.4571104 -0.064223796 -0.069556236 0.28563502 -0.35782328 -0.2339071 0.26555774 -0.12319299 -0.11626813 -0.05409763 -0.34568575 -0.36224744 -0.03013293 -0.5143999 -0.3415245 0.29379278 0.28974053 0.12829946 -0.1692269 -0.15772584 0.27509004 -0.3445338 -0.28596762 -0.039051518 -0.10669938 -0.114993066 -0.23995686 0.2496608 0.14186418 0.028695486 -0.17571932 -0.2236289 0.15849857 -0.118638314 0.3622159 -0.30445984 -0.4754305 -0.28636634 -0.21888036 0.11407755 -0.319212 -0.06831305 -0.20109457 -0.2516333 -0.1406966 -0.03626203 0.031148154 -0.2762538 -0.21588522 -0.26834518 0.06505452 0.2568867 -0.045436133 -0.56561136; 0.038227644 0.1860649 -0.30271423 0.019630065 0.030386066 0.039915238 -0.056645293 0.4014366 -0.3064477 0.33704683 0.03571051 -0.39529026 0.3027497 0.1369219 0.3265462 -0.18818213 0.1996538 -0.49052894 0.35305893 0.07723349 0.028940687 0.19650316 -0.14205888 -0.35636812 0.06472874 0.5568443 0.39299786 -0.16152826 0.049481213 0.19922715 -0.3288924 -0.050596837 0.71720046 -0.19923794 -0.11665264 -0.32867533 -0.17096408 -0.029420314 -0.19896102 -0.55941945 -0.57567054 0.05152552 0.27466562 0.06778279 -0.2805656 -0.123538055 0.36407232 -0.17332686 -0.09708096 -0.13995743 -0.19613102 -0.067564316 -0.4047365 0.33082068 0.26722097 0.3409811 -0.04370115 -0.38210142 0.36175722 0.035981737 0.16571672 -0.33736002 -0.27735305 -0.32166103 0.2104308 0.3347299 -0.23974769 -0.22821687 -0.07737059 -0.43946543 -0.28092486 -0.5133476 0.13586302 -0.29382476 -0.24993692 -0.11220745 -0.04859674 0.2856648 -0.32391465 -0.5691293; -0.102315046 -0.2913681 0.39601701 0.45929566 0.13501295 -0.2219112 0.29860914 -0.10641011 0.36234096 0.26339507 -0.117170304 0.45898545 0.10911903 -0.22610417 -0.37377623 0.063518785 -0.19623174 0.23652248 -0.17694099 -0.24867855 0.03104844 -0.54708445 0.08856014 0.2965862 0.36833787 0.16024366 -0.26925525 0.1178543 0.25699133 -0.30304325 0.15437645 0.3434758 -0.09119303 0.045289677 0.4267561 0.26308295 0.0598572 0.13149506 0.3182394 0.48819983 0.13748714 -0.24277891 -0.13603084 -0.1382393 0.0977431 0.086850375 -0.0523355 0.3398826 0.31134352 0.23079859 0.354269 0.13029203 0.18583535 -0.091246255 -0.4000406 -0.2207571 -0.033335302 0.104992226 -0.049000207 0.42169333 -0.38779277 0.39980304 0.3801446 0.07277998 -0.2311616 -0.15924478 0.11001914 0.10988767 0.40843314 0.36978194 0.0031047193 0.08094009 -0.41145086 0.4331719 0.3342748 0.22893862 -0.17234667 0.18046537 0.14550346 0.19598041; 0.2040111 0.1316453 -0.41130248 0.08684194 -0.0056724763 0.31424648 -0.15241635 0.1879925 -0.10480998 0.016826082 0.29731336 -0.21233739 0.34814516 0.23311754 0.32510018 -0.15204653 0.19507982 -0.4579407 0.502918 0.0017292718 0.15511093 0.035616644 -0.15747999 -0.30332974 -0.17399473 0.008597471 0.3860637 -0.16105942 -0.16522323 0.491189 -0.24881953 -0.10446472 0.10430585 0.20861544 -0.2858244 -0.27571237 -0.23409626 -0.26141202 -0.34151247 -0.37560675 -0.035201795 0.2097161 0.20997371 -0.20249389 -0.24734461 -0.24512097 0.3207157 -0.21336167 -0.35629123 -0.3843456 0.032427505 -0.29504928 -0.32454777 0.32221013 0.09316669 -0.26893517 -0.28001475 -0.24393122 0.12140418 -0.18760741 0.16376108 -0.34321606 -0.33728653 -0.16733429 -0.17308849 0.29779652 -0.40641502 -0.21773012 -0.17799868 -0.31018373 0.09671368 0.048577737 0.012726955 -0.17881471 -0.08947084 -0.17805018 0.3614893 -0.18536018 -0.05782422 -0.21831192; -0.08517567 -0.056217253 0.33420905 -0.31172875 -0.2700128 0.36061135 -0.030984204 -0.22583668 -0.19040732 -0.34509096 0.24560942 0.22777152 0.21970546 0.19482464 0.22394565 0.101600975 -0.23442896 0.3035478 0.038989477 0.17563012 0.4380953 -0.18722998 -0.096354835 -0.28382757 0.1655164 -0.41167164 0.009999898 0.15500215 -0.44920406 -0.05650704 0.102197625 -0.22912905 -0.099538855 0.21181826 -0.18915693 0.03024018 -0.14224367 -0.123052895 -0.10945457 0.4262218 0.30586722 0.1744692 -0.55256695 0.07429661 -0.018198187 0.21528426 0.14079547 0.2341264 0.13358423 0.29496893 0.21565378 0.08053719 0.030317323 -0.06069026 -0.048896417 -0.270027 -0.1402092 0.17795058 0.2165296 0.006547641 0.13332595 0.22613777 0.27001983 -0.18218286 -0.22738014 -0.0131639885 -0.27862614 -0.18957905 0.1607326 0.4355564 0.62200403 0.1741396 -0.2099831 -0.023561798 -0.048047926 0.1230809 0.43632886 -0.529186 -0.07398201 0.4889884; -0.027486168 -0.44396687 -0.0713526 -0.029222528 0.16814719 -0.36756194 0.04513574 -0.16935135 0.08515851 0.24164277 -0.43253958 0.07509826 -0.062442694 -0.09804911 -0.24745555 0.24398677 -0.0996569 0.14516126 -0.44000298 -0.30687273 -0.30272663 0.076569125 0.2760401 0.05897647 -0.1891647 0.19043994 -0.29812047 0.19903128 0.18102942 -0.31660655 0.38404605 0.3754227 -0.2359369 -0.33508596 0.21275721 0.13455069 0.41365033 0.16549446 0.05454937 -0.07931101 -0.4207443 -0.11433063 -0.060757197 0.13982281 0.3447988 0.20731096 -0.31207934 -0.09715146 0.014750716 0.08512406 0.28749567 0.22222005 0.27007577 -0.20048526 -0.11559804 0.2632316 0.44572172 0.007957827 -0.04879511 0.13264707 -0.14590698 0.153864 0.3070251 0.06627798 0.13962285 -0.08243375 0.1388115 0.34644648 0.20822322 0.26328582 -0.4869601 -0.11057869 -0.18564552 -0.08364376 0.16953732 0.19738612 -0.34701607 0.3846359 0.20853859 -0.14990573; -0.06484952 -0.33088708 0.4479943 -0.20520762 -0.08495926 -0.35918054 0.05398614 -0.25885606 0.08706086 -0.0074133766 -0.20969987 0.40346828 -0.44839948 0.011625611 -0.35144812 0.24471182 -0.13210927 0.4738616 -0.1744248 -0.22902584 -0.3027066 -0.06197477 0.061619382 0.38426277 -0.047960807 -0.09952593 -0.41331023 0.2462796 0.26174462 -0.25787696 0.24146625 0.14608037 -0.18256076 -0.2810649 0.11600836 0.07041239 0.06117761 0.25846785 0.02315076 0.18697412 0.3157349 -0.18778823 -0.18772097 0.18416058 -0.026014704 0.35412532 -0.24004091 -0.105107054 0.3691507 0.09326446 0.20085207 0.20469001 0.097375326 -0.3271618 -0.085033886 -0.024097575 0.25470307 0.1470693 -0.08037052 0.13057493 -0.29665893 0.25447893 0.17222013 0.36718786 0.17125459 -0.20967655 0.10430062 0.17645428 0.26075003 0.2496026 0.010459411 0.04626346 -0.0871446 0.16203524 0.013958866 0.30959433 -0.04040593 -0.13349351 0.05882299 0.18818542; -0.37601578 -0.10779144 0.15504536 -0.21477194 -0.09142852 -0.28754124 0.09259803 -0.09157685 0.17058676 0.021720862 -0.12981902 0.39475372 0.26628363 -0.3346141 -0.30891943 0.36984783 -0.1415435 0.23579162 -0.2055598 -0.28296515 -0.2394666 -0.3270836 0.0704648 0.29939 0.067205295 -0.103316545 -0.14343397 0.113384545 -0.19320363 -0.32663935 0.062480826 0.25034356 -0.11611782 -0.11157368 0.08074863 0.3462605 0.24373086 0.33055606 -0.03483426 0.2769078 0.13540027 -0.16312325 -0.3192674 -0.06884112 0.13569349 0.3481652 -0.03405793 0.26316202 0.15444496 0.055257294 0.13714063 0.087622985 0.102358684 -0.26129693 -0.10898104 -0.005437318 0.009190618 0.3855052 -0.064084716 0.21613143 -0.2408289 0.25758606 0.46799308 0.06648992 0.0049655307 -0.17405054 -0.01556752 0.13281259 0.17519122 0.3537232 0.14606917 -0.003813575 -0.1251092 0.38677427 0.28470778 0.0905752 -0.22123063 -0.21596053 0.29524744 0.3853317; -0.17256156 -0.10848327 0.3629958 0.23299438 0.22145104 -0.3228201 0.16755792 -0.24645899 0.123222835 0.09991013 -0.29402772 0.2700291 -0.44866282 -0.49170387 -0.41772816 0.39760444 -0.2216253 0.0022352424 -0.2513439 -0.16584976 -0.31826013 -0.15139154 0.30812228 0.2826872 -0.15085696 0.07042925 -0.12237276 0.39680463 0.143876 -0.3880793 0.10743324 0.2077245 -0.3604007 -0.32476574 0.06169858 0.3401215 0.3453236 0.55596775 0.47788683 0.18351343 0.09226063 -0.27872902 -0.1935303 -0.00046830368 0.16627976 0.2694462 -0.24084494 -0.006813214 0.50821334 0.39858103 0.23012117 0.12079462 -0.072171144 -0.46922854 -0.17514731 0.12376535 0.17052329 0.062701225 -0.30581316 0.35705078 -0.31189954 0.038582847 0.1259045 0.1733092 0.068572894 -0.37652412 0.16538641 0.21653049 0.265247 0.20399696 -0.18522777 -0.07108932 -0.13124527 0.22527085 0.39652717 0.24797294 -0.3649899 0.083252355 0.18020281 0.27217224; -0.019670649 -0.0827805 0.66472274 -0.20636016 -0.45162708 0.32917023 0.2185552 -0.378457 -0.14604071 -0.4666771 0.42906174 0.67383283 0.048584126 0.097619824 0.36489293 -0.18413754 -0.11592707 0.53198814 -0.036621414 0.05073727 0.22718768 -0.18535972 0.0018287419 0.03484895 -0.29269385 -0.45796588 -0.006422993 0.09769769 -0.36586326 -0.05766181 0.08970142 0.082587466 -0.16641483 0.36693785 -0.09745943 -0.02736977 -0.29116064 0.13151848 -0.12265122 0.51811683 0.32255834 0.4044549 -0.6464361 -0.05753916 -0.12126135 0.019630805 -0.20020004 0.058299337 0.18596138 0.2932328 0.19861329 -0.052950874 0.13504189 -0.103206 -0.3966573 -0.6523841 -0.09731893 0.19195932 0.12203592 -0.016831446 0.20722185 0.44506952 0.5026423 -0.051689457 -0.15571006 0.019040061 -0.4870512 -0.30296636 0.30652103 0.40272152 0.3858008 0.6190073 -0.41440612 0.22457683 -0.090456486 0.09418299 0.49883142 -0.33669052 -0.0057825707 0.46353978; 0.10430346 -0.023747243 0.0711518 -0.057726853 -0.11472163 0.42890245 -0.20397426 0.05401783 -0.4077261 -0.059917126 0.24065575 -0.2922637 0.44498575 0.35511506 0.3591232 -0.4183981 0.18694787 -0.30191278 0.2640912 0.37709317 0.399883 0.19633654 -0.16872121 -0.21639058 0.03562717 0.05901827 0.24257408 -0.24582459 -0.29552656 0.05886388 -0.27658245 -0.25946918 0.3615335 0.15728498 -0.04601043 -0.45921946 -0.14150757 -0.25537992 -0.2071901 -0.20867819 -0.040537354 0.16573645 0.38833585 0.037167914 -0.18876986 -0.3525295 0.30985644 -0.24768245 -0.2033147 -0.1601182 -0.236531 -0.33715323 -0.12508388 0.12500235 0.19170365 -0.089181185 -0.13015796 -0.03955944 0.19943954 -0.32379934 0.4804862 -0.3369376 -0.2807009 -0.11918387 -0.1562615 0.33722898 -0.30161056 -0.08700118 -0.21128313 -0.5213202 0.3115517 -0.10430722 0.19074388 -0.07752416 -0.3572885 -0.15625663 0.46026838 -0.2307318 -0.19815382 -0.1551674; 0.28970787 0.09262143 -0.5063835 0.1992372 0.24527083 -0.106231295 0.116932705 0.24077581 0.32203957 0.23704559 -0.33846834 -0.3560097 0.103570975 -0.22748478 -0.13730761 0.2722921 0.23831832 -0.16370481 0.28571084 -0.05744105 -0.4787541 0.20175533 -0.057808563 0.30218267 0.2353314 0.29214314 0.19112849 -0.082825385 0.41094175 0.030065726 -0.09260967 0.24733067 0.28342685 -0.52738297 0.09859866 0.24322991 0.41469973 0.19251157 0.15141368 -0.6915861 -0.31086352 -0.13073091 0.6726244 -0.20304264 0.13848618 -0.0988691 -0.035587367 -0.21874869 0.10200347 0.049950164 -0.09612421 0.04852491 -0.033166658 -0.05674166 0.42443514 0.54072547 0.12186438 -0.38372844 0.10363917 0.159665 -0.32628527 -0.18503362 -0.5656143 0.2059022 -0.050585862 -0.105945 0.491578 0.20699334 -0.11630389 -0.58912826 -0.47513437 -0.48645514 0.06744827 -0.16847563 0.2037233 -0.06610765 -0.25091437 0.31014192 0.3778298 -0.553376; 0.23479961 0.3828821 -0.49302593 0.031699803 0.33958346 0.04217314 -0.16350655 0.00922132 -0.011072039 0.30534744 0.17532575 -0.35380185 -0.093146555 -0.059956145 -0.018594813 -0.07051697 0.3061705 -0.24702573 0.08694715 0.18392155 -0.2208874 0.31868836 -0.043108784 -0.12674595 -0.0944288 0.23605305 0.38479424 -0.19318901 0.3740868 0.09930628 -0.10198443 -0.24712154 0.10212932 -0.046634953 0.25070164 -0.32709166 -0.089964375 -0.26421174 -0.16883814 -0.4377689 -0.30187556 -0.24442784 0.4099005 0.09546059 0.10790139 -0.07297049 0.309395 -0.1477316 -0.20118096 -0.09417716 -0.17452762 -0.17765969 -0.3384562 0.21393093 0.07711407 0.33683223 -0.11495279 -0.20232792 0.06874573 0.0509959 0.08639997 -0.19112079 -0.46766827 -0.008737955 0.21851924 0.06404399 0.14486901 -0.022645175 -0.1303722 -0.2635654 -0.17726189 -0.060480304 0.027573217 -0.30586603 -0.28596216 -0.010061447 -0.052507825 0.33132756 -0.21994841 -0.3131823; -0.086962536 -0.06022029 0.32662597 -0.10573737 -0.33584598 0.030355304 0.07512326 -0.39290807 -0.1156137 -0.2899817 0.11167994 0.37094006 -0.22245349 0.1594556 -0.1294863 0.27356148 -0.2930645 0.30100283 -0.21763712 0.09328788 0.35669962 -0.3564462 0.009043368 0.042182766 -0.09958013 -0.29548636 -0.12214991 0.13131358 -0.43914387 -0.337041 0.23878595 -0.052393295 -0.20549156 0.33983412 -0.06858535 0.09006122 0.10457461 0.3107096 0.14279015 0.51421565 0.25614533 0.04699836 -0.6952457 0.085423544 -0.07848331 -0.0006262895 -0.19389 0.22177683 0.24109975 0.24017118 -0.012710783 0.13446586 0.4898956 0.112939596 -0.42062598 -0.50021744 -0.08654098 0.18486588 -0.27285075 0.10649748 -0.09409148 0.36195982 0.37063354 0.088938706 -0.09720589 0.02341389 -0.0068097315 0.04456443 0.28045762 0.6084857 0.22505474 0.5534716 -0.2536488 -0.011874348 0.09107258 -0.0048407023 0.28744465 -0.46559647 -0.014898978 0.65781724; -0.12997505 -0.03186669 0.23234513 -0.16104901 -0.3724792 0.19964603 0.09655909 -0.009921309 0.054561514 -0.37511417 0.20493534 0.25975832 0.01533955 -0.072345905 0.22745782 0.1395625 0.026472997 0.2760293 -0.27768221 -0.08152548 0.39202848 -0.13564476 -0.0558366 -0.1993218 -0.19967318 -0.123549014 -0.018862076 0.056590654 -0.48110002 -0.29654896 0.12174635 -0.08801731 -0.20990708 0.5972393 -0.11560058 -0.16487731 -0.3041383 -0.12596339 -0.21973522 0.6969508 0.5919141 0.20264198 -0.6064351 0.15302718 -0.1673057 -0.04820244 -0.08195757 0.17375201 0.043291587 0.012152578 0.31711167 -0.035723776 0.24266279 -0.07554766 -0.42668524 -0.39641717 0.097007066 0.3737017 0.15304661 -0.028625937 0.03735042 0.17716174 0.48033136 -0.07644598 -0.12202222 0.07857878 -0.43197325 -0.26545778 0.11614819 0.56861115 0.24725515 0.3244252 -0.35979295 0.042768523 -0.043557517 -0.13357043 0.1822211 -0.179159 -0.005517201 0.56163925; 0.26580447 0.38028756 -0.5252805 0.15475556 -0.12246057 0.08146796 -0.28307405 0.04037809 -0.08571757 0.10471179 -0.034116603 -0.2824237 0.22538695 0.2488985 -0.015465798 -0.18632047 0.4896346 -0.36396623 0.35236475 0.32799903 -0.005243004 0.41897303 -0.010007692 -0.04516184 0.24498236 0.4030049 0.11618787 -0.41359994 0.21292895 0.3526622 -0.25562036 -0.3085556 0.62312555 0.0077850865 -0.12598467 -0.2819932 -0.26955882 -0.021211185 -0.0017818478 -0.32582965 -0.28253064 0.12346648 0.37557542 0.07615252 -0.038610898 -0.4036777 -0.002925562 -0.19848226 -0.2391153 -0.21624102 -0.40628064 -0.3013044 -0.22199295 0.106521815 0.23529859 0.5676187 -0.39133167 -0.42875165 0.17158234 -0.2788119 0.33998984 -0.50183403 -0.5525351 -0.15202098 0.1586368 0.031262826 -0.27326745 -0.15621799 -0.13031514 -0.34832713 -0.3998729 -0.6253629 0.32106853 -0.13267788 -0.1325562 -0.27231237 0.114439785 0.301677 -0.21569443 -0.5393959; -0.027265655 -0.16574551 0.007939538 -0.0041096793 0.32956707 -0.41145322 0.32876998 -0.18860973 0.44535393 0.05487842 -0.4696817 0.4375866 -0.082002334 -0.46596974 -0.18065977 0.3559873 0.03616733 0.02841204 -0.1480158 -0.2973594 -0.25254828 -0.24078728 0.52374655 0.25476965 -0.2123337 0.039927963 -0.16529872 0.339804 0.22908527 -0.15222229 0.2009476 0.29747835 -0.25956684 -0.14997238 0.14268011 0.28096342 0.40717903 0.51179606 0.43731773 0.2178561 -0.266814 -0.2758763 0.027512992 0.10187649 0.20471984 0.079718076 -0.18683876 0.10441163 0.43032813 0.39215243 0.20023526 0.110249646 -0.09625482 -0.37104666 -0.18537115 0.21202977 0.22350165 0.083673105 -0.3645817 0.15036029 -0.47684833 0.13142955 0.23784973 0.26099813 0.22371414 -0.48225355 0.1953271 0.15836799 0.1910853 0.30570504 -0.26395288 0.16408642 -0.19278628 0.12705694 0.35377687 0.12898318 -0.17895237 0.3055828 0.36826187 -0.1621335; 0.05327562 0.15999553 -0.053307742 -0.08476758 -0.07293802 0.18587454 -0.18166925 0.14055854 -0.3214814 -0.03426665 0.23346102 -0.08686408 -0.50043356 0.15334228 0.35774958 -0.30189332 0.17787062 -0.08661388 0.26731405 -0.04918991 0.30145407 0.18204124 -0.07542592 -0.3832238 -0.35608432 -0.18496563 0.12826444 -0.10902759 -0.25383753 0.19732115 -0.08046637 -0.087369256 -0.2660559 0.104892075 -0.13066572 -0.38638747 -0.11233421 -0.25009373 -0.1108463 -0.25782713 0.11336355 -0.0136327725 -0.19696102 0.08788086 -0.18284191 -0.24777822 0.05647155 -0.029918458 -0.114858195 -0.2945894 0.00596276 0.13435107 0.039755646 0.28933606 -0.089710765 -0.2759764 -0.050975643 -0.05683382 0.27560762 0.014262807 0.27459514 -0.2093906 -0.012210923 -0.43943152 -0.034786493 0.017114082 -0.082800835 -0.26195252 -0.34210747 0.039860517 0.16164649 0.36622044 0.12410406 0.063479945 -0.15239832 -0.28335136 0.010920674 -0.199173 -0.41944253 0.16692173; 0.1999799 0.16079703 -0.5574559 0.21490324 0.41086242 -0.18211147 -0.19519144 0.023364192 0.1414686 0.4713452 -0.09597102 -0.5186105 -0.21115835 0.1085276 -0.2997553 0.082393624 -0.00051855715 -0.4526735 0.25293702 0.13998304 -0.22955467 0.15251975 0.08929003 -0.05657908 0.017232586 0.29486415 0.0054163914 -0.40721354 0.3019517 -0.061688505 -0.0333351 0.057985667 0.20995352 -0.44541594 0.21439594 -0.09025734 0.22283937 -0.019605894 0.15727457 -0.69221103 -0.41261488 -0.21805407 0.5340181 -0.009068691 0.08543454 -0.08625813 0.2212868 -0.17766763 -0.23859817 -0.16756955 -0.33183873 -0.0013193225 -0.18105169 0.080386356 0.20553195 0.39371568 -0.084287606 -0.059281986 -0.12618916 0.17757985 -0.33118895 -0.14450055 -0.53183776 0.21584404 0.022827085 -0.18239537 0.46913454 0.3584286 -0.21530607 -0.5315567 -0.5976721 -0.6617233 0.32652235 -0.066579685 0.2778504 0.073831536 -0.52783906 0.46487743 0.14347847 -0.6096222; -0.15320049 -0.26573083 0.27294147 0.17068243 0.0050364984 -0.3402092 0.32164267 0.016003415 0.14956856 0.26312506 -0.31449354 0.18042797 0.014928966 -0.19303295 -0.11310333 0.22503394 -0.32576236 0.33343276 -0.21168289 -0.27831432 -0.43900156 -0.02617104 -0.043027394 0.08510598 0.027090034 0.20101243 -0.49310836 0.008366281 0.34851038 -0.15074916 0.117849894 0.15995955 -0.007908897 -0.45105624 0.04665229 0.20302647 0.43201384 0.08791184 0.26675063 0.123569086 -0.2457516 -0.011926768 -0.1277855 0.33835995 0.04285474 0.12270438 -0.41773823 0.0121247275 0.17263441 0.05830996 -0.028357089 0.013312473 0.045341738 -0.15566677 0.032405026 0.15618429 0.22286329 -0.020184264 -0.41410255 -0.09194415 -0.1212944 0.14174649 0.153778 0.2669899 0.35332388 -0.3454246 0.08259526 0.4577835 0.04117135 0.063578404 -0.2878914 -0.3188637 -0.18678275 0.19855127 0.39841413 0.11099403 -0.25846958 0.20020829 0.24335808 -0.0039445776; -0.27010876 -0.15453354 0.30226007 -0.23050721 -0.24961469 0.008424272 0.29078722 -0.3324914 0.1950392 -0.33796316 -0.010732434 0.27860814 -0.076496795 -0.026440639 -0.16036133 0.2568896 -0.18564855 0.48137364 -0.1424137 -0.11845673 -0.025995908 -0.32762212 0.30130845 0.23241615 -0.21827865 -0.5141588 -0.06896861 0.3333513 -0.24229479 -0.45187432 0.24311322 0.034449827 -0.43567812 0.14290604 -0.1654423 0.017398488 -0.008713505 0.04559129 0.23070502 0.53493005 0.4853295 -0.10528295 -0.51569986 0.05413399 0.19230281 0.102750555 -0.21360725 0.11468961 0.090563625 0.2704368 0.27912077 0.24178417 0.4051717 -0.03357547 -0.53216326 -0.5526227 -0.07117526 0.12699008 -0.33252147 0.2974173 -0.2960779 0.30316445 0.46579352 -0.025109857 -0.11220631 -0.20303659 0.20912272 0.06443732 0.25407463 0.6128381 0.4055435 0.5650019 -0.13710555 0.12518694 0.24199672 -0.09215156 0.3211308 -0.3959137 0.18278845 0.76420057; -0.048982225 -0.106537804 0.57132894 -0.12683666 -0.3094969 -0.011160805 -0.0211524 -0.0935355 -0.20467253 -0.3680689 0.32989314 0.48588106 -0.080885224 0.08628883 0.3272931 -0.056501668 -0.211878 0.288767 -0.17523754 0.12962782 0.39799228 -0.33539882 0.0134949405 0.034363348 -0.12976775 -0.23787208 -0.006046242 0.26876217 -0.25823578 -0.10894168 0.15569739 0.005420773 -0.25580588 0.49131575 -0.37837538 -0.10611269 -0.31105083 0.14316526 -0.020357182 0.35534862 0.32413042 0.1698784 -0.58809656 -0.15393521 -0.3502128 -0.037790045 -0.12774576 -0.11743795 -0.05450762 0.082107484 0.16866463 -0.14356306 0.2901578 0.0006386193 -0.13274632 -0.43065712 -0.04950421 0.20184687 -0.123527706 -0.16709226 0.068847105 0.38792273 0.5910129 -0.21191902 -0.018382775 -0.045673948 -0.23479985 -0.13698247 0.32318577 0.5055586 0.40250012 0.38775557 -0.14216685 0.03015992 0.10407467 0.23549108 0.18911953 -0.40308142 -0.27390403 0.52344173; 0.2487166 -0.05183954 -0.33965883 0.0964815 0.29702756 -0.23389712 -0.2041166 0.3791494 1.7298691f-5 0.51214284 -0.40255335 -0.7400422 -0.1308418 -0.086522706 -0.369455 0.05895553 0.3316317 -0.28832617 0.04977032 -0.073400036 -0.43472397 0.21445413 0.16894208 0.19820395 0.28288695 0.43052956 0.24029331 -0.069038235 0.6313038 0.10069783 0.078030445 0.17246999 0.42970935 -0.4769466 0.19979818 0.09993016 0.1381147 0.108242795 0.07828236 -0.5911088 -0.42776075 -0.1361015 0.50826114 0.09860338 0.11361678 0.083992936 -0.11197952 0.061478045 0.09505722 -0.17422847 -0.089980945 0.08890019 -0.1049841 -0.20638454 0.2182981 0.49115452 0.09526046 -0.12568913 0.07183888 -5.8191363f-6 -0.13074642 -0.471479 -0.66385686 0.012516763 0.062564366 -0.12777704 0.5025376 0.105086714 -0.01698255 -0.77461064 -0.30809924 -0.59184986 0.12616841 0.034520935 0.20652302 -0.19944918 -0.33761585 0.37516642 0.34026477 -0.77387017; -0.22554848 0.01760241 -0.22940136 0.06540381 0.14559582 -0.27292058 0.32829022 0.028425217 0.4463996 0.017870177 -0.4680056 0.22178346 -0.2683201 -0.4456708 -0.30829644 0.23362306 0.07347381 0.09394434 -0.2278959 -0.11507487 -0.15277101 0.07142464 0.3888592 0.46723834 0.010098375 0.17654741 -0.09275258 -0.033818465 0.3760524 -0.3389698 0.23854148 0.25376186 -0.069573805 -0.27774528 0.17028889 0.4683243 0.19267581 0.45599678 0.16403429 0.15927552 -0.25496578 -0.25627017 0.15749156 0.18463297 0.40749055 -0.043169465 -0.1380367 0.08106428 0.45619056 0.30269587 0.14603116 0.21112853 -0.025115956 -0.12975171 -0.04463071 0.19131556 0.28303766 -0.022607327 -0.5087123 0.3658818 -0.25316164 0.09391577 0.32516408 0.3712601 0.14806652 -0.48254007 0.2874142 0.3677522 0.023908874 0.015551002 -0.45961937 -0.22320054 -0.23799947 0.018827273 0.49642727 0.073532924 -0.40172505 0.25671828 0.27244136 -0.15105334; 0.18047716 0.21094371 -0.24785407 0.22832164 0.18135805 -0.031001562 -0.06321337 0.09195409 -0.15831411 0.22956567 -0.12495089 -0.24362199 -0.1974717 -0.19222316 -0.034207486 -0.23229316 0.003823774 -0.22181833 0.29930982 0.06367714 -0.4154039 0.4096931 -0.03257242 -0.104930095 -0.08487031 0.4285822 0.2317023 -0.10563576 0.24408081 0.017657317 -0.3524656 -0.15320466 -0.1334578 -0.17126383 0.31415093 0.024953725 0.09402275 -0.19094905 -0.108072914 -0.24097133 -0.2959234 -0.253589 0.4246616 0.056704614 0.2567889 0.10443359 0.20131357 -0.27739754 -0.0073726573 -0.2462023 -0.16664386 0.0072447723 -0.24342954 0.16857456 0.35301068 0.33524722 0.031039132 -0.19392282 0.24122255 -0.09532591 -0.12865424 -0.119140714 -0.39449286 -0.23415901 0.0999978 -0.13875607 0.16765636 -0.1767297 -0.48736522 -0.55517715 -0.2318725 -0.15201741 0.31391546 -0.28427657 0.17377254 0.0069536343 -0.35396218 0.38932022 -0.021971231 -0.30334496; 0.253547 -0.016935816 -0.46750358 0.2769583 0.3885707 -0.27733165 -0.25885108 0.05451672 0.22272447 0.47065556 -0.0903969 -0.43321598 -0.0003429423 -0.18783402 -0.069075584 0.16569604 0.19376925 -0.4907934 0.27047512 -0.05495486 -0.47893742 0.21707037 0.16043974 -0.11217294 0.08644847 0.37488824 0.13049057 -0.20929955 0.45371065 0.1185466 -0.1268655 -0.0645199 0.0049810642 -0.58892906 0.22997956 -0.15437938 0.15655325 0.08446632 -0.073918305 -0.39824253 -0.3630152 -0.108626395 0.68484104 -0.027313054 0.1316065 -0.07235416 0.15464027 -0.17068516 0.13299492 -0.279436 0.022231348 0.00056222785 -0.106925316 -0.17384683 0.2497433 0.56489193 -0.09322337 -0.09402998 0.13692719 0.01925176 -0.3658677 -0.23133005 -0.5395403 0.12369187 0.270162 -0.2754828 0.20234776 0.121912174 -0.16396469 -0.63440025 -0.34842455 -0.5482174 0.08607612 0.020348405 0.21617675 -0.01983325 -0.32475582 0.5277878 0.15099248 -0.6575636; -0.24504001 -0.2554424 0.4645921 0.02774559 -0.06915726 -0.32337195 0.12571445 0.010281487 0.119147845 -0.09824273 -0.10967493 0.3031636 -0.30902687 -0.18061136 -0.2809491 0.049727894 -0.3008654 0.18025117 -0.15585758 0.024592483 -0.08543849 -0.17266655 -0.008216203 0.091516696 -0.09129431 -0.3928105 -0.25136048 0.12592377 0.08067405 -0.4464099 0.33703148 0.22353762 -0.017793732 0.1137632 0.040600926 0.30103204 0.007717732 0.3267282 0.16407366 0.18192433 0.129307 -0.078037605 -0.36218488 0.19582546 0.25003767 0.37381276 -0.08055554 0.25514096 0.25571844 0.30820578 0.051594835 0.25093532 0.067540854 -0.18839782 -0.21993358 -0.05967609 0.11640821 0.116357416 -0.18694085 0.18598731 -0.26754516 0.21280451 0.18137455 0.18657677 0.020828793 -0.2182736 0.21458292 0.3246957 0.07198168 0.4052616 0.07626435 -0.1285413 -0.20749587 0.15041088 0.30593044 0.16220684 -0.007091003 -0.29260728 0.05759402 0.4542733; 0.10220955 0.022645663 -0.24504526 0.35517436 0.19683133 -0.24630883 0.10871317 0.036605846 0.2529172 0.15864165 -0.38027665 -0.57022333 -0.15282615 -0.03746684 -0.22282644 -0.09303193 0.32205948 -0.29590377 0.21504024 0.10808475 -0.2703255 0.31760588 0.0461504 -0.16371962 -0.025280535 0.2884678 0.3043191 -0.39815778 0.4390976 0.21136437 -0.04439182 -0.032069866 -0.0033778157 -0.32587853 0.35125715 -0.19005388 0.30160415 -0.02122884 -0.15753254 -0.43620834 -0.60607743 -0.2134651 0.42500654 0.10704484 -0.030102575 0.053434443 0.09788064 -0.23081107 -0.031775482 0.008787415 -0.26819804 -0.120422386 -0.04263437 0.10624661 0.120373644 0.38904437 -0.09181562 -0.4438848 -0.082431935 -0.06288454 -0.023866193 -0.46586984 -0.6077997 -0.062261462 0.14116186 -0.19255279 0.3110312 0.14249527 -0.16151255 -0.64513487 -0.23905408 -0.49719828 0.2574083 0.018831987 0.18188214 0.10763948 -0.5645718 0.19878797 0.13897541 -0.6862671; -0.03270433 -0.24459383 0.6730174 -0.3179974 -0.29214057 -0.054513767 0.28328463 -0.25011727 0.018064162 -0.39432722 -0.11303081 0.41921037 -0.22793655 -0.1345337 -0.061123833 0.056998897 -0.41236478 0.4141786 -0.109739855 -0.28798178 0.2817583 -0.46375358 0.17031823 0.039528877 -0.24405706 -0.33731344 -0.16086055 0.1913212 -0.18180452 -0.4191987 0.3278233 -0.0018637158 -0.53612345 0.23910001 -0.04223061 0.2362989 -0.06108834 0.10268828 0.17085095 0.51000977 0.47966126 0.20197478 -0.7064127 -0.058295812 -0.11910998 0.38372174 -0.19692782 0.27051032 0.2075793 0.22686905 0.39461598 0.2910989 0.2548297 -0.19604358 -0.35155028 -0.73082364 0.28285915 0.34463182 -0.17030366 -0.102128826 -0.078801095 0.39011395 0.53979176 -0.047058754 -0.23315364 -0.03450036 0.14441378 0.10303723 0.14480053 0.36082467 0.32460022 0.71583444 -0.37150586 0.13494141 0.2015746 0.19386578 0.09591344 -0.36646706 -0.079545274 0.5255538; 0.36452645 0.25930935 -0.24320729 0.1913122 0.31399494 0.06866041 -0.23280415 0.07722186 0.028597634 0.24321356 -0.07924881 -0.2378013 0.4220113 0.100684844 0.06850913 -0.23786204 0.19450542 -0.28543773 0.40669248 -0.038223837 -0.055307604 -0.018061165 -0.04954412 0.0137399975 0.11841241 0.15075232 0.25971544 0.035023827 0.12648126 0.32095242 -0.13009869 -0.3685991 0.41575125 -0.075377345 0.2579149 -0.04200517 -0.022594161 -0.14967693 -0.088769965 -0.42035618 -0.31307817 -0.06823303 0.47699812 -0.13918422 -0.11966899 -0.17672342 0.17349838 -0.1876044 -0.12466775 -0.022075312 -0.07250555 -0.033797033 -0.3396319 0.112294674 0.23816127 0.118476324 -0.2620155 -0.03916057 0.28674248 0.096645 0.0981506 -0.35584882 -0.53073144 0.04602543 -0.13578324 0.19248633 -0.067570835 0.023408396 -0.09721149 -0.60657996 -0.076764286 -0.4455103 0.2012948 0.09880645 -0.32870874 -0.12726015 -0.080058254 0.20594464 -0.17665261 -0.3233824; 0.07732836 0.31955564 0.19875872 -0.15274607 -0.38713896 0.31500548 -0.16205986 0.013550236 -0.48297074 -0.13968751 0.24360038 -0.3010822 0.2028969 0.41224566 0.45540676 -0.40206113 0.18023603 0.1925063 0.35826713 0.29225916 0.42750645 0.13354158 -0.30222243 -0.5583786 0.13893321 0.011112342 0.18756597 -0.11640722 -0.1790421 0.18115443 -0.36523214 -0.30846268 0.36395878 0.39964885 -0.08691319 -0.30243492 -0.47339526 -0.36658123 -0.16992544 -0.0726028 0.14318538 0.10699525 0.066721864 0.07746457 -0.37634215 -0.2388581 0.36402726 -0.15272744 -0.4729827 -0.307108 -0.28975368 -0.38967434 -0.0060469927 0.15287909 0.18867719 -0.30031544 -0.1062726 -0.31146446 0.3559737 -0.058663357 0.28586394 0.00041687593 -0.30085418 -0.40182728 -0.1187933 0.5448383 -0.37418604 -0.18504567 0.0051977374 -0.2132142 0.23545407 0.24101539 0.40239084 -0.17973979 -0.5534955 0.11573901 0.3899359 -0.17006624 -0.1450195 0.0023053233; -0.009323745 -0.078944996 0.43919435 -0.27256423 -0.22291759 0.22648227 0.24216634 -0.42483547 0.019809052 -0.28898954 0.038174838 0.5931132 0.1799831 -0.15656151 0.21837813 -0.1274679 -0.3747813 0.18040381 -0.3559221 -0.06562551 0.2720685 -0.3489686 0.065892756 0.15272571 -0.26593634 -0.18280815 -0.124618284 0.14708371 -0.5136597 -0.1291861 0.03421771 0.20554349 -0.29927936 0.51223767 -0.103612885 -0.07661186 -0.23453005 0.23030001 -0.041417643 0.40424272 0.58508104 0.37801558 -0.699513 0.10402186 0.045516152 0.16528657 -0.06748092 0.3045345 -0.08894792 0.30759943 0.21818647 0.20202084 0.39442378 -0.09585482 -0.46326646 -0.31455502 0.11424786 0.22039777 -0.11355344 -0.08791578 0.24950239 0.29606 0.63861424 0.1771398 0.07779185 -0.054588225 -0.36368737 -0.24366757 0.16093262 0.43820804 0.3366097 0.4253269 -0.25063774 0.20431454 0.028512673 0.12781623 0.34989843 -0.28147462 -0.045350626 0.41644394; 0.18141942 0.29364452 0.27683488 -0.31356528 -0.4548749 0.574316 -0.10697498 0.11809597 -0.3169389 -0.4117757 0.40848452 -0.13164268 -0.029507333 0.32519966 0.48707807 -0.32510853 0.05905532 0.16205794 0.0024616465 0.34409553 0.23668972 0.0023585411 -0.4984246 -0.57675695 0.06663815 -0.03358014 0.20241067 -0.19692358 -0.1586938 0.34526446 -0.18231848 -0.5470977 0.18729083 0.22722128 -0.17111188 -0.47442845 -0.443209 -0.4000405 -0.2248753 -0.059024528 0.5892278 0.27911603 -0.19338003 -0.028902957 -0.52045554 0.04700535 0.42783615 -0.057445955 -0.45042259 -0.5122168 -0.07245598 -0.24616139 -0.098589785 0.11151512 0.10810328 -0.39989236 -0.036821436 0.049515817 0.31554 -0.086152665 0.37462196 -0.04805031 -0.13697155 -0.4234923 0.011899293 0.4530498 -0.28907007 -0.19927557 0.06261098 0.09943495 0.69787055 0.38558206 0.046771534 -0.120541036 -0.5563757 -0.21870308 0.5311208 -0.22944662 -0.23116145 0.39374298; -0.15985018 -0.42515057 0.2782059 -0.015303161 0.09712863 -0.29547715 0.24476247 -0.079820536 0.021054382 -0.37802932 0.032239977 0.54131943 -0.436154 0.050914094 -0.059488177 0.24788879 -0.35625833 0.4685323 -0.42834884 -0.20419535 0.11242892 0.0059410613 -0.0100290775 0.054813933 -0.23313044 -0.3080844 -0.20524235 0.05518673 -0.11651265 -0.33445272 0.2665274 0.20076437 -0.4322868 -0.049538538 -0.13572256 0.091605306 0.23951177 0.28041902 0.2468546 0.4261704 0.26102686 0.21087494 -0.40629062 0.15357006 -0.07791956 0.36401996 -0.36433113 0.16820215 0.34242612 0.32777002 0.08585393 -0.005326042 0.14923587 -0.2293552 -0.25743973 -0.32193685 0.10500637 0.13807163 -0.07177476 0.2533552 -0.30903396 0.34730074 0.2258152 -0.0106009655 0.15244183 -0.23749135 0.14825293 0.23255223 0.19883291 0.43284968 0.12840913 0.31538838 -0.09937927 0.029992571 0.21522449 0.15350735 0.111145884 -0.1676778 0.33876345 0.5817012; 0.47062144 0.22436327 -0.04595771 -0.120745435 -0.2294967 0.29306826 -0.23566546 0.015564058 -0.23555742 -0.088021345 0.26690874 -0.05102656 0.1178737 0.1929564 0.19139493 -0.1921637 0.08649501 -0.21046893 0.267835 0.23042071 0.37216803 0.26389912 -0.2745027 -0.11621718 -0.1028107 -0.22040176 0.21370475 0.06782484 -0.36541203 0.2582718 -0.19173862 -0.4220502 -0.090888426 0.19665873 -0.11605336 -0.3579545 -0.11473893 -0.1782636 -0.09476834 0.12982781 0.28736776 0.23273705 0.09139383 -0.10062825 -0.30930257 -0.43527722 0.11922248 0.048612863 -0.22099039 -0.25404125 -0.28365424 -0.2352695 -0.28782493 0.1145508 -0.044760343 -0.21691675 -0.32785326 -0.116995506 0.071599774 -0.18506104 0.15374054 -0.2521891 0.00840587 -0.25147632 -0.07107694 0.14441724 -0.44306022 -0.21549387 -0.17208679 -0.2715575 0.40506992 0.23825124 0.20001468 -0.08591381 -0.15791133 -0.13437441 0.41329226 -0.28966108 -0.14692222 0.0779971; 0.05185274 0.18913807 -0.19169116 -0.07617932 -0.09863135 0.22215052 -0.057695143 -0.0086466195 -0.34888667 -0.10805622 0.1578318 -0.4023261 0.28642967 0.1759105 0.021381436 -0.07745172 0.38936543 -0.46050316 0.1772679 0.23604606 0.14660448 -0.015707102 -0.31238264 -0.37814227 0.009476093 0.16806099 0.21895827 -0.22556044 -0.21202293 0.2579391 -0.3281068 -0.18615524 0.27531442 0.15862727 0.0036932584 -0.21188287 -0.07729288 -0.06961749 -0.0020242245 -0.33035308 -0.23696308 0.22838438 0.04203811 -0.11244479 -0.24616247 -0.17340447 0.31637657 -0.059437826 -0.1513421 -0.024960779 -0.18852384 -0.07704315 -0.42037228 0.31767967 -0.1747838 0.016062599 -0.4558877 -0.17991285 0.24329777 -0.1178081 0.036340863 -0.40075833 -0.31124455 -0.13980265 -0.369988 0.33665884 -0.1927459 -0.20371346 -0.23390017 -0.16519846 -0.05532787 -0.00814958 0.17547545 -0.016943458 -0.11179697 -0.38875914 0.28527373 -0.01509574 -0.3411366 -0.019901255; -0.27740237 -0.113229714 0.31370977 -0.27938366 -0.43452674 0.08319916 0.10752718 -0.2333902 -0.06151526 -0.3661724 0.09135556 0.25655204 0.017245565 0.15249063 0.10491998 0.117229454 -0.11229767 -0.017653594 -0.09331881 0.09740467 0.34107715 -0.14777806 -0.14028701 -0.27386943 -0.021202058 -0.055716977 0.034130253 -0.017549936 -0.42829657 0.037559092 0.48183328 -0.029150551 0.26403362 0.12628567 0.0006820682 -0.21189013 0.08747613 -0.1095922 -0.11761556 0.35842907 0.4637088 0.037553478 -0.28192693 -0.14504236 -0.07428159 0.05647082 -0.12169111 0.09269823 0.23021705 0.20481877 -0.106444046 -0.14576757 -0.010851445 0.03626872 -0.19640122 -0.3987491 -0.15117599 0.29800183 0.0602579 -0.13215053 0.06969092 0.118282504 0.22710699 -0.071867086 -0.05545328 0.16410229 -0.24603942 0.11454253 0.43169618 0.09090079 0.35483465 0.15054855 -0.25397253 -0.0018726854 0.054795366 0.16711079 0.2811929 -0.18250328 -0.23083478 0.18617496; -0.37542748 -0.05381728 0.2410834 -0.27343628 -0.2539466 0.10915176 0.2723991 -0.21165721 -0.11163595 -0.16485095 0.026089754 0.24717422 0.03519342 0.062167503 -0.021292856 0.07909785 -0.24405976 0.34492272 -0.12291687 -0.06728019 0.42848167 -0.056785155 0.20043187 -0.089355364 -0.09550612 -0.23578405 -0.26221642 0.2699585 -0.35017702 -0.2708357 0.16359587 0.15326865 -0.19434284 0.27591258 -0.066063665 -0.103067264 0.05892877 -0.04438516 0.025454277 0.42467576 0.26964837 0.34722883 -0.5891281 -0.039084136 0.06486741 -0.0767492 -0.14429602 0.24173759 0.17951654 0.08559775 0.2842792 0.018514885 0.15744756 0.12965076 -0.23252049 -0.587378 -0.16228336 0.32943404 -0.056054883 0.028976755 0.09321981 0.40043294 0.52575994 -0.13315208 -0.029780572 -0.08644243 -0.3632645 -0.13002095 0.49155268 0.45122984 0.19261773 0.4926651 -0.1736565 -0.060645502 -0.21063794 -0.14314254 0.36781994 -0.13125382 0.0072824303 0.47652853; 0.20618808 0.17894642 -0.5660081 0.13728595 0.17421967 -0.059494257 -0.123645864 0.07629677 -0.07403606 0.39517403 0.12311701 -0.62009823 0.6654902 0.1905627 -0.031620607 -0.17399223 0.1947569 -0.59813124 0.41760647 0.027740961 -0.14677775 0.14426538 -0.30372086 -0.13858849 0.2995799 0.22560276 0.28021932 -0.11823855 0.15803425 0.29399684 -0.032778855 -0.09767091 0.67932206 -0.29185346 -0.01679728 -0.32583615 0.03739994 -0.090095855 0.030723302 -0.35829136 -0.6088599 -0.25997218 0.39348027 0.066847876 -0.031263232 -0.19578451 0.3565166 -0.024561096 -0.14555222 -0.15884909 -0.39421117 -0.3431847 -0.12594499 -0.017163206 0.47747305 0.6619114 -0.0073865363 -0.33473873 0.102433294 0.035709463 0.23188035 -0.56564635 -0.48818582 -0.30929 0.14852743 0.31617516 0.15096837 -0.16159645 -0.029411566 -0.3950188 -0.3040806 -0.49542785 0.19623028 -0.14918953 -0.21220994 -0.060640644 -0.28908968 0.441925 -0.23056842 -0.586744; 0.2618627 0.016897876 0.15539841 -0.2923449 -0.3113253 0.23887017 -0.37401462 0.27589327 -0.33353162 -0.13848902 0.44396082 -0.3477257 0.053930633 0.26367706 0.49402502 -0.52877307 -0.046912618 0.028290099 0.34200197 0.15861316 0.39181954 0.056424342 -0.22572641 -0.27920768 0.14657074 -0.09658677 0.19417925 -0.014324039 -0.3779782 0.13103372 -0.17074743 -0.2884819 0.05658405 0.14584905 -0.25119132 -0.44941446 -0.1807954 -0.4588943 -0.37999588 -0.18620537 0.47992036 0.16203025 0.03081943 -0.15776798 -0.5075008 -0.24845727 0.35942382 -0.25585422 -0.3414307 -0.4741491 -0.13122234 -0.3292457 -0.108117625 0.28388596 0.18736976 -0.24508402 -0.006438666 0.05499457 0.41739228 -0.17365243 0.39185607 0.056983855 -0.08777627 -0.24717607 0.025487974 0.49090606 -0.44681445 -0.37788823 0.060101826 -0.20986675 0.5067221 0.30938628 0.30219856 -0.19198729 -0.5303713 -0.06859549 0.39426076 -0.2228077 -0.22297858 0.19677354; -0.3287411 0.024544481 -0.017327089 0.13286866 0.11123069 -0.17701828 0.3583333 -0.045824323 0.11299725 0.14692897 -0.024556331 0.4931729 -0.21447621 -0.40282765 -0.17494781 0.30742937 0.10307716 -0.12863886 -0.33676142 -0.2926127 0.0032936793 -0.030200338 0.5338827 0.13457727 -0.28617477 0.059530545 -0.1729099 0.051549092 0.11261373 -0.084692195 -0.028700745 0.27362454 -0.18137622 -0.0072214687 0.20707726 0.46669096 0.2976549 0.36643293 0.43535045 0.34909484 0.03660045 -0.19925213 0.062416077 0.06083515 0.37590772 -0.09441328 -0.25033984 0.14667794 0.3514064 0.39831877 0.32784668 0.14838873 0.07024693 -0.251189 -0.17242299 -0.12239664 -0.12621823 0.053187475 -0.22933184 0.35868242 -0.32542154 -0.024115412 0.14435855 0.008691018 0.03320394 -0.17885624 -0.04747428 0.16248241 0.10104859 0.3459742 -0.03920827 0.22526102 -0.2891689 0.36236322 0.23374568 0.0644325 -0.062686 0.05862433 0.110902265 0.27295926; 0.37093693 -0.0435031 -0.65600455 0.23949176 0.45512974 0.12593137 -0.14883241 0.32227486 -0.0037080697 0.50338286 -0.041599 -0.44189438 0.13363633 0.17693213 -0.12158238 -0.22991227 0.1341044 -0.29443642 0.27303034 0.11885677 -0.4447595 0.30164346 -0.15206896 0.073533885 0.32055146 0.52072316 -0.022431677 -0.14001398 0.48125264 0.14445923 -0.18468973 -0.25438577 0.31512496 -0.5222984 0.018401815 -0.047773287 0.22292037 -0.054007478 -0.06304532 -0.6367939 -0.50348395 -0.22274527 0.5754202 -0.005484949 -0.005435197 0.07431263 0.1379912 -0.047750957 -0.11061342 -0.21815772 -0.16869871 -0.15940344 -0.4004284 -0.06067763 0.33269122 0.40521994 0.09929185 -0.43888277 -0.055904027 0.027200043 0.0758957 -0.394329 -0.65227044 -0.13608143 0.029714363 -0.067281984 0.28650284 0.21074647 -0.06377507 -0.32151175 -0.48464137 -0.47685626 0.10199767 -0.12808561 -0.11552018 0.01095785 -0.210382 0.33384788 0.1415446 -0.5533948; -0.3808758 -0.14945078 0.29634032 -0.14668779 -0.077347174 -0.3289648 0.12880617 -0.2115906 0.39678517 0.11219089 -0.2731913 0.22324193 -0.11738452 -0.33907932 -0.29666188 0.058921803 -0.39911094 0.15359734 -0.15985443 -0.04386352 -0.06092429 0.07309977 0.036935963 0.37529173 -0.017798591 -0.17946942 -0.2645923 0.32223114 0.31441137 -0.27890575 0.3564028 0.22863448 -0.14311339 -0.29652286 -0.0064445115 0.019091828 0.046609197 0.34514707 0.32599047 0.11317523 0.15925048 -0.13950704 -0.076704465 -0.02111559 0.08477739 0.3185255 -0.14047965 0.052382637 0.3164569 0.13175395 0.10484185 0.16098754 0.38975877 0.024938997 -0.019345172 0.18111727 0.36320263 0.13490213 -0.23065577 0.22276199 -0.19245593 0.54459476 0.13675149 0.07519309 0.08107804 -0.20023778 0.27602732 0.12323383 0.23543786 0.37632015 0.047920644 -0.032331705 -0.27361465 0.22277477 0.03639113 0.25526482 -0.043518357 0.12344058 0.18988843 0.057761516; -0.35675186 -0.40288857 0.50991553 -0.29149404 -0.043768805 -0.1396138 0.13670106 -0.222063 0.080903076 -0.21969584 -0.1032645 0.5619327 -0.43426645 -0.1586099 -0.17622967 0.14865498 -0.24973582 0.3959897 -0.3612352 -0.24960084 -0.10602339 -0.08536012 0.19825326 0.1626437 -0.103784874 -0.21415582 -0.34797195 0.16000985 -0.14036864 -0.36928952 0.21343213 0.21819887 -0.40672976 0.06866338 -0.22457363 0.11278632 0.0763784 0.027905183 0.27916345 0.54776627 0.38082075 -0.04446969 -0.25122264 0.3609825 0.22556025 0.25724342 -0.0698743 0.24312896 0.21679111 0.1025465 0.13981803 0.1346864 0.33624133 -0.15644939 -0.10524656 -0.04709204 0.22659267 0.27259687 -0.077836774 0.111653954 -0.16213787 0.53637743 0.3122278 0.33933455 0.049411457 -0.19636561 0.21654007 0.014503936 0.25980684 0.37938833 0.35859475 0.22361597 -0.27713576 0.3228561 0.118638374 0.18689302 -0.094986066 -0.37101805 0.16525586 0.48867297; -0.29222277 -0.16355675 0.21533282 0.03693816 0.20206453 -0.16620487 0.5148009 0.01505864 0.10103102 0.1995075 -0.09189477 0.442776 -0.5310986 -0.28571644 -0.10790154 0.3289963 -0.064805776 0.1994222 -0.37900648 -0.20579849 -0.10072264 0.0057544224 0.51943165 0.1701676 -0.32570902 -0.12832937 -0.24018799 0.1294865 0.13435899 -0.15327202 0.08250524 0.51565397 -0.1625168 -0.37830544 0.092794046 0.26150823 0.26091024 0.29998136 0.1836375 0.2373563 0.20375821 -0.3256779 -0.3302702 -0.05117757 0.42655757 -0.0017226937 -0.257581 0.10631899 0.46375352 0.29826576 0.42345738 0.046572104 0.11889448 -0.42911196 0.01773491 0.19612685 0.07758329 0.04519298 -0.29008138 0.088773064 -0.23034629 0.30540225 0.103907995 0.2605279 0.02392109 -0.52039176 0.035984017 0.13009709 -0.037439413 0.28047997 -0.40465954 0.24397826 -0.40931183 0.19637565 0.48995227 0.23612836 -0.3142356 -0.05320879 0.29529044 0.34091184; 0.031859625 0.2038907 -0.46245322 0.38213834 0.19993535 0.046401124 -0.25507843 0.04134803 -0.21524315 0.3458341 -0.19088206 -0.4712001 0.11570297 0.16700116 0.13163103 0.084211774 0.07649935 -0.28051186 0.3959798 -0.040821224 -0.38555607 0.235473 -0.19673495 0.07602888 0.27055395 0.2040935 0.1330978 -0.237722 0.48438436 0.10371464 -0.1097954 -0.25894743 0.5702942 -0.3218672 0.091318645 -0.17286924 0.15868267 -0.10875708 -0.13094546 -0.66309476 -0.36611548 -0.25937384 0.6966432 0.121232316 -0.061169773 -0.07593785 0.16184297 -0.2107949 -0.24550237 -0.28992653 -0.07796005 -0.1773316 -0.42376545 0.041048504 0.16297977 0.51256615 0.00038216426 -0.24459575 0.054654725 -0.1683711 0.09924086 -0.3170646 -0.46252266 0.09851808 0.16827483 0.12826607 0.053568933 0.15755212 -0.28314462 -0.29305264 -0.29962593 -0.5115103 0.10570432 -0.22414209 0.08888686 -0.0629044 -0.28421828 0.26566687 0.009790375 -0.582562; -0.11429257 0.07397428 -0.52629423 0.19662277 0.35376242 -0.45162424 0.26841775 0.037762668 0.22071004 0.36345395 -0.50399584 -0.290204 -0.076596566 -0.44832304 -0.45743248 0.39254695 0.05755492 -0.1802555 -0.10325965 -0.3815417 -0.40390822 0.090582095 0.30434692 0.40016222 -0.20409656 0.1367521 0.09249353 0.17141196 0.4483416 -0.067917004 -0.13732277 0.378979 -0.17991148 -0.19770628 0.1325702 0.38467836 0.39948738 0.48131013 0.15361826 -0.2854024 -0.42579636 -0.10923673 0.25876036 -0.17651425 0.3638396 -0.12725502 -0.38950837 -0.107899696 0.18063149 0.1067291 0.28536063 -0.012471229 -0.08700972 -0.08838894 0.1327675 0.38035557 0.11503473 -0.019182924 -0.45648167 0.17639428 -0.42692447 -0.16406907 -0.3939731 0.50383794 -0.0008873885 -0.1843457 0.40786996 0.32835844 -0.27248943 -0.104166426 -0.26739675 -0.3810357 -0.060737986 0.014867399 0.35760957 0.060670383 -0.17534648 0.16971308 0.28347504 -0.4630774; 0.13009468 0.076193996 -0.47749937 0.22292487 -0.04269758 -0.074952215 -0.10423169 0.34792656 -0.049709838 0.24526171 -0.11772988 -0.55950505 0.23200908 -0.039681733 0.22413717 -0.31270507 0.21627726 -0.4338054 0.30988726 0.04027473 -0.15757063 0.22732759 -0.33324245 -0.30955976 0.4254987 0.35645208 0.39399865 -0.39017725 0.32647496 0.40949422 -0.101962835 -0.26776192 0.5834587 -0.34058353 0.08540481 -0.1306309 -0.13479717 -0.28484914 -0.34326988 -0.4397576 -0.3361538 -0.16825606 0.45194992 -0.064801596 -0.27919102 -0.093457736 0.05422596 -0.05422365 -0.19553478 -0.25983813 -0.07966264 -0.32390788 -0.41785046 0.012379963 0.34959936 0.7059166 0.045524333 -0.29499838 0.06839253 -0.11524351 0.23127048 -0.4038178 -0.29240918 -0.002870665 0.07254801 0.2593228 -0.04377696 0.06707936 -0.12947884 -0.53478575 -0.20747027 -0.42123586 0.24444063 -0.41417375 -0.0023128188 -0.09762256 -0.28601915 0.37791812 0.0656698 -0.69311756; -0.30245474 -0.15418868 0.58851665 -0.0236082 0.0881519 -0.011225405 0.39150423 -0.2032475 0.037343226 -0.28378406 -0.20618217 0.27420634 -0.13583893 -0.32506588 -0.0027678334 0.18852253 -0.24846423 0.4738357 -0.22903335 -0.047350075 0.08794489 -0.26414728 0.23242149 0.26080096 0.19155307 -0.3309711 -0.28230458 0.30659103 0.035085853 -0.14435242 0.33843997 0.13496707 -0.33168322 0.120729424 -0.11730148 0.08952986 0.32066533 0.24219729 0.18332411 0.3306819 0.36583462 -0.06701743 -0.43408892 -0.08133347 0.2695661 0.13844077 -0.08713693 0.13592564 0.30978918 0.09466663 0.36852407 0.18103023 0.10736002 -0.24369521 -0.29386264 -0.2834776 0.15365773 0.2637542 -0.014021643 0.32463685 -0.018384878 0.41789874 0.51681536 0.0645772 -0.29023603 -0.011948681 -0.011153901 0.20790936 0.17858383 0.4651327 0.2963493 0.5223908 -0.17251834 0.12521845 0.025465494 -0.07802903 0.19382109 -0.37756124 0.28134212 0.59912294; -0.23961839 -0.27497995 0.5341992 -0.24956343 -0.19149664 -0.04481016 0.17347652 -0.38069364 0.20952241 -0.30668753 -0.10775184 0.42090368 -0.5052513 -0.2336305 -0.1869807 0.26271197 -0.2432428 0.23102564 -0.3258932 -0.17925805 0.02642037 -0.30275017 0.055652305 0.17047697 -0.46999505 -0.35308728 -0.41425928 0.34083003 -0.26755628 -0.23955154 0.015238455 0.23726685 -0.6872833 0.19459794 -0.18342963 0.11000797 -0.0367517 0.09538256 0.29136506 0.4334135 0.4251877 -0.046123236 -0.6478763 0.049600188 0.22428516 0.4077655 -0.1253911 0.062403888 0.073078975 0.101762034 0.37723622 0.19952302 0.29911676 -0.17921253 -0.25886077 -0.50540805 0.10020827 0.09856433 -0.30109486 -0.015824672 -0.14474766 0.42219955 0.34314284 -0.010082058 0.17544669 -0.21891847 -0.12347047 -0.025720043 0.23698916 0.4860707 0.28845268 0.52266216 -0.35267076 0.1380183 -0.032015417 0.2859771 0.09275172 -0.2236394 -0.027544485 0.75735486; -0.041684873 -0.20030525 0.19445087 0.10795294 0.06273423 -0.3113409 0.04734612 0.062507115 0.34807384 0.112798356 -0.016197681 0.30290395 -0.07483156 -0.20940259 -0.24740021 0.1746285 -0.30539674 0.23240109 -0.33556315 -0.03894272 -0.2679079 -0.03993265 0.24053372 0.15924399 -0.25656995 -0.35926357 -0.26920357 0.14450191 0.3083053 -0.4184442 0.018073568 0.30840465 -0.06475069 -0.11618178 0.14371678 0.11933729 0.19510369 0.047626212 0.28227776 0.4134549 0.08939024 -0.014620621 -0.2333022 0.2704039 0.29416496 0.23063053 -0.10790691 0.012439545 0.27414918 0.26314047 0.21452674 -0.03771379 0.26744086 -0.117837556 -0.1212865 0.2518114 0.1084026 0.1179332 -0.071274266 0.23555413 -0.20388713 0.32866314 0.21727881 0.1223962 0.2929124 -0.13106866 0.100742154 0.06850611 0.16833965 0.3074098 -0.2886622 -0.043644264 -0.02498481 -0.027874408 0.29808432 0.09126751 -0.2393391 -0.22815049 0.2843039 0.32003507; -0.34355748 -0.21061637 0.32884607 -0.23032403 -0.45376956 -0.10995859 0.23471807 -0.32559234 -0.12141071 -0.34348646 0.24407369 0.53638756 0.19033062 -0.1938378 -0.046997055 0.0034170009 -0.24732731 0.24864234 -0.25238684 -0.18660176 0.2830894 -0.10121839 0.11206392 0.20824768 -0.19190437 -0.51236063 -0.21250711 0.1743829 -0.45233202 -0.006866494 0.1580701 0.22321032 -0.29214463 0.57748556 -0.20819362 0.27835795 -0.24856363 0.10138609 0.116648436 0.55180925 0.6530555 0.17468357 -0.53252155 0.14738916 0.11936516 0.117307745 -0.15599647 0.014486164 0.3329563 0.32419965 0.10352527 0.15403031 0.35776326 -0.03768055 -0.29284722 -0.45481318 0.20123073 0.4094917 -0.056313902 0.20020981 0.060664963 0.27493954 0.56351817 -0.16288204 -0.13656335 0.0027441918 -0.18337736 0.110391125 0.39278233 0.27296367 0.7008537 0.42754528 -0.44628465 0.16747572 -0.0015925479 -0.007396037 0.40928024 -0.5538129 0.115190186 0.6263324], bias = Float32[0.10737138; -0.3369503; -0.11023558; 0.071605556; -0.14641084; -0.07367006; 0.11454025; 0.13606176; 0.1725741; 0.057990476; 0.092087775; 0.034596432; 0.11290088; -0.05174825; -0.15991648; -0.14090346; -0.08116334; 0.10136968; -0.08601211; 0.12279621; 0.10477231; 0.20251638; -0.12186962; -0.41189197; -0.13486114; 0.113902144; 0.2258458; 0.29031122; 0.10467465; 0.20034839; -0.15267386; 0.1586497; 0.04802747; -0.18542804; -0.1547182; -0.0980573; -0.14726016; 0.05026994; 0.22240147; -0.11807668; 0.10230317; -0.046147607; 0.1124224; 0.17602529; -0.11243405; 0.14327285; -0.06856136; -0.18228461; -0.0844161; 0.036443003; -0.08711674; -0.17354265; 0.016672762; -0.06219338; -0.13443671; -0.08652327; -0.10251216; 0.12678686; 0.1473335; 0.1102918; 0.15635036; -0.10535511; 0.17932963; 0.16998236; -0.022322122; 0.1495526; 0.09096404; 0.14370097; -0.036255352; -0.03530109; -0.16335866; -0.11304305; -0.122463934; 0.024912765; -0.18072125; 0.06852968; -0.16686586; -0.0023118884; -0.15099081; 0.027455691]), layer_3 = (weight = Float32[0.21879534 1.0324218 -0.45462692 -0.4211095 0.1413943 0.080355145 0.7523199 0.28527245 -0.91557324 -0.8725891 0.610067 0.50559187 -0.9812983 -0.8014207 0.9711377 -0.114613794 -0.013919563 -0.8722402 -0.38967633 0.103563994 -0.74371463 -0.7422786 0.20003127 0.55469584 0.99995077 -0.012512902 -0.64159316 -1.1170045 -0.0722976 0.26994067 0.3488431 -0.29092783 -0.7775042 0.49986494 0.026288508 0.23279631 0.7046604 -1.0363624 -0.5515502 1.0741736 0.34716898 -0.6325209 -0.7764446 0.29649517 0.73907846 -0.4451378 0.9458997 0.35822505 -0.37125888 -0.83975965 1.0694232 0.95362425 0.40633515 0.99131185 0.0022784295 0.77689767 -0.65045935 0.4329358 -0.91751283 -0.68389285 -1.2751998 -0.28436616 -0.4671855 -0.061419185 -0.47208345 -0.4907282 0.53513503 -1.0046285 0.3672343 0.7661526 0.1511409 -0.300876 0.50402004 0.6220743 1.0383074 0.4538482 -0.22295457 -0.39539194 0.13914311 -0.6407218; -0.02396804 -0.29107997 0.0771961 0.18882363 -0.031284504 -0.0070553054 -0.30944186 -0.14636056 0.4987802 0.49428284 -0.24872667 -0.20513408 0.50876904 0.30991662 -0.48905358 0.038315713 0.017060628 0.63046616 0.08026221 -0.069156714 0.5086554 0.116540715 -0.069613755 0.012538852 -0.5341419 0.024267351 0.18116474 0.30376393 0.015461904 -0.13271171 -0.14051366 0.094591476 0.37844566 -0.13101023 -0.008554782 -0.03244513 -0.38498813 0.32776368 0.16909523 -0.4112756 -0.18609501 0.30116057 0.31232166 -0.10542926 -0.47372395 0.21038543 -0.35623196 -0.13617456 0.15574846 0.44546208 -0.48256806 -0.4134558 -0.18536411 -0.39572516 0.0357308 -0.23809946 0.19305542 -0.22403651 0.50293094 0.1452781 0.55895716 0.083344735 0.20678903 0.0051308475 0.2676646 0.103989 -0.19004956 0.52342874 -0.28985107 -0.24824364 -0.048829958 0.046080314 -0.2780254 -0.2721014 -0.55607134 -0.15104768 0.14722152 0.030026952 -0.0031228762 0.15760525], bias = Float32[-0.46852085; -0.25465778]))

loss_neuralode(p_trained_moderate)


#high noise 

rng = Random.default_rng()
Random.seed!(99)
#Adding moderate noise to data:

x1=Array(sol)

x1_mean = mean(x1, dims = 2)
noise_magnitude = 35e-2
x1_noise = x1 .+ (noise_magnitude*x1) .* randn(eltype(x1), size(x1))


#-------------------------------------Defining the Neural ODE------------------------------------


dudt2 = Lux.Chain(Lux.Dense(2, 80, tanh),Lux.Dense(80, 80, tanh), Lux.Dense(80, 2))
#Setting up the NN parameters randomly using the rng instance
p, st = Lux.setup(rng, dudt2)




prob_neuralode = NeuralODE(dudt2, etaspan, Tsit5(); saveat = etasteps)

function predict_neuralode(p)
    Array(prob_neuralode(I, p, st)[1])
end


#training data
true_data= x1_noise[:,1:end-90]
### Define loss function as the difference between actual ground truth data and Neural ODE prediction
function loss_neuralode(p)
    pred = predict_neuralode(p)
    loss = sum(abs2, true_data .- pred)
    return loss, pred
end

p_trained_high = (layer_1 = (weight = Float32[0.60219336 0.13327536; -0.5362331 -0.17012675; -0.1937081 0.8245218; -0.4890926 -0.47731414; -0.38679513 -0.5150542; 0.810716 0.09913745; -0.5326511 0.36683849; 0.4129182 -0.034287654; -0.6458096 -0.31133837; -0.5801148 -0.4834114; 0.7872867 0.19492891; -0.7718252 1.1115165; -0.05057695 -0.81528485; 0.5912248 -0.14485091; 0.7397126 0.06985246; -0.7438672 0.041863397; -0.1165934 -0.6436149; 0.15262827 0.7468803; 0.7439705 -1.2218515; 0.55902547 -0.17022851; 0.7811762 0.43131384; 0.33937383 0.04339622; -0.80053407 0.06291361; -0.73656195 -0.11895055; -0.45707908 -0.5373802; -0.54934365 -0.5273949; 0.7973531 -0.9597641; -0.49495333 0.37651926; -0.8061715 -0.47244835; 0.57687944 -0.9013988; -0.66783285 -0.15164189; -0.7214531 -0.01890293; 0.1470602 -0.81473845; 0.7497289 0.5331181; -0.43918934 -0.42480716; -0.74720097 0.031837635; -0.78918386 -0.1575305; -0.812563 0.27389923; -0.56072885 0.25267792; -0.8011492 1.1768647; 0.129994 0.82719934; 0.58817106 0.24129494; 0.6350864 -1.1228137; -0.23908502 0.63812226; -0.57159823 0.117566615; 0.09678729 0.6566282; 0.41944078 -0.020747723; -0.3262847 -0.056088977; -0.79704493 0.48298827; -0.66999054 0.014396353; -0.511905 0.4777501; -0.51209825 0.40733275; -0.3662808 0.6505098; 0.53010327 0.003482142; 0.36245447 -0.4769279; -0.67384243 -0.7681446; -0.3569528 0.6751494; -0.37058458 0.10850862; 0.718021 -0.0029813673; -0.51410586 -0.07803856; 0.7577273 0.081604764; 0.16171956 0.7418811; -0.9323231 1.1996738; -0.70818263 -0.146265; 0.06651254 0.5327039; 0.8039709 -0.114297405; -0.7171095 -0.2738623; -0.6219459 -0.30960914; -0.57465386 -0.21886706; -0.59902054 1.0565952; 0.24812971 0.68737334; 0.40481135 0.72354764; 0.6658256 -0.26086286; -0.4548089 0.0153807225; -0.80945754 0.0073186196; -0.30074623 0.59639305; 0.88354826 0.4009961; -0.3461468 -0.6474584; 0.6780754 -0.75127494; 0.16506697 0.89067215], bias = Float32[-0.14795507; 0.05747199; 0.2482622; -0.38064227; 0.047406517; -0.57229006; 0.35868838; -0.39784625; 0.5182053; -0.24607123; -0.66790277; 0.45996758; -0.87492645; -0.42930922; -0.6435504; 0.34645858; -0.4211159; 0.34580484; -0.54005605; -0.38713044; -0.7099511; -0.30566835; 0.66628647; 0.5563347; 0.12789525; -0.42627046; -0.6869842; 0.38213754; 0.5977327; -0.71492344; 0.36806896; 0.38454637; -0.2422719; -0.65702987; -0.03908935; 0.36804664; 0.479038; 0.45988366; 0.47055227; 0.39237726; 0.45695397; 0.052319203; 0.077357225; 0.45094436; 0.5814927; 0.8053194; -0.26038375; 0.6054707; 0.34522066; 0.24699165; 0.4166037; 0.445342; 0.19589695; -0.5426134; -0.45314655; 0.509648; 0.7353001; 0.5310978; -0.3830807; 0.51742387; -0.65961593; 0.4513564; 0.4070341; 0.61567533; 0.60153174; -0.4535941; 0.95058304; 0.40199208; -0.23713563; 0.397159; 0.2050492; 0.035011426; -0.14068148; 0.58633256; 0.3876624; 0.38322607; -0.594465; -0.22963804; -0.20906992; -0.027804254]), layer_2 = (weight = Float32[0.5417689 -0.48712826 -0.35581544 -0.22442381 -0.40588212 0.52120215 -0.9174271 0.94664156 -0.4005888 0.33198696 0.2519465 -0.8857885 0.6586673 0.8014413 0.44809118 -0.27483824 -0.18359852 -0.09139704 0.79517674 0.7914436 0.07676596 1.1972996 -0.5067211 -0.33053368 0.32334346 0.33739418 0.2911863 -0.9468338 0.7594019 0.35225722 -0.3509774 -0.35758632 0.72126436 -0.5485316 -0.5276802 -0.39202416 -0.3340038 -0.56815296 -0.8588699 -0.95451885 -0.35991457 0.2866518 0.6786907 0.7965919 -0.88631487 -0.24001059 0.9672531 -1.260495 -0.35605913 -0.6439886 -0.98806226 -0.8622718 0.19330457 0.792305 1.3091025 0.8893777 0.4295775 -1.0674622 0.4389421 -1.0470608 0.31985316 -0.42920402 -0.7566005 -0.5149152 0.9776663 0.3006316 -0.28754577 -0.4704139 -0.40274045 -0.8061474 -0.10272492 -0.96066624 0.6837977 -1.097551 -0.32123974 0.31880918 -0.49036166 0.05371436 0.123044506 -0.8303695; -0.4108524 0.19293042 -0.2253204 0.30399734 0.26367357 -0.6103825 0.64520925 -0.4262995 0.4269108 0.47176284 -0.7740875 0.5980367 -0.6711633 -0.66857517 -0.5565782 0.8080396 0.24122834 -0.08589895 -0.84133554 -0.77598405 -0.47947764 -0.11437178 0.79905117 0.7599612 -0.3761581 0.25078127 -0.4588774 0.49060994 0.6179448 -0.48558298 0.53252345 0.86562467 -0.36603248 -0.4943719 0.3705709 0.63937813 0.75156486 0.74470043 0.5867955 0.4246547 -0.13874465 -0.28289083 -0.38143787 0.07293648 0.6190693 0.050517462 -0.38576087 0.44920033 0.75372785 0.58863205 0.49894285 0.41806844 0.10044908 -0.5833542 -0.35097632 0.4271554 0.070966095 0.26271158 -0.9308924 0.5979839 -0.8964611 -0.061375093 0.3409471 0.73400927 -0.07499569 -0.88935715 0.7058123 0.4617275 0.2763907 0.2612694 -0.48709014 -0.086091116 -0.5803528 0.447563 0.8482713 0.06759912 -0.503194 0.38155514 -0.19908217 -0.078326136; -0.41792887 0.419631 0.70861274 -0.38804194 -0.2162035 -0.35603774 0.633641 -0.37822068 0.267477 -0.41318533 -0.18150067 0.91565853 -0.9856528 -0.56092507 -0.4806047 0.38672164 -0.53143907 0.44546637 -0.8688701 -0.5690057 0.08005529 -0.35063735 0.48432997 0.52718693 -1.0851638 -0.5161371 -0.7738625 0.51284665 -0.724872 -0.5680717 0.26337433 0.31184134 -0.79919904 0.4145518 -0.38951784 0.27449718 0.20998852 0.31027493 0.40882722 0.89885795 0.79650164 0.29913977 -0.8028624 0.13947159 0.34933046 0.3405959 -0.50698143 0.33859062 0.30101463 0.30404845 0.3996985 0.37812436 0.5020889 -0.5486043 -0.51036066 -0.7178862 0.38219485 0.4529326 -0.40128827 0.24181952 -0.2701508 0.73719 0.8066464 0.22205682 -0.07458806 -0.43554416 0.028573245 0.2252535 0.18597154 0.7542289 0.6467797 0.60180783 -0.2960525 0.4093611 0.28031114 0.3813602 0.47831753 -0.6337425 -0.47739288 0.95672566; 0.7586735 -0.8444391 -0.62323475 0.85302424 0.6712832 0.6104898 0.44480163 -0.9235058 -0.9110818 0.6005892 0.4930115 0.52486634 -0.67203707 -0.596248 0.5342835 -0.65726936 0.93736243 -0.7596774 -0.52274257 -0.567429 0.4907129 -0.66879016 -0.69612086 -0.7480641 -0.876148 0.55188656 1.0788567 0.91977733 -0.5221881 1.0455964 -0.7199726 -0.76030636 -0.5169609 0.39715934 0.5550767 -0.7801441 -0.5220792 -0.60146886 0.5916433 0.37376648 -0.7503257 -0.5726134 -0.6269941 -0.7404759 0.5800712 -0.6696951 -0.61617976 0.91812134 -0.5170263 -0.7981407 0.77181065 0.68502736 -0.95199406 -0.8458339 -0.71439856 -0.48396486 -0.75986546 0.7559578 0.5451196 0.7193033 0.45289826 -0.6633618 -0.91245407 -0.5616182 -0.8222601 0.6728136 -0.7049141 -0.8554473 -0.74204385 0.36145613 -0.56983066 0.761323 0.58356255 0.7001035 -0.6448163 -0.9864471 0.73162776 0.55851495 1.0580595 0.5742739; -0.24279293 0.57363695 0.23914374 -0.1696893 0.72562677 -0.35581344 0.59325135 -0.88564885 0.42109904 -0.4292043 -0.2982108 0.4658531 -1.5082327 -0.79155535 -0.46935025 0.22815841 -0.105462156 0.4129379 -0.8015579 -0.87953734 0.011811689 -1.0431914 0.46370453 0.5661119 -0.9019129 -0.4273719 -0.2975509 0.6473249 -0.94589216 -0.4623531 0.30731732 0.38846883 -0.71544516 0.5952957 0.7682473 0.43739334 0.19316307 0.4649359 0.6808456 0.61622626 0.38737994 -0.5433139 -0.66664445 -0.81228656 1.0857875 0.2115944 -0.7447278 1.5024436 0.4070456 0.39266622 0.8842802 0.9485126 -0.19729993 -0.85557324 -1.0930042 -0.8897334 -0.02196714 1.0359676 -0.35061082 1.0700641 -0.5833627 0.58431274 0.47813103 0.51041543 -0.80712026 -0.40252686 0.641083 0.12883192 0.32101336 0.6686323 0.12990302 1.349502 -0.30232108 1.107565 0.39921668 -0.33414212 0.17294991 -0.2287901 0.024727968 1.0552515; -0.42632893 0.5516688 0.7287962 -0.5892772 -0.80837363 -0.25974333 0.05380512 0.35581443 0.7244628 -0.60614496 -0.31105363 0.36051816 0.9159435 0.23946105 -0.3560893 0.5899797 -0.81088763 0.84916794 -0.18552944 0.16601253 -0.07092088 0.3640304 0.25408348 0.5565705 0.6516787 -0.90066975 -1.0353296 -0.34697142 0.3592114 -0.6859717 0.56023145 0.53354436 0.59800553 -0.067979276 -0.8447561 0.6644659 0.35269564 0.31828773 -0.41242683 0.37849998 0.7760315 0.67226523 -0.2231502 0.80632156 -0.36433253 0.65974784 0.40712386 -0.69054145 0.5686259 0.70676 -0.24320593 -0.6903402 0.9311585 0.429432 0.40599295 0.3192221 0.62619966 -0.17381114 -0.6605143 -0.37338153 -0.5432638 0.7958323 0.8731197 0.5433597 0.70079166 -0.40394604 0.55931103 0.7909843 0.7483681 -0.038664095 0.5487924 -0.5286476 -0.45059383 -0.47048318 0.41577154 0.9623922 -0.05595337 -0.79981697 -1.1525974 -0.14670728; 0.4707273 -0.7500857 -0.31685928 -0.19180366 -0.15030152 -0.3930504 -0.4749076 0.6251343 0.054700445 0.27526215 -0.3669581 -0.7500526 -0.2284164 0.42596385 -0.2592529 -0.26662093 -0.21489523 -0.1982664 0.5257835 0.4602293 -0.90046847 0.795276 0.19058613 0.04566989 0.18159828 0.32470834 -0.08241321 -0.5031306 1.1698827 -0.036675345 -0.44816005 -0.15348075 0.10510406 -1.1871274 -0.22860299 -0.15279521 0.48067105 -0.048666082 -0.46864665 -0.52897835 -0.10830829 0.062030654 1.1518131 0.36465448 -0.25597635 0.08035778 0.52147627 -0.6008289 0.006177376 -0.3558304 -0.5785478 -0.31052783 0.15315267 0.27029908 0.53198856 0.99774516 0.27377445 -0.43234012 0.108040094 -0.29139394 -0.32344425 0.064746544 -0.33664083 -0.026213853 0.27111349 -0.12524691 0.6672741 0.014208523 -0.5444906 -1.0255882 -0.49742857 -0.75571966 0.44974557 -0.6991166 0.14882769 0.3951432 -1.1232781 0.23415425 0.112719215 -1.1407583; 0.36513227 -0.30026808 -0.87045485 0.71068203 0.54988337 0.48242298 -0.35139045 0.005160931 -0.6014811 0.68445975 0.2735234 -1.1642107 0.85400367 0.12253556 0.33429226 -0.34328178 0.55637175 -0.6351554 0.90405315 0.13361947 0.3554183 -0.1689844 -0.43456075 -0.41044816 0.7925818 0.82774955 0.87405175 -0.14900652 -0.026171789 0.7560659 -0.59070694 -0.39988732 1.2430762 -0.2635478 0.56122875 -0.4024263 -0.29384944 -0.7563283 0.061066665 -1.0430703 -0.6647262 -0.7334203 0.788059 -0.3890786 0.06705671 -0.53437215 -0.16845614 0.18373896 -0.38828543 -0.64617246 -0.31708786 0.06710512 -0.50219303 0.14762637 0.04521863 0.23559092 -0.43444225 -0.13783765 0.4570087 0.20085742 0.34699225 -0.9057768 -0.96943086 -0.5329826 -0.4360163 0.40454012 -0.5182146 -0.18382426 0.022621665 -0.7879509 -0.8041404 -0.8435557 0.28732067 0.09832093 -0.39887953 -0.7163119 0.16961843 0.64781564 0.8706666 -0.7098905; 0.4050923 -0.14853744 -0.14527053 -0.08852575 -0.26643094 0.9211849 -0.5305835 0.1326771 -0.61352485 -0.26860437 0.6947288 -0.8825747 0.709528 0.32408085 0.410078 -0.64613616 0.16837159 -0.15782757 1.0522169 0.27663594 0.39884672 0.014137235 -0.7581237 -0.8138369 0.32220647 -0.14367175 0.7131926 -0.13348024 -0.30381823 0.6294096 -0.70601887 -0.9575615 0.4681288 0.27832383 0.036638133 -0.8927651 -0.5251587 -0.7698356 -0.22669986 -0.71867704 -0.055958055 0.43883556 0.54389983 -0.084969506 -0.47422883 -0.42218503 0.35008362 0.042765073 -0.79893315 -0.7306212 -0.3299859 -0.07579788 -0.09550907 0.2475402 0.01315847 -0.43031833 -0.46482134 -0.17548944 0.84983927 -0.32836 0.6612913 -0.21298224 -0.71753395 -0.50241524 -0.11821052 0.921486 -0.24224274 -0.04691464 0.013411263 -0.6352753 0.17906073 0.14046347 0.58198607 -0.32000107 -0.95123214 -0.17741384 0.59859014 -0.29022452 0.2631474 -0.12926157; -0.9770456 1.0697325 1.0564512 -0.31288195 -0.7517798 0.392634 -0.7334917 0.2973766 -0.10538339 -0.217253 0.39396316 0.34143063 0.9483879 0.7431101 0.115125775 0.14915179 -0.57263803 0.5591667 -0.041076005 0.65933704 0.24008727 0.24074726 -0.6045355 -0.49195352 0.6053744 -0.3022524 -0.35144553 -0.41344672 -0.29746142 -0.6219988 0.7457704 -0.29072836 -0.072846085 0.2029035 -0.41717973 0.06295024 0.070809275 -0.1027669 -0.74000615 0.5668751 0.7577701 0.35787198 -0.8408318 0.42860994 -0.9935411 0.18822913 0.2952251 -0.65680075 0.11979418 0.34872457 -0.77091813 -0.475688 0.7114212 0.8295706 0.57419896 -0.39007875 0.19463572 -0.50361407 0.23228431 -0.99055773 0.7555649 0.3094134 0.5592368 -0.26395133 0.26350015 0.20615387 -0.6136503 0.27103573 1.3734239 0.440118 0.7493324 -0.32051226 -1.0825576 -0.7700765 -0.062230855 0.34394038 0.45630667 -0.8051305 -1.0160342 0.067394726; 0.15106012 -0.100075625 -0.5933346 0.80152863 0.24855532 0.06542809 -0.36563364 0.26412717 -0.09637998 0.67367226 -0.07462622 -0.7816654 1.7562314 0.050623856 -0.022197535 -0.0049149566 0.77833587 -0.62325567 0.829509 0.08189043 -0.34104958 0.4884648 -0.25976512 -0.22859488 1.4009397 0.7962918 0.41817728 -0.501829 0.6266165 0.53035206 -0.14865884 -0.24222794 1.4076219 -0.48195764 0.40209308 -0.17588075 -0.026620768 -0.30514613 -0.15027481 -0.7407386 -0.8394102 -0.7289779 0.7650892 -0.27079532 -0.07498829 -0.5381534 0.12456545 -0.34520802 -0.19892727 -0.291454 -0.46439844 0.010793812 -0.3033825 -0.03443436 0.56042564 0.79765487 -0.35266507 -0.50453824 0.3547362 -0.057981107 0.09798366 -0.7398878 -0.5703947 0.0052494863 -0.21093628 0.027057048 -0.015373162 0.21556652 0.22696827 -1.1035956 -0.60240775 -0.961791 0.38650417 -0.4326224 -0.3009054 -0.2783243 -0.4913183 0.7013037 0.41635248 -0.7983163; 0.6201488 -0.69122 -0.5484543 0.312747 0.0053083217 -0.20819256 -0.63620883 0.90559334 -0.33766752 0.40879583 -0.24609597 -0.55696166 0.46357912 0.42067286 -0.15122056 -0.19894023 0.20995972 -0.24015525 0.6112328 0.3976993 -0.5525716 1.1225302 -0.03828397 -0.30441746 0.5304124 0.44720307 0.2458571 -0.94502574 0.8177816 0.23381658 -0.28592607 -0.22693683 0.29160327 -0.88201755 0.07601545 -0.15265094 0.14109689 -0.17043068 -0.52548856 -0.5674833 -0.37987462 -0.36888823 0.46927536 0.6002548 -0.2858329 0.08757456 0.85729843 -0.820115 -0.08978768 -0.4535464 -0.82775193 -0.66051483 0.3755265 0.34350133 1.3137739 0.8158798 0.31417286 -1.0134706 0.32195005 -0.5669763 0.06850808 -0.43667594 -0.5579364 -0.2578732 0.8620517 -0.09223477 -0.081456535 -0.05719848 -0.2231273 -0.68665045 -0.18265186 -0.8810399 0.36657462 -0.9483623 0.08788235 0.40068048 -0.89488167 0.44454804 -0.021867748 -0.84312934; 0.6303246 0.082474664 -0.41881734 0.18329976 0.22820263 0.87146086 -0.40700573 -0.03058563 -0.53960395 0.04998315 0.7012807 -1.03962 0.73788613 0.30168638 0.6871348 -0.89873075 0.29771483 -0.5176564 1.024919 0.19595988 0.7971571 -0.074876755 -0.8037075 -0.8018921 0.5568502 0.46732244 0.6366363 0.03591972 -0.5234538 0.4679368 -0.5613848 -0.95669395 0.99098825 0.66734874 0.046061307 -0.9529493 -0.8453119 -0.9026986 -0.23118845 -1.0067121 -0.53646976 0.09381641 0.7555293 -0.26567027 -0.0054797046 -0.37799966 0.11023547 -0.049575478 -1.1064259 -0.83752567 -0.17769064 -0.09404345 -0.5357588 0.007969472 0.048111264 -0.5656187 -0.33499816 0.06509159 0.9013298 -0.091334336 1.0434643 -0.55644935 -0.81214464 -0.6956475 -0.31226525 1.0065427 -0.6190988 -0.60086364 -0.029970912 -0.47244552 -0.19777238 -0.03405763 0.8715478 0.08038592 -0.9749921 -0.53341955 0.81936467 0.25176245 0.608813 -0.14762957; -0.49441636 0.38131016 0.7619339 -0.30948317 -0.902033 0.4649197 -0.0660398 -0.094404854 -0.21203826 -0.5215879 0.7613835 0.71458316 -0.11447611 0.19288501 0.6373227 -0.058182087 -0.56397593 0.8727045 -0.5936072 0.014053178 1.4718667 -0.09535367 -0.4554433 0.03980359 -0.2901441 -0.6789437 -0.28967485 0.33023337 -1.2645763 -0.40389267 0.28046286 0.23465252 -0.49755853 1.4376194 -0.5716182 0.29222015 -0.27400795 0.008332698 -0.36141506 0.77463436 0.9312637 0.59387714 -1.08439 0.113796405 -0.39349538 -0.058832016 -0.03230577 -0.07262605 0.2258835 0.109104045 0.29724973 -0.20958026 0.3837324 0.22630458 -0.050371323 -1.2455616 0.05048368 0.2911631 -0.24043441 -0.4890393 0.39120495 0.6244138 0.6255669 -0.38367864 -0.13326651 0.08570974 -1.4583178 -0.47593853 0.8071531 0.7615903 1.1448976 0.7936451 -0.30148652 0.031945564 -0.2080444 0.177954 1.3395257 -0.8252591 -0.62585104 0.7413385; -0.08028378 -0.5020532 -0.6314201 0.48310202 0.4353879 -0.578536 0.62689656 -0.18431272 0.49387202 0.37217242 -0.6603596 0.07919418 -0.6331955 -0.54423344 -0.38751283 0.5766792 0.19171448 -0.3466 -0.17443416 -0.49688756 -0.5864298 0.19701758 0.81325203 0.8565979 0.037495825 0.68453026 -0.10121802 0.3154148 0.5148753 0.080497146 0.31731367 0.650983 -0.022713944 -0.5609379 0.49458057 0.64420646 0.6015352 0.7647086 0.5031907 -0.38114548 -0.49761072 -0.7063441 0.4925352 -0.35450333 0.48270142 0.037946854 -0.32231292 0.094968185 0.7623036 0.5966572 0.38808134 0.30949703 -0.5058996 -0.5938864 0.019246632 0.57437205 0.2555557 0.2375431 -0.7206491 0.37755436 -0.70963025 -0.30514318 0.06975805 0.55413264 -0.040085644 -0.4994052 0.44661084 0.3652941 -0.5152309 -0.14198068 -0.50130147 -0.18783377 -0.40831313 0.38477978 0.74262637 -0.065080136 -0.76120937 0.3761209 0.43065917 -0.41646484; -0.5575378 0.6567849 0.09047938 0.015720434 0.42447373 -0.3654074 1.0565553 -1.1629086 0.6121725 -0.65308106 -0.5358485 0.88914746 -1.9356877 -1.0944041 -0.36910278 0.36631748 -0.12962152 -0.03783191 -0.6156909 -0.9824017 -0.31157288 -1.7129971 0.686304 0.32882437 -0.43048564 -0.5024917 -0.3116388 0.8179662 -0.48469374 -0.32001767 0.6398053 0.42448384 -0.300984 0.1844512 0.44562012 0.5570596 0.21427506 0.4468368 1.2007214 0.5084769 0.16330275 -0.1926642 -0.25153542 -0.55168504 1.0237776 0.42016584 -1.0841031 1.6644272 0.5529826 0.477664 1.0988137 1.1496017 -0.29110646 -0.91363025 -1.5729302 -0.6947302 0.009941321 1.2086968 -0.34160763 1.1576867 -0.6439501 0.39097103 0.29482633 0.6598237 -0.8772013 -0.4332051 0.7918571 0.5561513 0.2280556 0.86376107 0.082114965 0.9833057 -0.54339427 1.0973083 0.45467168 -0.5714925 -0.09153871 -0.12520857 0.07529371 0.7364045; -0.37605345 0.40503776 0.2048039 0.08934604 0.5488784 -0.39033544 0.80365413 -1.3402885 0.6322042 -0.117527135 -0.25421938 1.112183 -1.3359519 -0.7717955 -0.37469745 0.34810504 0.2449838 0.014691586 -0.7307788 -0.7987824 -0.1107266 -1.2720863 0.388761 0.32708916 -0.23393005 -0.32415313 -0.25224808 0.8752509 -0.46435 -0.43736365 0.38221917 0.5520032 -0.692911 0.22853996 0.5891734 0.2740124 0.37837917 0.5428782 0.8397085 0.88087285 0.2980355 -0.028348716 -0.87818533 -0.42546698 0.9256997 0.08313594 -1.0148238 1.3444407 0.22613691 0.46084043 0.9025067 0.89304405 -0.4127453 -0.9575004 -1.3749748 -0.70301497 -0.122330785 0.9951023 -0.48071527 1.0699536 -0.28761843 0.16929656 0.71664405 0.30756018 -1.0301757 -0.34616467 0.49923137 0.26997074 0.29735193 1.1470666 -0.03796189 0.74144375 -0.5699763 1.1552432 0.19360471 -0.2981027 0.3168946 -0.10176535 0.12566034 0.867687; 0.46513388 -0.4207714 -0.1839502 -0.35222295 -0.19195415 0.59422046 -0.8109804 0.2683326 -0.3682132 -0.20724541 0.60665977 -0.8748959 0.53852797 0.6691279 0.39697057 -0.6049208 0.18860492 -0.26234993 0.8303325 0.60316026 0.34596273 0.3491675 -0.6716023 -0.5782011 0.23111822 -0.12139099 0.5320947 -0.73203 -0.18343128 0.44227308 -0.7093266 -0.5639542 0.15120728 0.38061976 -0.45310995 -0.6244555 -0.42259654 -0.76638913 -0.6123808 -0.77536243 -0.13429257 0.40023246 0.3561507 0.13365436 -0.55689365 -0.29684567 0.43457657 -0.40380237 -0.77449375 -0.83041495 -0.6704668 -0.53494626 -0.16146852 0.6377294 0.3728595 -0.016390717 -0.32935473 -0.6634318 0.65713423 -0.6537453 0.67937165 -0.26527885 -0.6288737 -0.46708265 -0.10194539 0.6845056 -0.5932057 -0.20760259 -0.37514675 -0.4272642 0.25963163 -0.12020305 0.74348843 -0.52272713 -0.49834073 -0.13217205 0.467237 -0.03397911 0.13217081 -0.412411; -0.5539198 0.30009905 0.620966 -0.32013866 -0.09525926 -0.17194733 0.5861833 -0.74372536 0.13876422 -0.3108778 -0.10010117 0.7541457 -0.8978365 -0.3679333 -0.37050673 0.30761978 -0.31171745 0.4462612 -0.65549964 -0.4558673 0.48487154 -0.48939413 0.37874818 0.37684974 -0.8700727 -0.4986649 -0.6572048 0.75351125 -1.0552334 -0.587757 0.33789146 0.24656366 -1.0554072 1.113443 0.18380214 0.394373 0.36415988 0.3849767 0.6538019 0.95404756 0.60728294 -0.09553864 -0.93335116 -0.21084501 0.42018607 0.4885888 -0.43840873 0.72424173 0.32128775 0.36545748 0.45843658 0.73986477 0.20690645 -0.52183896 -0.49828303 -0.93057895 0.0042293584 0.43798068 -0.5025042 0.38443685 -0.4016835 0.40055138 0.63981843 0.41978234 -0.45905638 -0.53537905 0.10073028 0.23611331 0.53889954 0.97474885 0.5097185 1.1366504 -0.49777496 0.6322819 0.15076132 0.086038776 0.79076725 -0.38747254 -0.5723539 0.87488467; 0.2070105 -0.10372778 -0.56004834 0.5677111 0.4735838 0.5587402 -0.11646572 0.1046358 -0.34757242 0.66354233 0.72220224 -1.1343428 0.9075407 0.023151306 0.37302926 -0.45887178 0.5438718 -0.8654732 0.80841625 0.11041406 0.17707866 -0.042143818 -0.7725164 -0.49837992 0.9110899 0.63584495 0.74672073 -0.31284502 0.1267089 0.93769556 -0.5236226 -0.40779996 1.1177154 -0.23441671 0.54450536 -0.5996922 -0.52736527 -0.64566946 -0.22897328 -1.0838532 -0.643248 -0.36270466 0.741243 -0.43126586 -0.08267379 -0.6244684 0.039145697 0.22412565 -0.51573056 -0.31965384 -0.21272868 0.098744206 -0.7574952 -0.023531914 0.097340174 0.25244945 -0.7119731 -0.22953211 0.48065847 0.106982075 0.4710485 -0.57075447 -0.9515551 -0.6401524 -0.3807015 0.453557 -0.3012093 -0.01824191 0.054085314 -1.0098486 -0.60584474 -1.0946453 0.6241445 -0.058185477 -0.7396316 -0.7208582 0.20418616 0.5035351 0.66534066 -0.5667116; 0.70491105 0.116435096 -0.7326394 0.43730897 0.46585515 0.9404482 -0.09241089 -0.20818257 -0.8570732 0.611988 0.6746941 -1.0058727 0.8471201 0.045855194 0.5900389 -0.7361538 0.4774375 -0.6576389 1.0485106 -0.05037126 0.73169184 -0.020075379 -1.0761768 -1.0219698 0.49459568 0.5708594 0.4921842 -0.18091872 -0.6223356 0.5381644 -0.62386054 -1.0187391 1.0267354 0.5505019 0.114165395 -0.919521 -1.0021284 -1.134558 0.029310316 -0.88200754 -0.4444289 -0.3299002 0.8224871 -0.51931715 0.06973934 -0.6317084 -0.18448323 0.17163002 -0.8415442 -0.7124028 -0.07740823 -0.00976239 -0.6404579 0.10331536 -0.09638924 -0.461813 -0.45278925 0.06078759 1.1125431 0.12122612 1.0787333 -0.5012943 -0.9170308 -0.7647996 -0.34621084 0.9947335 -0.53120697 -0.53181493 0.096036576 -0.88809794 -0.24039367 -0.13711649 0.62764597 0.27495354 -1.0490178 -0.6024117 0.75977606 0.2764527 0.6501421 -0.03872145; -0.48712915 0.8423127 0.75331104 -0.38194883 -0.5098539 0.5075831 -0.2223069 0.17631266 -0.71843284 -0.32922137 0.66048294 0.5514599 0.62715197 0.3861408 0.78869474 -0.35456768 -0.29004884 0.5842846 -0.07299434 0.29134732 0.81791806 -0.0889664 -0.6451342 -0.7477885 -0.17791238 -0.56516427 -0.29791617 -0.10645942 -0.85222524 -0.21597774 0.2924302 -0.5336762 -0.044067964 0.8157276 -0.3110323 -0.25063694 -0.62356657 -0.48244503 -0.34518626 0.8326615 0.38892278 0.27112964 -1.0501443 0.12672509 -0.58128387 0.12543738 0.075162575 -0.13581207 -0.20482916 0.09322296 -0.26188174 -0.25812003 0.51084286 0.47515103 -0.051499963 -0.820604 -0.28861183 -0.04266583 0.43603 -0.3680218 0.73026353 0.409618 0.246037 -0.7808071 -0.14275375 0.546878 -0.91584325 -0.16524392 1.3851675 0.6654023 0.77379346 0.6560419 -0.60061437 -0.40370592 -0.50453395 0.035529293 0.7597796 -0.60983706 -0.47174168 0.616798; -0.47659543 0.37434158 0.23187003 -0.035799243 0.60151047 -0.34243092 0.8692365 -1.1111157 0.51252234 -0.34141818 -0.6382461 0.6434634 -1.8298419 -0.9409118 -0.44874913 0.55972373 -0.119025975 0.260021 -0.627602 -0.9873229 -0.24690019 -1.1771976 0.6954918 0.39601666 -0.24560486 -0.6812831 -0.47076368 1.0124162 -0.17582782 -0.36531955 0.37452266 0.31258845 -0.6006471 -0.2851329 0.544292 0.5533401 0.4696487 0.4381978 0.8448245 0.50770485 0.3455066 -0.34736338 -0.22222582 -0.3805765 1.2904001 0.3439517 -1.0340228 1.2227393 0.5973522 0.4030946 1.0152555 1.1612315 -0.25292033 -1.0336497 -1.3451722 -0.5659486 0.0023418085 1.0128822 -0.5164686 1.0863619 -0.47736284 0.3536481 0.5382994 0.67133445 -0.6298667 -0.49389398 0.59813976 0.2055166 0.046692647 0.8218522 0.024836875 1.0503988 -0.58818275 1.2459867 0.5042724 -0.31235722 -0.06890693 -0.24497356 0.16943616 0.8242507; -0.5122934 0.07323533 -0.037349313 0.05206825 0.32490906 -0.8453639 0.24931955 0.071969 0.72369736 0.5570547 -0.9362519 0.6110616 -0.5363872 -0.57553834 -0.571449 1.021252 -0.16892292 0.11005477 -0.856881 -0.1357229 -0.8906036 -0.013690221 0.81351084 0.782491 -0.28046048 0.40232876 -0.36034068 0.054579224 0.75530386 -0.68649125 0.5036684 1.1016439 -0.2275838 -0.5448004 0.018998863 0.7904962 0.83159536 0.81234926 0.2876159 0.44059643 -0.059259135 -0.32312992 0.050903175 0.10469717 0.37723768 0.43918118 0.09335477 -0.24543798 0.79300016 0.7990596 0.3323657 -0.07664999 0.21064356 -0.09841442 0.08130084 0.73415804 0.32708895 -0.12767838 -0.7960771 0.014669142 -0.72018415 0.23543885 0.6822771 0.77690387 0.3183415 -0.9185554 0.47182712 0.33621916 -0.19391079 -0.031083971 -0.47501695 -0.49142218 -0.60843694 0.07083639 0.8141139 0.31480494 -0.8827088 0.16859962 -0.041896246 -0.27500337; -0.49836445 -0.22811809 0.35356376 -0.13557993 0.051334124 -1.0146455 0.49894625 -0.14689313 0.68351513 0.018741172 -0.9231962 0.9120637 -0.7620407 -0.454168 -0.81158704 0.8625158 -0.50294566 0.3056668 -1.054197 -0.36408493 -0.62818384 0.23862278 1.016289 1.1577404 -0.6375163 -0.12956302 -0.37754855 0.06798645 0.53169185 -0.4084999 0.77329165 0.8753449 -0.5922151 -0.5621114 -0.10479775 0.9145562 0.8484873 0.98018306 0.1582648 0.7860247 0.15603562 -0.15720135 -0.030963026 0.20168096 0.37619177 0.28650266 0.085178494 -0.08564166 1.093306 1.104572 0.35075006 0.14263119 0.38593212 -0.2185809 0.11872993 0.8121625 0.5442173 -0.06899613 -1.0753345 0.30563748 -0.97452044 0.57200575 0.6549038 0.9681102 0.40599072 -0.97954386 0.673301 0.25486672 -0.38062796 0.8154619 0.15729927 -0.24676101 -0.92179495 0.20522422 0.7686971 0.48316723 -0.5581844 -0.026624484 -0.41215786 -0.11025106; 0.6054178 -0.562766 -0.11573118 -0.23676771 -0.1875067 0.18787968 -0.6204485 0.8736496 -0.38747263 0.19081171 -0.10372277 -0.51247096 -0.15006472 0.6393227 0.025734665 -0.4059859 -0.124197 0.011828953 0.5432861 0.70983595 -0.96783024 0.8890595 -0.33291438 -0.321919 0.21331088 -0.07428795 0.2842396 -0.9318382 1.1784316 0.16359882 -0.33540347 -0.44468352 0.34326163 -1.2549868 -0.49673754 -0.1526361 0.09175356 -0.234156 -0.9346758 -0.78314734 -0.35235265 0.22897974 0.6914978 0.5930946 -0.68881196 0.14026137 0.88894755 -0.90747625 -0.4047793 -0.5253678 -0.5917064 -0.89021695 0.077763975 0.8927903 0.8698292 1.2658035 0.54688627 -0.9622822 0.20285787 -0.61348027 0.32406887 -0.2365957 -0.28493157 -0.3879551 0.74002224 0.23918214 0.04210238 -0.31282413 -0.5544465 -0.9375942 0.062039223 -0.7945862 0.40791044 -0.70819426 -0.16913271 0.54986197 -1.2079675 0.20370412 -0.21407306 -0.9901307; 0.62410563 0.0011398022 -0.45692402 0.20800191 0.12301995 1.031887 -0.0458812 -0.051942624 -0.7091518 0.36228207 0.9402925 -1.0405538 0.7870963 0.11207999 0.7833841 -1.0190293 0.60180134 -0.42524645 1.0744276 -0.11837099 0.88046855 -0.16237807 -0.93916196 -0.92489564 0.5597492 0.3993219 0.743769 0.18414032 -0.82139325 0.67617834 -0.64698714 -0.79132456 0.67893803 0.7540477 0.33761406 -0.8685067 -0.8631825 -1.1243964 0.13835034 -1.0257523 -0.73371035 -0.21110806 0.7442804 -0.6914713 0.18922995 -0.6113376 -0.06952176 0.27231452 -1.042624 -0.75911444 0.05226952 0.2022056 -0.6942488 -0.2049938 -0.24446264 -0.52710676 -0.49030122 0.035339765 0.8544882 0.29052106 0.8675666 -0.7955407 -0.90842247 -0.944369 -0.34190482 0.94156253 -0.7854297 -0.34287044 -0.0053701526 -0.6991658 -0.41324648 -0.10160233 0.7352917 0.23634546 -0.90551984 -0.5502034 0.8867927 0.6150515 0.48517242 0.14646272; 0.48301417 -0.55907655 -0.4709596 -0.10045052 0.011195341 0.49093395 -0.47752145 0.123541586 -0.39878717 -0.20165206 0.47443962 -0.95151764 0.7105899 0.3145718 0.48011965 -0.47789025 0.10140241 -0.23903216 0.6992251 0.19865926 0.22574887 0.11871282 -0.7845946 -0.6622729 0.53522336 0.10394555 0.7035198 -0.23740599 -0.10546747 0.5479351 -0.40780517 -0.71803045 0.8984192 0.23559503 0.074476965 -0.7239648 -0.4548288 -0.64193094 -0.45387292 -0.8344037 -0.12743014 0.20288415 0.6443265 -0.029045174 -0.161933 -0.37934184 0.2332105 0.17685741 -0.79678243 -0.49970126 -0.2985697 -0.09308388 -0.30077818 0.12827292 0.15620612 -0.031310182 -0.11538734 -0.17556211 0.7876085 -0.16045824 0.6724295 -0.29765803 -0.5235836 -0.6069013 -0.012770738 0.58188653 0.023268634 -0.34231114 -0.53255117 -0.6034298 -0.17247055 -0.24623697 0.5885917 -0.28820047 -0.6203918 -0.21142282 0.49776018 0.222503 0.38265064 -0.53567994; 0.2859212 -0.40972063 -0.4883509 0.10932878 -0.7185663 0.24627976 -0.6953779 0.92370665 -0.47316208 0.6898959 0.48654974 -0.86549413 1.3818493 0.66398805 0.5619714 -0.38316852 0.32058394 -0.48906833 0.8028154 0.8098467 0.29291567 0.8151947 -0.33551213 -0.3421025 0.78803 0.581264 0.67142916 -0.4853112 0.8789007 0.5222017 -0.5705112 -0.4619356 0.7981815 -0.5946393 -0.62212944 -0.26881573 -0.49639213 -0.58765554 -0.5449655 -0.8017467 -0.3961724 0.5687075 0.49472904 0.61968523 -0.80438673 -0.34699276 0.84188575 -1.280461 -0.49783593 -0.27130646 -0.5124125 -0.84144723 -0.113315195 0.79849 0.79316425 0.9286852 -0.14833266 -0.7097008 0.38379154 -0.82586837 0.6178291 -0.50105137 -0.69530094 -0.52636546 0.5344667 0.33347696 -0.60707825 -0.24431106 -0.32307786 -0.62851965 -0.43454188 -1.1247286 0.2513847 -0.83129835 -0.41377693 -0.06643999 -0.10659951 0.5508459 0.38934708 -0.90234596; 0.37167746 -0.76794386 0.037641983 -0.27574953 -0.2501839 -0.18801364 -0.57722926 0.90965724 -0.40211734 0.026546542 -0.3218305 -0.5408387 -0.1116542 0.6783046 0.25181627 -0.20497717 -0.32946536 -0.037279304 0.45813492 0.61063856 -0.75223225 0.668325 0.023490332 -0.28354144 -0.055578597 0.089847684 0.09040215 -0.68139946 0.9788745 -0.12399882 -0.54443884 -0.09067413 0.15394342 -1.1579013 -0.4098216 -0.3296637 0.1654367 0.024636034 -0.73039585 -0.7219028 -0.14330278 0.32877657 0.74166316 0.4564272 -0.79959816 0.35759863 0.894597 -0.6491731 -0.07501378 -0.3301355 -0.7157879 -0.5566816 0.19409111 0.86076987 0.7402469 0.9858325 0.48608312 -0.8904516 0.40585747 -0.46847513 -0.004988918 0.060060352 -0.07019809 -0.35321763 0.6702789 0.21661673 0.21686545 -0.54432964 -0.5772909 -0.8643005 0.06795419 -0.72792137 0.4013329 -0.81318957 -0.078748204 0.44139993 -0.9590807 -0.16283873 -0.27591455 -1.0019071; -0.28051648 -0.27296036 0.8078851 -0.32876056 -0.61061674 -0.9378153 -0.020770224 0.44390225 0.8731664 -0.5096964 -0.7505664 1.1855484 -0.57257855 0.16287735 -0.9238486 0.78339165 -0.68495816 0.65548015 -0.8942055 0.20477574 -0.541709 0.20399784 0.78866786 1.052135 -0.5792017 -0.46171194 -0.7295149 -0.33060655 0.6947128 -0.7547917 0.6497405 1.0977639 -0.88666636 -0.44254008 -0.29241124 1.021459 0.7088031 0.92839175 -0.13744594 1.251075 0.49713272 0.38361448 -0.6114783 0.70091826 -0.38517344 0.49907714 0.43935245 -0.32128018 1.0997412 0.862911 -0.02072741 -0.41715562 0.6950121 0.39049527 0.18596372 0.26472768 0.59788954 -0.42424494 -0.8036774 -0.12872112 -1.0957202 0.79717195 0.8934579 0.6473301 0.5795327 -0.9188142 0.55468047 0.107735604 -0.13133588 0.76141155 0.77975684 0.3681635 -0.9019701 -0.09105407 1.0926383 0.71590686 -0.78835094 -0.6515659 -0.7324331 -0.13787895; 0.46213683 -0.56752 -0.25749233 0.2695406 -0.37376693 0.5993293 -0.826875 1.1008914 -0.46891773 0.5073085 0.63157433 -0.66600555 1.6981091 1.0186187 0.7066021 -0.37059152 -0.017581169 -0.28633463 1.0009402 0.81132597 0.5130914 1.028951 -0.60960114 -0.6521211 0.43888292 0.53483856 0.48357126 -0.911352 0.08372289 0.6526615 -0.50657374 -0.40362552 0.48404515 0.33900604 -0.6657164 -0.53188324 -0.38558534 -0.5541128 -1.1989836 -0.6674974 -0.09423205 0.31358042 0.197049 0.3538814 -1.2037734 -0.40490547 1.0592903 -1.3479128 -0.5981918 -0.6788115 -0.7006637 -1.2428362 0.19028449 1.2307167 1.116022 0.19467062 -0.11425781 -1.1442962 0.40698335 -1.1786981 0.5928788 -0.40042388 -0.61714894 -0.53644663 0.33120093 0.5864306 -1.0475895 -0.40675262 -0.11600016 -0.905677 0.03246704 -1.2233459 0.25890422 -1.1365181 -0.31426862 0.22884226 0.44858557 -0.10539484 0.048770014 -0.9204765; -0.26223108 0.7931313 0.7853248 -0.58992314 -0.8093384 0.7577743 -0.5732751 0.19353381 -0.8002635 -0.569436 0.78267777 0.23926036 0.8039446 0.8130086 0.8759543 0.07685926 -0.64026314 0.76186955 -0.042084005 0.7877069 0.9950895 0.14677064 -0.9521828 -0.70985395 0.3444435 -0.54232335 -0.3232444 -0.2609804 -0.75025225 -0.3142039 0.12371025 -0.45181745 -0.3161844 0.63295084 -0.70348394 -0.066521026 -0.3060085 -0.3350414 -0.79376614 0.6671138 0.60077983 0.4986203 -1.262032 0.4570758 -0.7467869 0.33408114 0.41725522 -0.35147002 0.026316196 0.19011006 -0.3331563 -0.5187665 0.57783633 0.6210059 0.36523134 -0.684638 -0.06677785 -0.23940232 0.40750661 -0.70300674 0.90025 0.59097207 0.35236394 -0.7870807 -0.009048963 0.30296612 -1.2257905 -0.2618462 1.3647205 0.47900224 1.104441 0.1905193 -0.3736908 -0.6200918 -0.22178157 0.38868433 0.82053536 -0.9557188 -0.63275665 0.69338995; -0.42483073 0.070194595 0.3241844 -0.43769988 -0.22459756 -1.0423787 0.29587668 -0.21480826 0.64278686 -0.26656312 -1.0529687 0.84671974 -0.6893499 -0.2828209 -0.8608003 0.8566897 -0.3069043 0.39902228 -1.1284348 -0.41915676 -0.8387204 0.096818 1.1129265 0.7805043 -0.6871405 -0.33330715 -0.6044743 0.35175136 0.5710043 -0.6417927 0.9047254 1.044899 -0.7565576 -0.74159443 -0.08067931 0.7959811 0.9755319 0.9052619 0.19615775 0.77377385 0.39699304 0.10527985 -0.5858707 0.32256332 0.4430632 0.4624731 -0.14201319 -0.09052885 0.72038305 0.6719672 0.52039397 0.23797807 0.5020322 -0.2982648 -0.17462762 0.59930223 0.85293645 0.095329635 -0.7132672 0.15749598 -0.88436407 0.39814675 0.89792305 0.67713714 0.26938102 -0.78794026 0.75920206 0.63232523 0.13557473 0.8507081 0.17911504 0.008340978 -0.71934485 -0.0054451297 0.84361947 0.37768465 -0.8442138 -0.1786576 -0.53250754 -0.044703085; -0.34561443 0.3249501 0.5434445 -0.47000873 -0.040509902 -0.6813261 0.52910626 -0.7326958 0.43062147 -0.4500231 -0.5454454 1.0251561 -1.0575827 -0.48431635 -0.7008313 0.524072 -0.1674409 0.5132245 -0.79859096 -0.6936409 -0.5718517 -0.48120946 0.51657784 0.7541121 -0.46488735 -0.54159236 -0.68305445 0.7234372 0.13667594 -0.5490284 0.53145665 0.47759545 -0.66311544 -0.31664887 0.13975173 0.3812965 0.31608436 0.59962046 0.5177494 0.7284743 0.49845454 -0.041512206 -0.48876178 0.12798937 0.48617974 0.57819784 -0.561044 0.37520477 0.67639244 0.41623938 0.7071186 0.6207564 0.077073455 -0.8325349 -0.55824596 -0.2925317 0.35359246 0.6450527 -0.4024051 0.5985659 -0.7097607 0.42508996 0.55837333 0.7120911 0.058760718 -0.546293 0.5670806 0.36448598 0.30924994 0.86144716 0.20696275 0.77299225 -0.37266085 0.67579764 0.31238845 0.32040182 -0.1710549 -0.3222549 -0.5000747 0.7149674; -0.6444778 0.57007766 0.02687903 -0.44276577 0.33706844 -0.5041075 0.7597958 -1.1769848 0.55204 -0.4425232 -0.39879733 0.77618355 -0.72366524 -1.0411701 -0.6491236 0.55585873 0.060229324 0.12868558 -0.7043241 -1.0356996 -0.4140099 -1.6970453 0.40833923 0.6198266 -0.19693954 -0.67988926 -0.19079205 0.90945774 -0.48180938 -0.43766335 0.32636788 0.52750045 -0.058440797 -0.08268844 0.4688789 0.57205665 0.35578653 0.5656185 0.74738985 0.3839548 0.20466852 -0.1649064 -0.040401917 -0.6481142 0.9563022 0.48889044 -1.0829087 1.5600544 0.32619542 0.33637947 0.8750194 1.0976554 -0.49738264 -1.1388466 -1.4168756 -0.25765258 -0.28582883 1.4270566 -0.32268316 1.1547616 -0.6098409 0.33411655 0.5859023 0.4211371 -0.65004796 -0.40029982 0.5699904 0.37901866 0.10677076 0.9407906 0.022201447 0.49999788 -0.33866084 1.4311614 0.44447035 -0.48408312 -0.105346315 -0.22505821 0.33407313 0.8404961; -0.4550399 0.078707024 0.82219017 -0.33213642 -0.37207705 -0.9130495 -0.02641933 0.06810585 0.6127574 -0.5153852 -0.84799695 0.95342064 -0.94128454 -0.2035082 -0.9438931 0.9862857 -0.66820794 0.44444156 -1.0026652 0.15543492 -0.7892079 0.18415517 0.94379765 0.89051205 -0.6075016 -0.5426788 -0.5939943 0.1620002 0.46181825 -0.87165153 0.5682928 0.7849468 -0.9710956 -0.6983296 -0.43633297 0.9404784 0.9277947 1.1807139 0.15831636 0.91576236 0.53388953 0.20020668 -0.7272795 0.4678698 -0.23621503 0.6974835 0.19201699 -0.36626825 1.1461351 0.88841426 0.02782226 -0.28524622 0.43077284 -0.12050515 0.15209533 0.35040435 0.49815047 -0.2245923 -0.8902465 -0.023424037 -0.92112213 0.49884534 0.6631466 0.69729185 0.43767405 -0.9979354 0.64289874 0.45437106 0.13951614 0.59296334 0.65434057 0.035073422 -0.55790097 -0.10702761 1.013665 0.6894086 -0.8369758 -0.59966713 -0.7442963 0.233276; -0.14100276 0.6343886 0.6903669 -0.10679675 -0.5078823 1.088954 0.08997006 -0.41530272 -0.9265273 -0.4589985 1.3147539 0.44184756 0.628732 0.3152474 1.3322313 -0.6627433 -0.02989246 0.45768866 0.06848677 0.21278474 1.1035271 -0.33071342 -1.0082688 -0.6153888 -0.15117753 -0.34500575 0.22241446 0.09168093 -1.069852 0.22335027 -0.13231537 -0.40665892 -0.18353584 1.1479558 -0.10973067 -0.50460047 -0.9613748 -0.43704283 -0.34503603 0.4429259 0.28599405 0.37188488 -1.2950953 -0.17256925 -0.4078099 -0.24476533 -0.4222706 -0.008497981 -0.34021863 0.07043761 0.07604703 -0.18051885 0.052302163 0.10067318 -0.4308111 -1.4055326 -0.34032977 0.22666423 0.6039872 -0.21209851 1.0879531 0.31118393 -0.01841731 -0.9087081 -0.39084572 0.6793018 -1.7439883 -0.83526576 1.1852956 0.49189046 0.5086356 0.9357569 -0.41407943 0.108502895 -0.6926562 -0.09043379 1.2559329 -0.37459245 -0.013010777 0.95433205; 0.3206486 -0.07890968 -0.45576075 0.48581374 0.49304044 1.0386099 0.15471154 -0.3522236 -0.96906835 0.53296727 0.8299416 -0.8912341 0.77455163 -0.07938546 0.9614343 -1.0896473 0.66135204 -0.7876296 0.9234622 -0.063836224 0.9264579 -0.20053907 -0.788172 -0.8323506 0.3169906 0.6206263 0.7133036 0.12495305 -0.7468718 0.5190142 -0.77858514 -0.89495486 0.8049144 0.63456106 0.4693384 -1.1151354 -0.7760471 -0.8951154 0.2378528 -0.91820383 -0.57504576 -0.32855856 0.84909123 -0.4791723 0.32715073 -0.7703196 -0.19365819 0.17871289 -0.88476837 -0.726153 0.126932 0.14706646 -0.6637426 -0.3454573 -0.22264276 -0.42436972 -0.5728947 0.3610259 0.8452217 0.1424094 1.0839411 -0.778807 -0.7677725 -0.71190304 -0.5717482 0.97761196 -0.8115272 -0.1933521 -0.020805966 -0.9017675 -0.48497152 -0.28676954 0.64014196 0.3666278 -0.99420303 -0.6165098 0.9874009 0.44063115 0.7231983 0.0041960888; 0.6161845 -0.78157717 -0.72254884 0.30311504 0.46028674 -0.5300044 0.4185765 0.11717115 0.70611984 0.3792078 -0.7864704 -0.41630465 -0.64532804 -0.5499578 -0.57993776 0.51620066 0.3591945 -0.31448337 0.46584615 -0.37736323 -0.90660703 0.23900607 0.5661555 0.73050284 0.14518556 0.391883 0.21397069 0.08587192 0.7682107 -0.017814748 -0.1538971 0.53581244 0.39095378 -0.90560955 0.29029804 0.51101965 0.7712676 0.56762755 0.51244473 -0.8363261 -0.44525772 -0.27350825 1.2235901 -0.31298533 0.5015403 0.03293287 0.012090834 0.079668224 0.4336781 0.09938232 0.20896265 0.349143 -0.23191562 -0.4144761 0.3430216 0.93348753 0.23191066 -0.30184266 -0.18553378 0.5155965 -0.82199895 -0.29179853 -0.35554993 0.6426576 0.016491631 -0.5021424 1.1152204 0.31647834 -1.4690493 -0.80056244 -0.6795144 -0.59636503 0.21623547 0.15777916 0.55902493 -0.066728964 -0.64262056 0.49105832 0.62715644 -0.83754766; 0.6575639 -0.5405767 -0.2933544 -0.3028022 -0.18636131 0.105765 -0.8826693 1.0607892 -0.34799543 0.25798646 0.17522469 -0.84972006 0.02863117 0.58584 0.15138943 -0.2680943 -0.31237233 0.11578145 0.6231467 0.8894514 -0.5298751 1.5640771 -0.29067937 -0.39295366 0.22418529 0.23083012 0.23289855 -1.0560257 1.0146257 -0.05081232 -0.4280235 -0.5386361 0.1143953 -0.5653531 -0.3118021 -0.56219316 -0.025035817 -0.4847412 -0.8624087 -0.77785665 -0.091407396 0.09017079 0.7634401 0.9610357 -0.51940626 0.4889336 1.3354391 -1.228907 -0.38498962 -0.45872968 -0.9658247 -1.061647 0.35126358 0.955528 1.2702248 0.896586 0.79626125 -1.208045 0.33576596 -0.6959823 0.32542494 0.073482364 -0.5410876 -0.2630549 1.2959951 0.24040683 0.030400695 -0.26015595 -0.52898556 -0.94972235 0.12088541 -0.46627444 0.36744732 -1.2352993 -0.3870836 0.92556906 -0.5602079 0.04298311 -0.2606015 -0.8251858; -0.39972615 0.71998626 0.31076717 0.004896543 -0.12082688 0.20967248 0.50570345 -1.101466 -0.01249583 -0.3781392 0.40978524 0.6385981 -0.14173369 -0.15486926 -0.001878651 0.30806383 0.04667583 0.16947336 -0.5609473 -0.27552852 0.8867858 -1.1867325 -0.07202947 0.08934699 -0.32077402 -0.3773894 0.050938703 0.6956449 -1.0905133 -0.15806861 0.4470424 0.05599125 -0.27429205 0.9356037 0.18533096 0.1568392 -0.18641108 0.3431757 0.4900995 0.7080177 0.24507299 -0.049850672 -1.0469328 -0.49516636 0.19150567 -0.3803619 -0.93218523 0.95371217 0.25483182 0.45974118 0.47943112 0.63964295 -0.010635085 -0.29132465 -1.1979994 -1.1001205 -0.709823 0.8786615 -0.36702648 0.5034554 -0.028195186 0.26042593 0.27784264 0.0962735 -0.7983389 0.07039789 -0.3307526 0.08918746 0.7047038 1.0671248 0.1928259 0.9897777 -0.4861131 0.5856573 -0.00801823 -0.6334081 0.9116775 -0.4271074 -0.048107836 1.1439; -0.41448835 0.83019245 0.42033064 -0.2880748 -0.5756964 0.67219305 -0.1828096 0.063938886 -0.35275343 -0.54921675 0.69065005 0.29759905 0.6372006 0.24743944 0.70634377 -0.17063232 -0.06541174 0.40247884 -0.39983073 0.22509868 0.84999657 -0.21411766 -0.7010394 -0.65027326 -0.17138998 -0.25588697 0.016767927 -0.06741827 -0.87614846 -0.21100318 0.15612729 -0.413494 -0.31653902 1.0061855 -0.29980543 -0.48120013 -0.7256247 -0.5366285 -0.5633022 0.80054486 0.72800267 0.36499184 -1.0771574 0.2130264 -0.5127245 -0.17421092 -0.12478995 -0.047372997 -0.34236655 -0.054046754 0.058115054 -0.29567227 0.36784232 0.2553368 -0.4032899 -0.81157225 -0.045779556 0.3518348 0.48327792 -0.35085323 0.56331795 0.2640539 0.2617863 -0.5436804 -0.21457098 0.5258931 -1.0459307 -0.4483397 1.23983 0.78102493 0.45122296 0.49217206 -0.47405773 -0.22494096 -0.4603505 -0.18876718 0.61523914 -0.3631414 -0.2470827 0.8594164; 0.5327486 -0.41890892 -0.44673562 -0.031288642 -0.39889717 0.11534725 -0.7431883 0.58642113 -0.2561278 0.040511683 -0.10913174 -0.5911642 0.10033729 0.77837306 0.073511675 -0.3315888 0.1103729 -0.17027465 0.67899173 0.8805753 -0.7055767 0.98157924 -0.085614346 -0.17541644 0.50229067 0.19183862 0.09741268 -0.90194327 1.2447449 0.3209497 -0.4648422 -0.4804449 0.4118472 -1.0554922 -0.43233073 -0.43198973 -0.19425717 -0.15633193 -0.5593701 -0.61025244 -0.11020326 0.40267825 0.7522457 0.46629104 -0.64189416 -0.11816212 0.579334 -0.79190177 -0.3803435 -0.4393176 -0.8729141 -0.90151465 0.23977612 0.6705179 0.7931177 1.2007568 0.054583095 -0.9451095 0.3429749 -0.88726157 0.4287459 -0.39299858 -0.6119602 -0.29819876 0.70977384 0.13405265 -0.10145219 -0.32587826 -0.4613293 -0.7559799 -0.2573708 -0.91169906 0.5646033 -0.68803114 -0.2013936 0.22239263 -0.83232164 0.059425324 0.014803158 -0.9282312; -0.23951338 -0.28063083 0.6301846 -0.44109404 -0.20676629 -0.94909114 0.008039614 0.17507493 0.86334497 -0.3861979 -0.9584706 1.1214145 -0.71349263 -0.06454481 -0.6307653 0.92433786 -0.40618637 0.5200604 -0.93799657 0.081052996 -0.6767567 0.13569337 1.0848646 0.82725716 -0.6150765 -0.39541698 -0.6006924 0.03736014 0.5965554 -0.60080934 0.6693456 0.8661709 -0.8782713 -0.50672126 -0.32915655 0.8640774 0.94708204 1.1189406 0.055219095 1.0396787 0.34844032 0.17038071 -0.6347308 0.5102591 -0.28376308 0.4759224 0.28303108 -0.2951503 1.0629623 0.9317073 -0.101139724 -0.3260543 0.41703102 0.038000915 0.18968494 0.5249193 0.6403716 -0.2660468 -0.9415452 -0.26614192 -1.0297558 0.60382634 0.82071984 0.71872765 0.54019517 -1.0690604 0.5723679 0.33454075 -0.06849083 0.6571405 0.38753933 0.10930506 -0.6903148 -0.25645375 0.9359037 0.563675 -0.62319267 -0.25404388 -0.44213948 -0.21342573; 0.18902159 -0.32528618 -0.102341905 1.270506 -0.12807477 0.3719782 -0.83196396 1.2098016 -0.6982976 1.5485396 0.5027669 0.51322573 0.77392364 0.83447564 0.6839715 -0.33408582 0.6565338 -0.52664655 0.14904344 0.6691792 0.5726784 1.2391928 -0.51586866 -0.69145375 0.13834874 1.5164834 0.13755414 -0.8780287 -0.08232871 0.3818518 -0.2414978 -0.29255158 -0.3381833 0.19306867 0.014014285 -0.49787933 -0.07338948 -0.4262891 -0.92932826 0.72313035 -0.83755755 -0.9841931 -1.4357734 0.42028648 -1.1374319 -1.0669829 0.81572723 -1.2476681 -0.15460153 -0.4657465 -0.7675743 -0.8101839 0.66751575 1.2626648 1.0869856 -0.21602839 -0.08063049 -1.2055228 0.4525865 -1.0159576 0.66728616 -0.81491005 -0.058440167 -0.79060364 -0.19060975 0.16265392 -0.86122 -0.38219455 0.093757436 0.14797671 -0.20888986 -0.2968693 0.17673002 -1.1020606 -0.20001434 0.076663144 -0.06427791 0.6106462 -0.6439177 -0.15136805; 0.26427963 -0.50658494 -0.95338684 0.40941525 0.8695538 -0.76662624 0.23878002 -0.2835373 0.8716034 0.67338145 -0.87153107 -0.50809413 -0.808388 -0.43563005 -1.1731827 0.31604743 0.28667265 -0.7668309 0.36208043 -0.3748762 -1.0156227 -0.048313692 1.0201291 0.44526005 -0.0811784 0.38061053 0.1526171 -0.099056385 0.8227837 0.013330235 0.07458506 0.38409415 0.46094432 -1.0866488 0.6194031 0.16878782 0.64572567 0.32657126 0.741142 -0.8848769 -0.6851516 -0.48071924 1.2814876 -0.27880546 0.7442849 -0.07308619 0.08940892 0.30368266 0.031228853 -0.014828098 0.107426636 0.5101147 -0.5756609 -0.4978116 -0.09675701 1.0074848 -0.16308498 0.23820467 -0.4329378 0.7821403 -1.1567208 -0.3746594 -0.40291306 0.97615707 -0.058590192 -0.6475348 1.7311732 0.8037153 -1.3249011 -0.60275453 -1.061432 -0.8534466 0.37882724 0.42679903 0.63859797 -0.11254487 -1.1396513 0.8374285 0.62048995 -0.95760256; -0.19324557 -0.30405122 0.8359594 -0.48323208 -0.71411884 -0.7437959 0.11722822 0.20911665 0.6032806 -0.44495827 -0.6723248 0.8894752 -0.4226982 0.24947776 -0.5662971 0.87185866 -0.70956 0.752379 -0.7874306 0.15352713 -0.7269721 0.14569584 0.48630998 0.7267302 -0.5883031 -0.45300847 -0.9098364 -0.17979717 0.5991808 -0.57629424 0.67996687 0.8462761 -0.5142285 -0.68710107 -0.6009497 0.8589764 0.75706565 0.76627004 -0.1530439 0.96202594 0.6581646 0.5239297 -0.096580125 0.7591645 -0.40851116 0.49151498 -0.023804853 -0.3551394 0.85619366 0.78659225 -0.20941599 -0.38176206 0.48986492 0.284685 0.14755863 0.36564556 0.5966521 -0.20264001 -1.0981796 -0.5289191 -0.54506296 0.49398613 0.81550914 0.73652834 0.7129993 -0.78184897 0.45790726 0.15944766 -0.34402028 0.44387752 0.58383363 0.20326084 -0.6158958 -0.21051858 0.8038242 0.48687288 -0.53291476 -0.56350595 -0.6895439 -0.22211759; -0.4736218 0.4259632 0.6916496 -0.6390033 -0.9206555 -0.050233718 0.377239 -0.3612163 0.26756224 -0.73418665 0.07325183 0.6052486 -0.10983766 -0.0031142188 -0.12779927 0.42388615 -0.5986899 0.8677888 -0.54008895 -0.092645854 0.72585565 -0.31303784 0.2795147 0.34885564 -0.7105338 -0.7928917 -0.4043908 0.4206905 -1.0314941 -0.75538105 0.41732284 0.18773985 -0.8629273 1.055667 -0.72797835 0.18189083 0.06766458 0.19244431 0.1652843 0.8811116 0.805208 0.30570906 -0.9618606 0.4902847 -0.046312835 0.32627943 -0.37336913 -0.1329958 0.2552714 0.4496057 0.34945726 0.09832955 0.9420275 0.046033066 -0.50742507 -1.1142073 0.14041613 0.17151064 -0.48946646 0.07205192 -0.31643763 0.6332703 0.6744693 0.025382534 -0.023792664 -0.3208117 -0.25083098 0.14585221 0.6154394 0.9186375 0.9678996 0.8753815 -0.34212074 0.08713129 0.37788677 0.24051523 1.1068778 -0.87788707 -0.7338063 1.0624142; -0.15041482 0.29589602 1.1091831 -0.78171724 -0.9665966 0.16252764 -0.30120614 0.18498622 -0.30927435 -0.9168184 0.67836356 0.64950013 -0.5879471 0.51454026 0.68593687 -0.015827164 -1.1318293 1.0090132 -0.5873648 0.61616755 0.8432939 -0.08898616 -0.28338653 0.07034174 -0.6967805 -0.7951726 -0.6282496 0.028060999 -0.65253437 -0.7262817 0.26383817 0.07080711 -0.8242662 0.9027911 -1.1007816 -0.02700706 -0.4660825 0.18874131 -0.5407343 0.51511 0.8607886 0.75934947 -0.8828128 0.6448125 -0.9184895 0.8152205 0.08490392 -0.712481 -0.043457616 0.15030237 -0.12317077 -0.7965804 1.104513 0.4948426 0.17250764 -0.857189 0.60078543 0.01748268 -0.18272653 -0.79808533 0.2750465 1.1255575 0.80246854 -0.3929063 0.5972227 0.0032414543 -0.7678842 -0.41306996 0.66683537 0.674018 0.9538893 0.7662267 -0.19890651 -0.38325927 0.08893597 0.9345438 0.61207813 -1.0152298 -1.1869352 0.8582477; 0.33499262 -0.58103997 -0.7527168 0.26397437 0.74575496 -0.75320774 0.1350546 0.13219072 0.5384579 0.7153436 -1.117027 -0.757925 -0.7423118 -0.55437714 -1.096153 0.24115878 0.57662416 -0.59654963 0.25403088 -0.5141323 -1.2269616 0.07563676 0.9418341 0.6028148 0.26449692 0.5229195 0.3485444 0.17515194 1.2250183 0.1323768 0.14361884 0.41672924 0.74191993 -1.1666178 0.5730185 0.30286717 0.55411726 0.3928659 0.5866437 -0.8421899 -0.7216511 -0.38035715 1.2962646 -0.12010035 0.71734667 0.18441293 -0.13586889 0.50394505 0.30896515 -0.08643299 0.26685297 0.545568 -0.45393836 -0.71133775 -0.0457282 1.182263 0.16028652 0.11519615 -0.15595683 0.5437334 -0.8065307 -0.68150693 -0.5050246 0.6053645 0.049005542 -0.51802313 1.6922972 0.49901998 -0.87559044 -0.86960864 -0.77725554 -0.8915244 0.18972568 0.46611995 0.52464354 -0.30271107 -0.9921841 0.753035 0.8076514 -1.204678; -0.25971508 -0.09877258 0.30696192 -0.35823002 -0.31889284 -0.8263506 0.042041425 0.30177 1.1966027 -0.45985717 -1.0282322 0.77852184 -0.6172339 -0.102263264 -1.0008633 0.8620325 -0.28601015 0.47706252 -0.8471594 0.1799105 -0.67541695 0.35359842 1.0680493 1.0513757 -0.2834771 -0.31201535 -0.47069934 -0.28143796 0.8580554 -0.7197409 0.954017 0.8823888 -0.338278 -0.7804046 -0.20148696 1.0773884 0.73787427 1.0421971 -0.11771223 0.8701578 0.49846426 0.13584088 0.11694761 0.56089854 0.04753704 0.3154556 0.34781203 -0.17763464 1.0859522 1.1176414 -0.09464394 -0.07979258 0.37248388 0.17166758 0.2257943 0.6574255 0.56056005 -0.2887396 -1.1442273 0.08694556 -0.8520736 0.44343615 0.8187905 1.0797989 0.4681013 -1.0635622 0.9255248 0.28357702 -0.32498667 0.92909443 0.27205354 0.0044816923 -0.89558935 -0.25211146 1.0483135 0.44201458 -0.8939263 -0.29133692 -0.53284603 -0.38212225; 0.41251525 -0.37947726 -0.38036248 0.56333166 0.29203898 -0.2199125 -0.1941886 0.5291097 -0.27653268 0.6277617 -0.32788777 -0.28081337 0.2392106 -0.20939338 -0.15208316 -0.16594642 0.19295262 -0.41620144 0.55617136 0.057035737 -0.7061433 1.0080947 0.09246406 -0.14384174 0.3734517 0.8620287 0.22865522 -0.39320624 0.66081834 0.061705813 -0.5172125 -0.20726392 0.05260238 -0.5097464 0.4633407 0.028089482 0.3659859 -0.15090914 -0.10172331 -0.15441433 -0.5230919 -0.53846 0.35334334 0.18063311 0.27006492 -0.07620061 0.59196895 -0.69858664 0.10465531 -0.39557263 -0.38275567 -0.08004316 -0.072268635 0.23270859 0.90753996 0.7211939 0.24447475 -0.73711306 0.26801905 -0.13519496 -0.18774779 -0.38233083 -0.30766597 -0.23231922 0.28047088 -0.25588977 0.20782502 -0.16507521 -0.53735137 -0.798081 -0.39995626 -0.5583699 0.42282468 -0.569816 0.3433122 0.28470427 -0.76186734 0.63013434 0.051815573 -0.63584715; 0.35513386 -0.7492606 -0.8952319 0.4608015 0.86444974 -0.85773605 0.22641702 -0.29882303 1.0021712 0.6528114 -0.8375509 -0.4417886 -0.6557013 -0.77022743 -0.93142694 0.38499403 0.4990424 -0.8240428 0.38730082 -0.61172706 -1.2106267 -0.025844837 1.1155951 0.42378372 -0.068596564 0.4401312 0.31914932 0.14693807 0.91662174 0.22262067 -0.04244699 0.27959797 0.24033645 -1.17127 0.648411 0.103362635 0.5424155 0.4445322 0.55556494 -0.61604184 -0.6451745 -0.36808407 1.4589316 -0.33372346 0.82856995 -0.07075687 -0.014504936 0.36618894 0.40002376 -0.122275755 0.51722294 0.558984 -0.5471493 -0.7997048 -0.10463589 1.1253954 -0.21557319 0.25529823 -0.18454492 0.6672821 -1.2232603 -0.4730072 -0.44508588 0.91722375 0.15436941 -0.7496803 1.4362943 0.4951525 -1.459235 -0.7012621 -0.8208297 -0.66509575 0.16800119 0.5697255 0.568993 -0.2194366 -0.8793723 0.9052287 0.6591775 -0.9600566; -0.5702332 0.55398124 0.23988542 0.19401799 0.4967718 -0.5504059 0.8762169 -1.0956429 0.49577656 -0.23171943 -0.3569363 0.8241661 -1.1858714 -0.9851581 -0.61757267 0.27529138 0.19564083 -0.13133822 -0.70935667 -0.8329682 -0.17677435 -1.5405493 0.3743825 0.42370448 -0.3561322 -0.6178487 -0.24555425 0.99590975 -0.4264703 -0.47921547 0.62810427 0.5325812 0.01714812 0.33145434 0.62638915 0.56096643 0.11538395 0.59925276 1.0392189 0.5012269 -0.011379731 -0.39366394 -0.4789364 -0.6403897 1.1391767 0.19543901 -1.1154354 1.5615966 0.48141715 0.63472587 0.8636343 1.323459 -0.6304514 -1.122388 -1.5222251 -0.6051206 -0.445697 1.1669109 -0.47791943 1.1792252 -0.6457619 0.084524825 0.3448405 0.5374656 -1.0148909 -0.47898766 0.7029585 0.573856 0.17013282 1.0932633 -0.19917293 0.4919646 -0.4886402 1.2084981 0.49986246 -0.61325914 0.204408 -0.068406805 0.07322365 1.0531479; 0.2712723 -0.7181287 -0.35282564 0.42699647 0.3269313 -0.8638267 0.2529802 0.112490326 0.767617 0.32558396 -1.0304695 -0.4654612 -0.5613641 -0.2768327 -0.8552995 0.3388938 0.29754058 -0.32733017 0.21008241 -0.08695002 -0.885681 0.51768 0.8022569 0.36135027 -0.0056335293 0.39603516 0.10620156 -0.41639608 0.9902071 -0.018109012 0.054466896 0.36700702 0.06949696 -0.8854318 0.44417664 0.22444938 0.90565044 0.47295848 0.077798374 -0.39116716 -0.7064002 -0.3286124 0.8348234 0.19443248 0.23872486 0.241889 0.28976685 -0.19438456 0.45365813 0.14612663 -0.16197212 0.004960575 0.042497847 -0.09756619 0.22498842 0.9583236 0.14552218 -0.564145 -0.48720872 0.12937944 -0.672821 -0.456059 -0.19705978 0.5245037 0.31339133 -0.76075006 1.0900931 0.4861352 -0.91678673 -0.8284721 -0.42361334 -0.8193229 0.2737945 0.10936802 0.73451316 0.28979516 -1.1621844 0.3467623 0.19419761 -1.1015869; -0.2646413 0.45113856 0.8688713 -0.3444508 -0.46904236 -0.028803483 0.51092243 -0.5115407 0.08634047 -0.5387435 0.072331086 0.7273862 0.025853042 -0.2956462 0.0022674608 0.18495052 -0.358284 0.51789314 -0.4580715 -0.47342095 1.0283952 -0.7264057 0.12849972 0.11587696 -0.324874 -0.3969223 -0.28313264 0.44926625 -0.9569329 -0.5115277 0.5069987 0.12645368 -0.5319357 1.0792904 -0.11848735 0.3655876 -0.11826125 0.20774443 0.32832193 0.8268757 0.61591774 0.24351318 -1.1527599 -0.13227725 -0.083420426 0.27480572 -0.5466467 0.41783682 0.33228713 0.41042614 0.61985874 0.45262185 0.24578077 -0.35219234 -0.5794554 -1.325666 0.09509396 0.59904706 -0.30279696 -0.0054050377 -0.0531122 0.47671404 0.62839645 -0.009656489 -0.4100339 -0.095871165 -0.33329165 0.18884498 0.5509851 0.7028144 0.60904986 1.0355346 -0.5916102 0.34293818 0.25770453 0.04672993 0.8707863 -0.55184007 -0.6270964 0.8830988; 0.56219935 -0.29620397 -0.32737216 0.58688635 0.21202089 0.18289682 -0.72571594 0.7513855 -0.22432691 0.8133618 -0.003203956 -0.640879 1.8215581 0.5553163 0.22666965 -0.35317245 0.2310128 -0.4123482 0.9104943 0.42267007 -0.2913568 0.72178346 -0.36566904 -0.26602113 1.4652265 0.77630645 0.3728026 -0.5218542 0.8508007 0.5031592 -0.31990615 -0.5984155 1.1012716 -0.64450926 0.22738333 -0.22446205 0.017379856 -0.37031195 -0.58348054 -0.6828851 -0.59412354 -0.35345006 0.5372353 0.19257674 -0.60783345 -0.43979964 0.7051777 -1.0155789 -0.2753523 -0.26204827 -0.6271522 -0.57423806 0.02030559 0.67751914 0.9973798 0.7551441 -0.13198315 -0.74112535 0.5006987 -0.45253587 0.38440028 -0.6074243 -0.7024514 -0.1807772 0.16613062 0.3667269 -0.3959409 0.07732052 0.16445361 -1.0913866 -0.22097519 -1.5143799 0.3834214 -0.5935162 -0.4323245 0.18978086 -0.570684 0.4446314 0.035666108 -0.9213891; 0.2970716 0.39293426 -0.44677788 0.33213452 0.1706242 0.9054135 0.14510013 -0.34072334 -1.0208808 0.38117385 0.7997798 -1.0183516 0.8282768 0.028051034 1.0101811 -1.027961 0.64297706 -0.31837964 1.1416771 -0.07946785 0.91846824 -0.23428959 -0.9650104 -1.1936401 0.535301 0.5242501 0.6421141 0.18297079 -0.5859482 0.6488621 -0.88088244 -0.948628 0.9493623 0.81458485 0.3980725 -0.942428 -1.049272 -1.0197797 0.19843444 -0.900651 -0.54791415 -0.37726513 0.656107 -0.3569138 0.08503512 -0.6597264 -0.13988702 0.22258791 -1.1511575 -0.9134804 -0.002282636 0.029829478 -0.5190052 -0.2419929 -0.16951975 -0.65382487 -0.5397222 0.02658492 1.0005381 0.3400843 0.91463387 -0.47945273 -0.89276713 -0.96618134 -0.47164345 1.1808636 -0.8738541 -0.34742165 0.3046628 -0.7049703 -0.474056 0.19229345 0.91171706 0.18731607 -1.1725703 -0.32698599 0.87384593 0.43868473 0.72401154 0.06410069; -0.26485443 0.5228644 0.85748225 -0.5788036 -0.6356584 0.3800753 0.049107954 -0.22579741 -0.05608337 -0.5865664 0.30635464 0.978246 0.39777637 0.17746109 0.48509696 -0.04580939 -0.8652 0.60015553 -0.87718594 0.29644948 0.6261692 -0.2275864 -0.185639 0.16614135 -0.56256235 -0.46301025 -0.65005904 0.011361353 -0.83464545 -0.5904051 0.23554474 0.28570503 -0.74784225 0.85789967 -0.51781046 0.03439633 -0.30646598 0.29178467 -0.4374993 0.7865182 0.9079761 0.6967179 -1.2081987 0.70249385 -0.40095392 0.51543033 0.0010132999 -0.30028433 -0.018394599 0.48345548 0.024162903 -0.26877224 1.0854232 0.3167608 -0.27127746 -0.66569716 0.4655742 0.09343773 -0.18748327 -0.5859208 0.43146947 0.7159068 0.9365124 0.02083566 0.2676742 -0.023761954 -0.8592766 -0.32209605 0.8874836 0.7739216 0.6904981 0.64073193 -0.46964297 -0.17438346 0.028138122 0.753758 0.66101193 -0.6367779 -1.0416574 0.7254089; 0.44287246 0.41017985 -0.3987584 0.071492165 -0.019559257 1.2133714 0.015852971 -0.09084655 -1.0319538 0.022554113 1.034269 -0.9301741 0.47646052 0.11851813 1.1912453 -0.9853782 0.42430902 -0.25034696 0.8183796 0.16487713 0.81149095 -0.2412719 -1.3245937 -1.2920554 0.44760504 0.41368797 0.62149066 -0.051212445 -0.6328805 0.7795041 -0.8110928 -1.2837994 0.5877943 0.73324263 0.17292939 -1.1620194 -1.0117258 -1.1057962 -0.068867065 -0.93462193 -0.14729887 -0.103804395 0.075170875 -0.37586436 -0.2656257 -0.34407756 -0.02978087 0.14898944 -1.1682727 -1.339434 0.01989791 -0.022812357 -0.4914641 -0.07595625 -0.105110325 -0.8766841 -0.43005767 0.24331908 1.042626 0.115389675 1.119562 -0.44585383 -0.79611605 -1.1393045 -0.29338783 1.1388174 -0.98468465 -0.34119257 0.45615086 -0.751047 0.056460537 0.3513812 0.73471195 0.056107312 -1.1924875 -0.58836186 1.0588086 0.2819745 0.5649988 0.5383273; -0.33466357 0.026991803 0.6698582 -0.5763751 -0.3431107 -0.5354846 0.3696004 -0.08055072 0.23708913 -1.0066721 -0.14528635 1.0975269 -1.1288363 0.04078146 -0.2163627 0.47600543 -0.69606626 0.8518335 -1.0279272 -0.15915099 0.21590541 0.0611243 0.31562373 0.37908667 -1.2275497 -0.8971905 -0.6204299 0.13651262 -0.4998052 -0.7665002 0.4774463 0.4807283 -1.0362202 0.31730843 -0.59510684 0.36734733 0.43836382 0.593063 0.21108055 0.9290854 0.7131154 0.7620183 -0.71032614 0.44004607 -0.18950856 0.7633256 -0.29648572 0.08703007 0.6170446 0.5835303 0.21807884 -0.16493575 0.442002 -0.20439103 -0.23541619 -0.6600708 0.40221387 0.20030285 -0.34418854 0.110180035 -0.6092534 0.7727205 0.64245635 0.20201105 0.35021925 -0.5193819 0.3181188 0.15581943 0.01232865 0.8785796 0.64321375 1.1322136 -0.31023744 0.041848008 0.48045477 0.41972685 0.2810432 -0.6687896 -0.4910194 0.9693178; 0.7431884 -0.28984576 -0.39293227 0.24064976 0.05374646 0.92898077 -0.56086123 0.016128665 -0.7504163 0.38315904 0.8283337 -0.8493787 0.8222608 0.46574536 0.7488979 -0.7601738 0.22983976 -0.42621118 0.9680245 0.4199884 0.83128226 0.1981736 -1.0922987 -0.8197243 0.50518316 0.30032098 0.4746763 -0.14061989 -0.6700057 0.54438335 -0.56924367 -1.0730665 0.48204514 0.5070673 0.06746787 -0.9889386 -0.60084593 -0.90425 -0.3182362 -0.69354945 -0.51424015 0.047231726 0.60008466 -0.2287482 -0.50623137 -0.63018095 0.008758761 -0.022035686 -0.8981295 -0.7251273 -0.5847161 -0.32303834 -0.4412915 0.29406154 -0.013795487 -0.4507409 -0.46050218 -0.16187869 0.71445596 -0.28428617 0.86679226 -0.4436689 -0.5544838 -0.8193337 -0.1391618 0.821286 -0.99528855 -0.41742486 0.08876687 -0.89613676 -0.15113789 -0.010160995 0.6094655 -0.23319714 -0.79502714 -0.23737729 0.83508176 0.21992387 0.5211719 -0.14328577; 0.36714134 -0.5671799 0.22043887 -0.10685241 -0.71302027 0.51164556 -0.9744059 1.266979 -0.8303389 0.18958151 0.5334571 -0.83134496 1.7552675 1.1872008 0.49429876 -0.28875113 -0.11271828 -0.04037098 0.70489323 1.297535 0.503767 1.4136387 -0.8471569 -0.7823178 0.5464235 0.5925368 0.09982179 -1.2723789 0.24640067 0.22719464 -0.6329655 -0.5259121 0.39025584 0.21573606 -0.62292725 -0.4754439 -0.16827895 -0.36619467 -1.1053137 -0.4682851 -0.09597489 0.5152906 -0.18336974 0.75593466 -1.395258 -0.109072305 1.4005473 -1.5262525 -0.3648155 -0.3645476 -1.1852853 -1.3135148 0.47116593 1.4869164 1.2556258 0.43548182 0.09486066 -1.4442753 0.5591354 -1.3509614 0.5496898 -0.23999679 -0.42108062 -0.6063038 0.47371718 0.6291428 -1.0127351 -0.47311547 -0.09652128 -0.85763264 0.21918397 -1.0245632 0.4331675 -1.2937828 -0.3003676 0.44312355 0.18783875 -0.23820274 -0.617326 -0.74703646; -0.496422 0.7045795 0.8311652 -0.7536452 -1.0647762 0.2604484 -0.30628902 0.12241847 -0.2699071 -0.8429552 0.43465737 0.3014531 0.3116344 0.6801409 0.5007372 0.28639022 -0.62144727 0.5947483 -0.17687821 0.6188874 0.7601808 0.1568554 -0.66675836 -0.40178993 -0.04405479 -0.46495435 -0.37650597 -0.35977337 -0.6683581 -0.31543717 0.6164731 0.0150956055 -0.02907305 0.4503233 -0.59282905 -0.09449391 0.06269937 -0.09770229 -0.6992053 0.55305165 0.9007722 0.52612334 -0.7104641 0.24780612 -0.7349529 0.32945004 0.21434207 -0.41266698 0.2964488 0.24605635 -0.53342706 -0.6744716 0.542284 0.6133685 0.16670728 -0.74149257 -0.028453926 -0.043738768 -0.0029734746 -0.756695 0.5370413 0.6191378 0.48869622 -0.3319521 0.22620615 0.24235445 -0.87550616 0.105956815 1.3632051 0.15251239 0.92863697 0.27879864 -0.40991607 -0.48916018 0.082489945 0.42989853 0.58277255 -0.77809584 -0.88881177 0.37093577; -0.6791867 0.71239316 0.59053135 -0.6034993 -0.63748384 0.38865775 -0.13459286 0.1289136 -0.32243323 -0.47455418 0.3263198 0.4949288 0.3786649 0.49976796 0.3010669 -0.019513013 -0.6844177 0.7199373 -0.53169 0.40633687 0.73152256 0.1463289 -0.22531264 -0.26658654 -0.2902394 -0.5322075 -0.7094844 -0.054897767 -0.61499953 -0.6582379 0.35861996 0.060065776 -0.48808122 0.5515872 -0.47068074 -0.16293983 -0.12908022 -0.18177496 -0.46946806 0.6535564 0.55489445 0.683539 -0.946251 0.42912772 -0.40369043 0.18040226 0.10002394 -0.3220097 0.044899214 0.18914266 -0.12838328 -0.49577123 0.6913761 0.6336203 0.05161213 -0.85880375 0.07365407 0.07721473 0.051544994 -0.49908555 0.40259308 0.7856598 0.79741406 -0.42123294 0.18566288 0.13199326 -0.7580338 -0.25708878 1.4697436 0.66774213 0.5021874 0.63273376 -0.37500075 -0.57321846 -0.39692867 0.21374494 0.6462972 -0.45978013 -0.72146297 0.670455; 0.42425066 -0.45551133 -0.7931534 0.28351176 0.44465184 -0.018205144 -0.3566628 0.3281435 -0.1609628 0.63762236 0.01767947 -0.9822641 0.6225155 0.3730933 -0.051683515 -0.3271548 0.2534028 -0.77640665 0.8363852 0.22366984 -0.8688518 0.40677592 -0.32440937 -0.26662037 0.74447644 0.372275 0.4963039 -0.36980122 0.96731234 0.48891795 -0.20844713 -0.25790912 0.7443789 -1.1695763 0.15551741 -0.48777372 0.031211574 -0.2425007 -0.14329979 -0.7113277 -0.7694307 -0.3901307 0.80523217 0.079221316 -0.09874099 -0.2132975 0.6996137 -0.17787303 -0.30965504 -0.35480797 -0.6228632 -0.51484895 -0.25413817 0.15342651 0.71011883 1.2182544 0.08220976 -0.5786394 0.26513103 -0.073223494 0.27941793 -0.7469863 -0.65066 -0.37563935 0.38059697 0.43254533 0.5376501 -0.1962731 -0.3347077 -0.7476513 -0.6421773 -0.8122603 0.4153247 -0.35696888 -0.32503697 0.0002444149 -1.0809501 0.6981012 0.42112035 -0.9041336; 0.5506309 -0.2198751 -0.2852362 -0.17400189 -0.10148151 0.6674736 -0.5203004 0.26242298 -0.61428785 -0.04054718 0.7975202 -1.0220279 0.76359206 0.32689306 0.79944307 -0.9405202 0.17289749 -0.27410844 1.1039208 0.22117159 0.65722024 -0.034750123 -0.722926 -0.7396571 0.48768348 0.04176841 0.5363636 -0.12850672 -0.5498119 0.48145357 -0.5170121 -0.7123006 0.5754281 0.30943143 -0.096485466 -0.89030015 -0.55540496 -0.95575154 -0.4486375 -0.9765787 0.07851214 0.06234032 0.6261904 -0.34046993 -0.45961663 -0.49147913 0.18926814 -0.15985663 -0.8479087 -0.87457013 -0.28813475 -0.2588117 -0.39081025 0.30513373 0.13267455 -0.32256734 -0.24417014 0.04174081 0.8507368 -0.14243509 0.8392476 -0.2429632 -0.64846736 -0.5657722 -0.10115878 0.9650374 -0.66236895 -0.46788692 0.0855626 -0.6635001 0.20108818 0.14865707 0.7336482 -0.20047489 -0.9999667 -0.30139926 0.6735855 0.036641605 0.4391232 -0.06822107; -0.70410645 0.5232696 0.093147874 0.65092087 0.31786406 -0.4023953 0.69883054 -0.2902958 0.19316763 0.7113816 -0.11036733 1.0898097 -0.18350184 -0.72120726 -0.2831155 0.6703094 0.3121491 -0.23601723 -1.1152763 -0.63166714 0.06927328 -0.20799805 0.6369039 0.37449113 -0.23645063 0.62255454 -0.3815642 0.41816175 0.039641496 -0.22764875 0.29592258 0.5599656 -0.40339556 0.118219554 0.49279046 0.8100339 0.54235625 0.7332574 0.7426921 1.1486149 -0.15644856 -0.71109027 -0.688863 -0.05422928 0.5469893 -0.3272787 -0.53746945 0.20196642 0.79016775 0.7733817 0.6679675 0.34709206 0.21560697 -0.49395433 -0.34976527 -0.30615023 -0.20326817 0.27939275 -0.544324 0.55967426 -0.4786427 -0.14783949 0.5840425 0.1406931 -0.2940945 -0.5068389 -0.21931905 0.2569512 0.5687351 0.6849554 -0.15554233 0.20020925 -0.7856344 0.56448185 0.5865407 0.048232388 -0.08316207 0.31812263 -0.36678097 0.56889945; 0.5588953 -0.61005557 -1.3136747 0.70568377 1.240002 -0.016793683 0.18668544 -0.108596295 0.19691052 0.88716865 -0.5189627 -0.71917856 -0.12419023 -0.358297 -0.59785736 -0.38294294 0.85522866 -0.95267045 0.6873872 -0.43902695 -1.1734064 -0.11523927 0.23866922 0.10674245 0.48856375 0.819246 0.56978863 0.17959256 0.91946864 0.6481651 -0.34054458 -0.31954545 0.8271241 -1.0954804 0.7643278 -0.17530076 0.19553047 -0.118580125 0.5669639 -1.007225 -1.0115882 -0.73155826 1.1867776 -0.71045035 0.7917219 -0.2960396 -0.118850306 0.74344695 -0.23270257 -0.33086678 0.20594506 0.5793178 -1.3371494 -0.71422166 -0.16452938 0.9098905 -0.3353867 -0.047643457 0.023265503 0.8343684 -0.2495077 -0.9472574 -0.9346909 0.12308864 -0.31154805 -0.06891322 1.5496868 0.33624232 -0.9401773 -0.52304995 -1.1545614 -0.6418857 0.28857535 0.46784878 -0.20549157 -0.6536685 -0.72984403 0.95431596 1.3303392 -0.84182036; -0.66173667 0.5918152 -0.033765446 -0.24509661 0.4911558 -0.58879495 0.95311713 -1.4491198 0.8089413 -0.31161907 -0.59646165 0.59612525 -1.2729182 -1.2689317 -0.6986564 0.25602844 0.006099104 -0.1666684 -0.6366874 -1.0291691 -0.3621136 -1.3909603 0.48852825 0.73134434 -0.306253 -0.7243735 -0.21613176 1.2824855 0.04242995 -0.31090385 0.6295771 0.5315428 0.05948185 -0.38672224 0.56551653 0.26014 0.14954771 0.6140619 1.3540412 0.17659293 0.095204316 -0.34678513 0.26437792 -0.85202307 1.1885285 0.3537025 -1.2182862 1.5405743 0.51563096 0.43491265 1.0071105 1.3776474 -0.4378964 -1.0841656 -1.4546117 -0.078401856 -0.079866536 1.3435895 -0.51415676 1.4281899 -0.6325099 0.47855812 0.2756369 0.47571614 -0.71387917 -0.46316883 0.9643412 0.36294544 0.14102995 1.0236768 -0.17633262 0.61894506 -0.5086499 1.4518043 0.21647139 -0.4893718 -0.008441732 0.24812071 0.38548607 0.8610983; -0.64396 0.34373453 0.49707645 -0.29811493 0.32676795 -0.3634547 0.6944592 -0.98019993 0.39714444 -0.46988893 -0.3157608 1.0644126 -1.4001228 -0.7747919 -0.4551104 0.37872782 -0.01238858 0.30814263 -0.88757724 -0.89084667 -0.04664343 -0.99390256 0.5473767 0.47101232 -1.039789 -0.4939787 -0.49620247 0.7771615 -0.85711485 -0.5421696 0.4818261 0.5053089 -0.8341597 0.58792424 0.14157492 0.3726714 0.21187729 0.30404863 0.94221884 0.94403005 0.40956923 -0.16496223 -0.5437927 -0.18086708 0.9235112 0.28358164 -0.7561939 1.2263122 0.46173406 0.40228453 0.73571455 0.92504215 -0.051550336 -0.85989296 -0.9782776 -0.6650212 -0.021798074 0.9894593 -0.35473543 0.8768611 -0.49836388 0.59985554 0.5487925 0.6400853 -0.6294059 -0.45854643 0.5835485 0.19616173 0.36654183 0.9272187 0.29606304 0.97490984 -0.54763633 1.0848323 0.33449686 -0.2350496 0.24868785 -0.33519527 -0.16064176 0.96816444; -0.4921231 -0.17618091 0.71909237 -0.5638664 -0.4683483 -0.76770824 0.08256486 0.47902957 0.60511845 -0.4233159 -0.66475165 1.0879979 -0.8735098 0.23216383 -0.6542716 0.98187965 -0.56632316 0.69288164 -1.0936427 0.3024131 -0.61126214 0.46378556 1.1114694 0.77360195 -0.7051961 -0.71189123 -0.7400088 -0.2916706 0.5483322 -0.6566366 0.5757416 1.1234617 -0.65173006 -0.82033885 -0.48523107 0.9042852 0.9062552 0.9358999 -0.33338743 1.0111933 0.6547545 0.21115993 -0.88482577 0.5018904 -0.17814854 0.45086542 0.28713644 -0.39059088 1.1426382 0.83420867 -0.0040929266 -0.50515705 0.7071013 0.11013088 0.49165758 0.54074866 0.556948 -0.40887114 -0.91316944 -0.44414377 -0.81465185 0.78906345 0.6608878 0.8040103 0.46077025 -1.1561811 0.49909526 0.2684419 -0.24141677 0.59957373 0.48255208 0.29666865 -0.850955 -0.3085526 1.1317035 0.7460246 -0.8521057 -0.7640559 -0.6485425 0.15600859; 0.30911028 -0.52831036 -0.49596232 0.33572534 0.09249331 -0.24553211 -0.5858214 0.62185776 -0.20926052 0.47024047 -0.6161332 -0.7228851 0.057235703 0.35699266 -0.131483 0.12821648 -0.191593 -0.20783436 0.7193272 0.20204715 -0.98659027 0.9069872 0.02236009 0.11673793 0.5081823 0.3079522 -0.053827487 -0.70625424 1.1428797 -0.094136775 -0.27197507 -0.29260203 0.6914696 -0.94165057 -0.05575519 -0.16916549 0.56102 -0.064773075 -0.34739503 -0.85621995 -0.40523297 -0.23424642 1.0609747 0.5884591 -0.19213639 0.273886 0.80220366 -0.7592644 -0.18566747 -0.46017998 -0.46798143 -0.53054607 -0.017482212 0.31160435 0.78221095 1.1172899 0.5545497 -0.82963324 0.07570268 -0.42156938 -0.09412486 -0.25051525 -0.32455105 0.20740165 0.7591145 -0.017423175 0.5446727 0.23785336 -0.7005426 -0.7207024 -0.34721464 -0.96485424 0.30353203 -0.6852345 0.2825412 0.4711389 -0.94680494 0.295866 0.07816027 -1.0607079; -0.463985 0.110367976 -0.64524704 0.5156443 0.6055499 -0.7020161 0.79556304 -0.38370845 0.34167776 0.6372749 -0.6752757 0.27478075 -0.49530062 -0.82399386 -0.6143629 0.6480151 0.3586335 -0.3973205 -0.74352705 -0.82287866 -0.5295488 -0.2632332 0.7036655 0.7665465 -0.29349044 0.41812488 -0.07560006 0.7143429 0.52915555 -0.22529212 0.16381158 0.7211332 -0.33830595 -0.27244136 0.44438946 0.7179205 0.5578232 0.9117425 0.59481883 0.18839993 -0.5649417 -0.40531814 0.014910498 -0.4599155 0.6855928 -0.22550027 -0.58442295 0.25029796 0.59039426 0.53472996 0.8711576 0.38335395 -0.32396764 -0.5097098 -0.25704706 0.41912684 0.044727687 0.42838365 -0.7983736 0.5771675 -0.70351005 -0.37893218 0.1002526 0.669766 -0.22636461 -0.5065197 0.48743206 0.28989413 -0.37902477 0.29868305 -0.4370259 -0.2891511 -0.6772046 0.48091242 0.6619223 -0.080519386 -0.30919096 0.38887674 0.25120404 -0.30296138; 0.32363006 -0.5208042 -0.79470354 0.5588826 0.4547541 -0.036853585 -0.26393342 0.5018096 -0.118556246 0.61777747 -0.22674622 -0.89301574 0.3298014 0.037560247 0.18812406 -0.45692417 0.46714178 -0.7377352 0.70520437 0.12484832 -0.91163474 0.36806262 -0.3336626 -0.42661387 0.9627127 0.6261885 0.6597074 -0.5640291 1.1421754 0.6583837 -0.2631914 -0.41410238 0.827402 -1.2386919 0.48388213 -0.28236762 -0.15283634 -0.42824042 -0.40090135 -0.77587223 -0.6166379 -0.49208662 0.8527232 -0.25537646 -0.19852413 -0.23869091 0.31214806 -0.04798355 -0.34941798 -0.43691263 -0.23344557 -0.35412952 -0.7309862 0.06778439 0.47784337 1.2664595 -0.004899377 -0.45473257 0.21764505 -0.06893795 0.26171938 -0.6801437 -0.47791085 -0.05452985 0.11344756 0.36638817 0.36058345 0.042462453 -0.40825224 -0.85838044 -0.6933064 -0.81180286 0.44378766 -0.5181301 -0.11305927 -0.20757543 -1.1101619 0.78879565 0.83018565 -1.0229331; -0.5856906 0.6449451 0.4374825 0.29447493 0.46150827 0.046752594 0.8770593 -0.78653765 0.16284811 -0.11953334 -0.0018584251 0.54712534 0.004490006 -0.86700964 -0.0022601539 0.29619938 0.18162979 0.17869131 -0.5319875 -0.6206679 0.9544959 -0.838025 0.2058192 0.33219576 -0.015659422 -0.09044209 -0.16765438 0.8299109 -1.0876726 -0.007671559 0.53623825 0.2726129 -0.31245232 1.2936312 0.28118685 0.1985305 0.14696534 0.32260662 0.7490277 0.592123 0.113355815 -0.43908283 -0.86684865 -0.42094654 0.85097665 -0.25465974 -0.7464633 0.7137374 0.40135983 0.3069822 0.8610962 0.8050838 -0.3910152 -0.81901026 -0.8727943 -1.017949 -0.35257435 0.8115456 -0.1488147 0.93100035 -0.017390462 0.20241569 0.48630732 0.14683717 -0.72726864 -0.048070423 -0.39406762 0.36814922 0.6111064 0.8893036 0.08391308 0.9238037 -0.41604492 0.7023563 0.025424195 -0.5795869 1.2137849 -0.098147355 0.15586352 1.0109761; -0.42541462 0.32424203 0.86214805 -0.5651751 -0.6679951 -0.07733576 0.33466423 -0.53944963 0.25476867 -0.6710733 0.017677562 0.80884415 -0.5439146 -0.30696452 -0.12838484 0.4041813 -0.46754622 0.53363234 -0.7607421 -0.25951436 0.7344465 -0.4628497 0.060120363 0.2877557 -1.104821 -0.6206035 -0.69370306 0.5240109 -1.0708169 -0.5063814 0.16984653 0.38062122 -0.91023946 1.069171 -0.5730446 0.26362127 -0.023323564 0.2508909 0.34519202 0.8295105 0.70671004 0.2666974 -1.0945648 0.18278798 0.13215856 0.5366457 -0.3782765 0.055013962 0.23917349 0.28089654 0.537983 0.22547096 0.6532276 -0.22608604 -0.40558776 -1.1093858 0.13878547 0.26265085 -0.44862843 -0.07703795 -0.16948664 0.7002793 0.5725914 0.02344542 -0.020741576 -0.3312431 -0.5449191 -0.053181026 0.4982092 0.8420069 0.77665025 0.9635407 -0.5566481 0.23879287 0.08389774 0.39132315 0.8438442 -0.63247496 -0.83884573 1.1043278; -0.2551757 0.23205899 0.5344087 -0.36046413 -0.3617732 -0.6875779 0.15608583 0.102507815 0.6548215 -0.4364553 -0.36901727 1.0930318 -0.53572947 -0.2326475 -0.5744583 0.50531924 -0.57905906 0.50366867 -1.0793898 -0.004463659 -0.5253439 0.048544515 0.7280872 0.5730283 -0.736582 -0.8560545 -0.68071234 0.18968315 0.35546106 -0.83467925 0.29370853 0.67893004 -0.56120104 -0.21498138 -0.24145113 0.4868429 0.5261039 0.46056035 0.26452675 1.2296778 0.5082737 0.43039843 -0.6776324 0.54748666 0.22617342 0.5673428 0.09350795 -0.07628128 0.6594402 0.59091794 0.32770118 -0.15964967 0.586319 -0.08490062 -0.077594824 0.1727342 0.41222656 0.11925774 -0.43396932 0.12632066 -0.6285696 0.6455863 0.77376866 0.44874483 0.4919099 -0.5281902 0.4693769 0.13624637 0.06012181 0.91550875 0.29466268 0.6069565 -0.3025499 -0.055930164 0.676425 0.37318 -0.43908584 -0.70566887 -0.5598418 0.7157957; -0.45388776 0.16449961 0.90343297 -1.2007117 -1.4739429 -0.07380529 -0.0029230667 -0.04068418 -0.11501915 -1.1131018 0.5653297 0.6673362 -0.3318103 0.24300362 0.22837149 0.116136566 -1.354414 1.0661125 -0.620885 0.29809502 0.9664146 0.18993473 -0.105114534 0.30126408 -0.77965516 -1.2229792 -0.7878128 -0.055680547 -0.93918306 -0.5772535 0.26670352 0.3283475 -0.8428306 1.1106213 -1.2854275 0.402824 -0.24313596 0.18616703 -0.41323054 0.65163344 1.2610291 1.0948477 -0.71271384 1.0447159 -0.5908056 1.0017592 0.011493528 -0.57853913 0.40963158 0.4142463 -0.15672404 -0.55913687 1.3220168 0.4626208 0.05319711 -0.9023608 0.9729591 0.2046787 -0.16236992 -0.5159132 0.13647774 1.0517217 0.7346919 -0.21607156 0.53727293 -0.051795077 -0.9556078 -0.06376014 0.6063809 0.3872698 1.4560503 0.7738717 -0.52296567 -0.22175431 0.095214084 0.83494514 1.0179209 -1.3714886 -0.89093095 0.8927683], bias = Float32[-0.2519872; -0.5711542; -0.12135788; 0.37640795; -0.06568255; -0.22384962; -0.073596366; 0.17749515; 0.62892336; -0.5236463; -0.4164918; -0.5406355; 0.6251047; -0.55256355; -0.42960998; 0.36187625; 0.3868027; 0.45823833; -0.10939644; 0.25492853; 0.6299996; 0.25252846; 0.20273677; -0.67815197; -0.29260898; 0.090457484; 0.76590866; 0.67468995; 0.14826547; -0.092568584; -0.8083523; -0.23812453; -0.64937836; -0.432264; 0.08066398; 0.4254412; -0.727207; -0.10369544; 0.87636465; -0.21324806; -0.63142914; 0.43999165; 0.2534421; 0.076737836; -0.7535454; -0.36315843; 0.48556834; -0.40958554; -0.43652347; -0.18751545; 0.34631565; -0.5190007; -0.48141456; 0.49690428; 0.4427188; -0.23814626; -0.21622443; -0.43564996; 0.7314569; 0.055993646; 0.43756282; -0.027094545; 0.3400142; -0.5983429; -0.7389815; 0.21653326; 0.21862619; 0.58304775; -0.4698149; 0.6450971; 0.44700944; 0.24432509; -0.8897207; -0.41913858; -0.4291126; 0.2981714; -0.031596594; -0.2388085; -0.15413862; -0.57317275]), layer_3 = (weight = Float32[-0.54151165 -0.20084384 0.32429445 -0.26496622 0.48314735 0.25574142 -0.33710736 -0.3548876 0.23301764 0.012748386 -0.28954706 -0.3627343 0.1749612 0.20931342 -0.1336172 0.5169251 0.5162542 0.08284677 0.40157884 -0.5131602 0.1636709 0.15790501 0.69144994 -0.2784612 0.001577029 -0.5030171 0.25141305 0.33458695 -0.39827678 -0.4984987 -0.33118027 -0.6718359 0.05590712 0.047717888 0.5188066 0.43286455 -0.2456821 0.071697764 0.3210949 -0.12571263 -0.44988587 0.42044276 0.17918642 -0.49375677 -0.28177857 -0.31879058 -0.045837294 0.7060099 0.26286793 -0.074593365 -0.08866066 -0.07073152 -0.2501734 -0.0074328985 0.5208149 -0.25040454 0.33363083 -0.38367596 0.20841496 0.12279592 -0.02128244 0.35299277 -0.0019276848 -0.5699401 0.053086773 0.12480441 -0.32237417 0.18564537 -0.24735597 -0.0012879029 0.5672365 0.5167118 -0.37301818 -0.4124746 -0.11679416 -0.29980418 0.4802128 0.2744162 0.49394912 0.0023743678; 0.17642584 0.37979776 -0.2980703 0.04606806 -0.20071732 -0.10764381 0.19674009 0.2914769 -0.1154205 -0.28659892 0.22579496 0.25840417 0.0072632134 -0.48577127 0.20990932 -0.1050317 -0.0929488 -0.0015168539 -0.3994748 0.3621059 0.1908213 -0.45810246 -0.20087369 0.3365921 0.120047234 0.29119456 0.06274058 -0.33834907 0.27252734 0.010620255 -0.26271406 0.21762338 -0.41792038 0.22293624 -0.19172302 -0.06251925 -0.1035892 -0.40805003 0.1922958 0.3373957 0.09549243 -0.2208641 -0.31811845 0.22330163 -0.07417846 0.08493778 0.51123387 -0.86313397 -0.3983798 -0.43056896 0.41328394 -0.008401961 0.22270401 0.5204525 -0.0534824 0.3578642 -0.44309285 0.23009825 0.15347043 -0.4715557 -0.09621855 -0.35291782 -0.24686517 -0.0017777536 -0.3922649 -0.42004687 0.39989942 -0.057825517 0.053920932 0.62215024 -0.023835013 -0.23375636 -0.16694975 0.22977298 0.15067886 0.45522496 -0.19132766 -0.48198992 -0.16371992 -0.5804907], bias = Float32[-0.6925775; 0.5882862]))

loss_neuralode(p_trained_high)